/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.vertexium.accumulo.AccumuloGraph;
import org.vertexium.accumulo.StreamingPropertyValueTableRef;
import org.vertexium.property.StreamingPropertyValue;

class StreamingPropertyValueTable
extends StreamingPropertyValue {
    private final AccumuloGraph graph;
    private final String dataRowKey;
    private transient byte[] data;

    StreamingPropertyValueTable(AccumuloGraph graph, String dataRowKey, StreamingPropertyValueTableRef valueRef) {
        super(null, valueRef.getValueType());
        this.store(valueRef.isStore());
        this.searchIndex(valueRef.isSearchIndex());
        this.graph = graph;
        this.dataRowKey = dataRowKey;
        this.data = valueRef.getData();
    }

    public long getLength() {
        this.ensureDataLoaded();
        return this.data.length;
    }

    public String getDataRowKey() {
        return this.dataRowKey;
    }

    public boolean isDataLoaded() {
        return this.data != null;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public InputStream getInputStream() {
        this.ensureDataLoaded();
        return new ByteArrayInputStream(this.data);
    }

    private void ensureDataLoaded() {
        if (!this.isDataLoaded()) {
            this.data = this.graph.streamingPropertyValueTableData(this.dataRowKey);
        }
    }
}

