/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.TreeMapBackedSortedColumns;
import org.apache.cassandra.db.columniterator.IColumnIteratorFactory;
import org.apache.cassandra.db.columniterator.LazyColumnIterator;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.MergeIterator;

public class RowIteratorFactory {
    private static final Comparator<OnDiskAtomIterator> COMPARE_BY_KEY = new Comparator<OnDiskAtomIterator>(){

        @Override
        public int compare(OnDiskAtomIterator o1, OnDiskAtomIterator o2) {
            return DecoratedKey.comparator.compare(o1.getKey(), o2.getKey());
        }
    };

    public static CloseableIterator<Row> getIterator(Iterable<Memtable> memtables, Collection<SSTableReader> sstables, final DataRange range, final ColumnFamilyStore cfs, final long now) {
        ArrayList<CloseableIterator<OnDiskAtomIterator>> iterators = new ArrayList<CloseableIterator<OnDiskAtomIterator>>();
        for (Memtable memtable : memtables) {
            iterators.add(new ConvertToColumnIterator(range, memtable.getEntryIterator(range.startKey(), range.stopKey())));
        }
        for (SSTableReader sstable : sstables) {
            SSTableScanner scanner = sstable.getScanner(range);
            iterators.add(scanner);
        }
        return MergeIterator.get(iterators, COMPARE_BY_KEY, new MergeIterator.Reducer<OnDiskAtomIterator, Row>(){
            private final int gcBefore;
            private final List<OnDiskAtomIterator> colIters;
            private DecoratedKey key;
            private ColumnFamily returnCF;
            {
                this.gcBefore = cfs.gcBefore(now);
                this.colIters = new ArrayList<OnDiskAtomIterator>();
            }

            @Override
            protected void onKeyChange() {
                this.returnCF = TreeMapBackedSortedColumns.factory.create(cfs.metadata);
            }

            @Override
            public void reduce(OnDiskAtomIterator current) {
                this.colIters.add(current);
                this.key = current.getKey();
                this.returnCF.delete(current.getColumnFamily());
            }

            @Override
            protected Row getReduced() {
                ColumnFamily cached = cfs.getRawCachedRow(this.key);
                if (cached == null) {
                    QueryFilter.collateOnDiskAtom(this.returnCF, this.colIters, range.columnFilter(this.key.key), this.gcBefore, now);
                } else {
                    QueryFilter keyFilter = new QueryFilter(this.key, cfs.name, range.columnFilter(this.key.key), now);
                    this.returnCF = cfs.filterColumnFamily(cached, keyFilter);
                }
                Row rv = new Row(this.key, this.returnCF);
                this.colIters.clear();
                this.key = null;
                return rv;
            }
        });
    }

    private static class ConvertToColumnIterator<T extends ColumnFamily>
    implements CloseableIterator<OnDiskAtomIterator> {
        private final DataRange range;
        private final Iterator<Map.Entry<DecoratedKey, T>> iter;

        public ConvertToColumnIterator(DataRange range, Iterator<Map.Entry<DecoratedKey, T>> iter) {
            this.range = range;
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public OnDiskAtomIterator next() {
            final Map.Entry<DecoratedKey, T> entry = this.iter.next();
            return new LazyColumnIterator(entry.getKey(), new IColumnIteratorFactory(){

                @Override
                public OnDiskAtomIterator create() {
                    return ConvertToColumnIterator.this.range.columnFilter(((DecoratedKey)entry.getKey()).key).getColumnFamilyIterator((DecoratedKey)entry.getKey(), (ColumnFamily)entry.getValue());
                }
            });
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }
    }
}

