/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.compaction.LeveledManifest;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableMetadata;
import org.apache.cassandra.utils.Pair;

public class SSTableLevelResetter {
    public static void main(String[] args) throws IOException {
        PrintStream out = System.out;
        if (args.length == 0) {
            out.println("This command should be run with Cassandra stopped!");
            out.println("Usage: sstablelevelreset <keyspace> <columnfamily>");
            System.exit(1);
        }
        if (!args[0].equals("--really-reset") || args.length != 3) {
            out.println("This command should be run with Cassandra stopped, otherwise you will get very strange behavior");
            out.println("Verify that Cassandra is not running and then execute the command like this:");
            out.println("Usage: sstablelevelreset --really-reset <keyspace> <columnfamily>");
            System.exit(1);
        }
        String keyspace = args[1];
        String columnfamily = args[2];
        Directories directories = Directories.create(keyspace, columnfamily);
        boolean foundSSTable = false;
        for (Map.Entry<Descriptor, Set<Component>> sstable : directories.sstableLister().list().entrySet()) {
            if (!sstable.getValue().contains(Component.STATS)) continue;
            foundSSTable = true;
            Descriptor descriptor = sstable.getKey();
            Pair<SSTableMetadata, Set<Integer>> metadata = SSTableMetadata.serializer.deserialize(descriptor);
            out.println("Changing level from " + ((SSTableMetadata)metadata.left).sstableLevel + " to 0 on " + descriptor.filenameFor(Component.DATA));
            LeveledManifest.mutateLevel(metadata, descriptor, descriptor.filenameFor(Component.STATS), 0);
        }
        if (!foundSSTable) {
            out.println("Found no sstables, did you give the correct keyspace/columnfamily?");
        }
    }
}

