/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.hbase.util.Bytes;

public class RowMutations
implements Row {
    private List<Mutation> mutations = new ArrayList<Mutation>();
    private byte[] row;
    private static final byte VERSION = 0;

    public RowMutations() {
    }

    public RowMutations(byte[] row) {
        if (row == null || row.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Row key is invalid");
        }
        this.row = Arrays.copyOf(row, row.length);
    }

    public void add(Put p) throws IOException {
        this.internalAdd(p);
    }

    public void add(Delete d) throws IOException {
        this.internalAdd(d);
    }

    private void internalAdd(Mutation m) throws IOException {
        int res = Bytes.compareTo(this.row, m.getRow());
        if (res != 0) {
            throw new IOException("The row in the recently added Put/Delete " + Bytes.toStringBinary(m.getRow()) + " doesn't match the original one " + Bytes.toStringBinary(this.row));
        }
        this.mutations.add(m);
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version > 0) {
            throw new IOException("version not supported");
        }
        this.row = Bytes.readByteArray(in);
        int numMutations = in.readInt();
        this.mutations.clear();
        for (int i = 0; i < numMutations; ++i) {
            this.mutations.add((Mutation)HbaseObjectWritable.readObject(in, null));
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(0);
        Bytes.writeByteArray(out, this.row);
        out.writeInt(this.mutations.size());
        for (Mutation m : this.mutations) {
            HbaseObjectWritable.writeObject(out, m, m.getClass(), null);
        }
    }

    public int compareTo(Row i) {
        return Bytes.compareTo(this.getRow(), i.getRow());
    }

    @Override
    public byte[] getRow() {
        return this.row;
    }

    public List<Mutation> getMutations() {
        return Collections.unmodifiableList(this.mutations);
    }
}

