/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.master;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class AssignmentManagerStatusTmplImpl
extends AbstractTemplateImpl
implements AssignmentManagerStatusTmpl.Intf {
    private final AssignmentManager assignmentManager;
    private final int limit;

    protected static AssignmentManagerStatusTmpl.ImplData __jamon_setOptionalArguments(AssignmentManagerStatusTmpl.ImplData p_implData) {
        if (!p_implData.getLimit__IsNotDefault()) {
            p_implData.setLimit(100);
        }
        return p_implData;
    }

    public AssignmentManagerStatusTmplImpl(TemplateManager p_templateManager, AssignmentManagerStatusTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)AssignmentManagerStatusTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.assignmentManager = p_implData.getAssignmentManager();
        this.limit = p_implData.getLimit();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        NavigableMap<String, AssignmentManager.RegionState> rit = this.assignmentManager.getRegionsInTransition();
        int toRemove = rit.size() - this.limit;
        int removed = 0;
        if (toRemove > 0) {
            Iterator it = rit.entrySet().iterator();
            while (it.hasNext() && toRemove > 0) {
                Map.Entry e = it.next();
                if (HRegionInfo.FIRST_META_REGIONINFO.getEncodedName().equals(e.getKey()) || HRegionInfo.ROOT_REGIONINFO.getEncodedName().equals(e.getKey())) continue;
                it.remove();
                --toRemove;
                ++removed;
            }
        }
        jamonWriter.write("<h2>Regions in Transition</h2>\n");
        if (rit.isEmpty()) {
            jamonWriter.write("\nNo regions in transition.\n");
        } else {
            jamonWriter.write("\n\t<table>\n\t\t<tr><th>Region</th><th>State</th></tr>\n\t\t");
            for (Map.Entry entry : rit.entrySet()) {
                jamonWriter.write("\n\t\t<tr><td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)((String)entry.getKey())), jamonWriter);
                jamonWriter.write("</td><td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)((AssignmentManager.RegionState)entry.getValue()).toDescriptiveString()), jamonWriter);
                jamonWriter.write("</td>\n\t\t");
            }
            jamonWriter.write("\n\t</table>\n\t");
            if (removed > 0) {
                jamonWriter.write("\n\t(");
                Escaping.HTML.write(StandardEmitter.valueOf((int)removed), jamonWriter);
                jamonWriter.write(" more regions in transition not shown) \n\t");
            }
            jamonWriter.write("\n");
        }
    }
}

