/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.fulgora;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.olap.Combiner;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.fulgora.FulgoraRelationQuery;
import java.util.List;
import javax.annotation.Nullable;

class FulgoraPropertyQuery<M>
extends FulgoraRelationQuery<M> {
    final Function<TitanProperty, M> gather;
    public static final Function<TitanProperty, Object> SINGLE_VALUE_GATHER = new Function<TitanProperty, Object>(){

        public Object apply(TitanProperty titanProperty) {
            return titanProperty.getValue();
        }
    };
    public static final Function<TitanProperty, List<Object>> VALUE_LIST_GATHER = new Function<TitanProperty, List<Object>>(){

        public List<Object> apply(TitanProperty titanProperty) {
            return Lists.newArrayList((Object[])new Object[]{titanProperty.getValue()});
        }
    };
    public static final Combiner<Object> SINGLE_COMBINER = new Combiner<Object>(){

        @Override
        public Object combine(Object m1, Object m2) {
            throw new IllegalStateException("Expected at most one value but got multiple");
        }
    };
    public static final Combiner<List<Object>> VALUE_LIST_COMBINER = new Combiner<List<Object>>(){

        @Override
        public List<Object> combine(List<Object> m1, List<Object> m2) {
            m1.addAll(m2);
            return m1;
        }
    };

    FulgoraPropertyQuery(List<SliceQuery> query, Function<TitanProperty, M> gather, Combiner<M> combiner) {
        super(query, combiner);
        this.gather = gather;
    }

    M process(TitanProperty p, @Nullable M previous) {
        Object result = this.gather.apply((Object)p);
        if (previous == null) {
            return (M)result;
        }
        return (M)this.combiner.combine(previous, result);
    }
}

