/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.google.common.base.Preconditions;
import com.netflix.astyanax.serializers.CompositeSerializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;

public class SpecificCompositeSerializer
extends CompositeSerializer {
    private final CompositeType type;
    private List<String> comparators;

    public SpecificCompositeSerializer(CompositeType type) {
        Preconditions.checkNotNull((Object)type);
        this.type = type;
        this.comparators = new ArrayList<String>(type.types.size());
        for (AbstractType compType : type.types) {
            String typeName = compType.toString();
            if (typeName.startsWith("org.apache.cassandra.db.marshal.")) {
                typeName = typeName.substring("org.apache.cassandra.db.marshal.".length());
            }
            this.comparators.add(typeName);
        }
    }

    @Override
    public ByteBuffer fromString(String string) {
        return this.type.fromString(string);
    }

    @Override
    public String getString(ByteBuffer byteBuffer) {
        return this.type.getString(byteBuffer);
    }

    @Override
    public List<String> getComparators() {
        return this.comparators;
    }
}

