/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch.utils;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.vertexium.Element;
import org.vertexium.VertexiumException;
import org.vertexium.elasticsearch.ElasticSearchGraphQueryIterable;
import org.vertexium.query.AggregationResult;
import org.vertexium.query.GeohashResult;
import org.vertexium.query.HistogramResult;
import org.vertexium.query.IterableWithGeohashResults;
import org.vertexium.query.IterableWithHistogramResults;
import org.vertexium.query.IterableWithScores;
import org.vertexium.query.IterableWithStatisticsResults;
import org.vertexium.query.IterableWithTermsResults;
import org.vertexium.query.IterableWithTotalHits;
import org.vertexium.query.QueryResultsIterable;
import org.vertexium.query.StatisticsResult;
import org.vertexium.query.TermsResult;

public abstract class PagingIterable<T extends Element>
implements Iterable<T>,
IterableWithTotalHits<T>,
IterableWithScores<T>,
IterableWithHistogramResults<T>,
IterableWithTermsResults<T>,
IterableWithGeohashResults<T>,
IterableWithStatisticsResults<T>,
QueryResultsIterable<T> {
    private final long skip;
    private final Long limit;
    private boolean isFirstCallToIterator;
    private final ElasticSearchGraphQueryIterable<T> firstIterable;
    private final int pageSize;

    public PagingIterable(long skip, Long limit, int pageSize) {
        this.skip = skip;
        this.limit = limit;
        this.pageSize = pageSize;
        int firstIterableLimit = Math.min(pageSize, limit == null ? Integer.MAX_VALUE : limit.intValue());
        this.firstIterable = this.getPageIterable((int)this.skip, firstIterableLimit, true);
        this.isFirstCallToIterator = true;
    }

    public GeohashResult getGeohashResults(String name) {
        return this.firstIterable.getGeohashResults(name);
    }

    public HistogramResult getHistogramResults(String name) {
        return this.firstIterable.getHistogramResults(name);
    }

    public StatisticsResult getStatisticsResults(String name) {
        return this.firstIterable.getStatisticsResults(name);
    }

    public TermsResult getTermsResults(String name) {
        return this.firstIterable.getTermsResults(name);
    }

    public Map<String, Double> getScores() {
        return this.firstIterable.getScores();
    }

    public void close() throws IOException {
    }

    public <TResult extends AggregationResult> TResult getAggregationResult(String name, Class<? extends TResult> resultType) {
        return this.firstIterable.getAggregationResult(name, resultType);
    }

    public long getTotalHits() {
        return this.firstIterable.getTotalHits();
    }

    protected abstract ElasticSearchGraphQueryIterable<T> getPageIterable(int var1, int var2, boolean var3);

    @Override
    public Iterator<T> iterator() {
        MyIterator<T> it = new MyIterator<T>(this.isFirstCallToIterator ? this.firstIterable : null, this.skip, this.limit, this.pageSize, new GetPageIterableFunction<T>(){

            @Override
            public ElasticSearchGraphQueryIterable<T> getPageIterable(int skip, int limit, boolean includeAggregations) {
                return PagingIterable.this.getPageIterable(skip, limit, includeAggregations);
            }
        });
        this.isFirstCallToIterator = false;
        return it;
    }

    private static class MyIterator<T extends Element>
    implements Iterator<T> {
        private ElasticSearchGraphQueryIterable<T> firstIterable;
        private final int pageSize;
        private final GetPageIterableFunction<T> getPageIterableFunction;
        private int nextSkip;
        private int limit;
        private int currentIteratorCount;
        private Iterator<T> currentIterator;

        public MyIterator(ElasticSearchGraphQueryIterable<T> firstIterable, long skip, Long limit, int pageSize, GetPageIterableFunction<T> getPageIterableFunction) {
            this.firstIterable = firstIterable;
            this.pageSize = pageSize;
            this.getPageIterableFunction = getPageIterableFunction;
            this.nextSkip = (int)skip;
            this.limit = (int)(limit == null ? Integer.MAX_VALUE : limit);
            this.currentIterator = this.getNextIterator();
        }

        @Override
        public boolean hasNext() {
            while (true) {
                if (this.currentIterator == null) {
                    if (this.currentIteratorCount == 0) {
                        return false;
                    }
                    this.currentIterator = this.getNextIterator();
                    if (this.currentIterator == null) {
                        return false;
                    }
                }
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                this.currentIterator = null;
            }
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                --this.limit;
                ++this.currentIteratorCount;
                return (T)((Element)this.currentIterator.next());
            }
            throw new NoSuchElementException();
        }

        private Iterator<T> getNextIterator() {
            if (this.limit <= 0) {
                return null;
            }
            int limit = Math.min(this.pageSize, this.limit);
            this.currentIteratorCount = 0;
            if (this.firstIterable == null) {
                this.firstIterable = this.getPageIterableFunction.getPageIterable(this.nextSkip, limit, false);
            }
            Iterator it = this.firstIterable.iterator();
            this.firstIterable = null;
            this.nextSkip += limit;
            return it;
        }

        @Override
        public void remove() {
            throw new VertexiumException("remove not implemented");
        }
    }

    private static interface GetPageIterableFunction<T extends Element> {
        public ElasticSearchGraphQueryIterable<T> getPageIterable(int var1, int var2, boolean var3);
    }
}

