/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.admin;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.iterators.IteratorUtil;

public class NewTableConfiguration {
    private static final TimeType DEFAULT_TIME_TYPE = TimeType.MILLIS;
    private TimeType timeType = DEFAULT_TIME_TYPE;
    private boolean limitVersion = true;
    private Map<String, String> properties = new HashMap<String, String>();

    public NewTableConfiguration setTimeType(TimeType tt) {
        Preconditions.checkArgument((tt != null ? 1 : 0) != 0, (Object)"TimeType is null");
        this.timeType = tt;
        return this;
    }

    public TimeType getTimeType() {
        return this.timeType;
    }

    public NewTableConfiguration withoutDefaultIterators() {
        this.limitVersion = false;
        return this;
    }

    public NewTableConfiguration setProperties(Map<String, String> prop) {
        Preconditions.checkArgument((prop != null ? 1 : 0) != 0, (Object)"properties is null");
        this.properties = new HashMap<String, String>(prop);
        return this;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (this.limitVersion) {
            propertyMap.putAll(IteratorUtil.generateInitialTableProperties(this.limitVersion));
        }
        propertyMap.putAll(this.properties);
        return Collections.unmodifiableMap(propertyMap);
    }
}

