/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.ReplicationOperations;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ClientExecReturn;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.client.replication.PeerExistsException;
import org.apache.accumulo.core.client.replication.PeerNotFoundException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationOperationsImpl
implements ReplicationOperations {
    private static final Logger log = LoggerFactory.getLogger(ReplicationOperationsImpl.class);
    private final ClientContext context;

    public ReplicationOperationsImpl(ClientContext context) {
        Objects.requireNonNull(context);
        this.context = context;
    }

    @Override
    public void addPeer(String name, String replicaType) throws AccumuloException, AccumuloSecurityException, PeerExistsException {
        Objects.requireNonNull(name);
        Objects.requireNonNull(replicaType);
        this.context.getConnector().instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + name, replicaType);
    }

    @Override
    public void removePeer(String name) throws AccumuloException, AccumuloSecurityException, PeerNotFoundException {
        Objects.requireNonNull(name);
        this.context.getConnector().instanceOperations().removeProperty(Property.REPLICATION_PEERS.getKey() + name);
    }

    @Override
    public void drain(String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Objects.requireNonNull(tableName);
        Set<String> wals = this.referencedFiles(tableName);
        this.drain(tableName, wals);
    }

    @Override
    public void drain(String tableName, Set<String> wals) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Objects.requireNonNull(tableName);
        TInfo tinfo = Tracer.traceInfo();
        TCredentials rpcCreds = this.context.rpcCreds();
        boolean drained = false;
        while (!drained) {
            drained = this.getMasterDrain(tinfo, rpcCreds, tableName, wals);
            if (drained) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Thread interrupted", e);
            }
        }
    }

    protected boolean getMasterDrain(final TInfo tinfo, final TCredentials rpcCreds, final String tableName, final Set<String> wals) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        return MasterClient.execute(this.context, new ClientExecReturn<Boolean, MasterClientService.Client>(){

            @Override
            public Boolean execute(MasterClientService.Client client) throws Exception {
                return client.drainReplicationTable(tinfo, rpcCreds, tableName, wals);
            }
        });
    }

    protected Text getTableId(Connector conn, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        TableOperations tops = conn.tableOperations();
        if (!conn.tableOperations().exists(tableName)) {
            throw new TableNotFoundException(null, tableName, null);
        }
        String strTableId = null;
        while (null == strTableId) {
            strTableId = tops.tableIdMap().get(tableName);
            if (null != strTableId) continue;
            UtilWaitThread.sleep(200L);
        }
        return new Text(strTableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> referencedFiles(String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Objects.requireNonNull(tableName);
        log.debug("Collecting referenced files for replication of table {}", (Object)tableName);
        Connector conn = this.context.getConnector();
        Text tableId = this.getTableId(conn, tableName);
        log.debug("Found id of {} for name {}", (Object)tableId, (Object)tableName);
        BatchScanner metaBs = conn.createBatchScanner("accumulo.metadata", Authorizations.EMPTY, 4);
        metaBs.setRanges(Collections.singleton(MetadataSchema.TabletsSection.getRange(tableId.toString())));
        metaBs.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
        HashSet<String> wals = new HashSet<String>();
        try {
            for (Map.Entry<Key, Value> entry : metaBs) {
                LogEntry logEntry = LogEntry.fromKeyValue(entry.getKey(), entry.getValue());
                for (String log : logEntry.logSet) {
                    wals.add(new Path(log).toString());
                }
            }
        }
        finally {
            metaBs.close();
        }
        metaBs = conn.createBatchScanner("accumulo.metadata", Authorizations.EMPTY, 4);
        metaBs.setRanges(Collections.singleton(MetadataSchema.ReplicationSection.getRange()));
        metaBs.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
        try {
            Text buffer = new Text();
            for (Map.Entry<Key, Value> entry : metaBs) {
                MetadataSchema.ReplicationSection.getTableId(entry.getKey(), buffer);
                if (!buffer.equals((Object)tableId)) continue;
                MetadataSchema.ReplicationSection.getFile(entry.getKey(), buffer);
                wals.add(buffer.toString());
            }
        }
        finally {
            metaBs.close();
        }
        return wals;
    }
}

