/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationObserver;

public abstract class ObservableConfiguration
extends AccumuloConfiguration {
    private Set<ConfigurationObserver> observers = Collections.synchronizedSet(new HashSet());

    public void addObserver(ConfigurationObserver co) {
        Objects.requireNonNull(co);
        this.observers.add(co);
    }

    public void removeObserver(ConfigurationObserver co) {
        this.observers.remove(co);
    }

    public Collection<ConfigurationObserver> getObservers() {
        return ObservableConfiguration.snapshot(this.observers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<ConfigurationObserver> snapshot(Collection<ConfigurationObserver> observers) {
        ArrayList<ConfigurationObserver> c = new ArrayList<ConfigurationObserver>();
        Collection<ConfigurationObserver> collection = observers;
        synchronized (collection) {
            c.addAll(observers);
        }
        return c;
    }

    public void expireAllObservers() {
        Collection<ConfigurationObserver> copy = ObservableConfiguration.snapshot(this.observers);
        for (ConfigurationObserver co : copy) {
            co.sessionExpired();
        }
    }

    public void propertyChanged(String key) {
        Collection<ConfigurationObserver> copy = ObservableConfiguration.snapshot(this.observers);
        for (ConfigurationObserver co : copy) {
            co.propertyChanged(key);
        }
    }

    public void propertiesChanged() {
        Collection<ConfigurationObserver> copy = ObservableConfiguration.snapshot(this.observers);
        for (ConfigurationObserver co : copy) {
            co.propertiesChanged();
        }
    }
}

