/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.trace;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.htrace.Sampler;
import org.apache.htrace.TraceInfo;
import org.apache.htrace.Tracer;
import org.apache.htrace.wrappers.TraceProxy;
import org.apache.htrace.wrappers.TraceRunnable;

public class Trace {
    public static Span on(String description) {
        return Trace.on(description, Sampler.ALWAYS);
    }

    public static <T> Span on(String description, Sampler<T> sampler) {
        return new Span(org.apache.htrace.Trace.startSpan((String)description, sampler));
    }

    public static void off() {
        org.apache.htrace.Span span = org.apache.htrace.Trace.currentSpan();
        if (span != null) {
            span.stop();
            Tracer.getInstance().continueSpan(null).close();
        }
    }

    @Deprecated
    public static void offNoFlush() {
        Trace.off();
    }

    public static boolean isTracing() {
        return org.apache.htrace.Trace.isTracing();
    }

    @Deprecated
    public static Span currentTrace() {
        return new Span(org.apache.htrace.Trace.currentSpan());
    }

    public static long currentTraceId() {
        return org.apache.htrace.Trace.currentSpan().getTraceId();
    }

    public static Span start(String description) {
        return new Span(org.apache.htrace.Trace.startSpan((String)description));
    }

    public static Span trace(TInfo info, String description) {
        if (info.traceId == 0L) {
            return Span.NULL_SPAN;
        }
        TraceInfo ti = new TraceInfo(info.traceId, info.parentId);
        return new Span(org.apache.htrace.Trace.startSpan((String)description, (TraceInfo)ti));
    }

    public static void data(String k, String v) {
        org.apache.htrace.Span span = org.apache.htrace.Trace.currentSpan();
        if (span != null) {
            span.addKVAnnotation(k.getBytes(StandardCharsets.UTF_8), v.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static Runnable wrap(Runnable runnable) {
        if (Trace.isTracing()) {
            return new TraceRunnable(org.apache.htrace.Trace.currentSpan(), runnable);
        }
        return runnable;
    }

    public static <T> T wrapAll(T instance) {
        return (T)TraceProxy.trace(instance);
    }

    public static <T, V> T wrapAll(T instance, Sampler<V> dist) {
        return (T)TraceProxy.trace(instance, dist);
    }
}

