/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.edgelist.rdf;

import com.thinkaurelius.titan.hadoop.FaunusElement;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompiler;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.MapReduceFormat;
import com.thinkaurelius.titan.hadoop.formats.edgelist.EdgeListInputMapReduce;
import com.thinkaurelius.titan.hadoop.formats.edgelist.rdf.RDFRecordReader;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class RDFInputFormat
extends FileInputFormat<NullWritable, FaunusElement>
implements MapReduceFormat {
    public RecordReader<NullWritable, FaunusElement> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new RDFRecordReader(ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration(context)));
    }

    protected boolean isSplitable(JobContext context, Path file) {
        return null == new CompressionCodecFactory(HadoopCompatLoader.DEFAULT_COMPAT.getJobContextConfiguration(context)).getCodec(file);
    }

    @Override
    public void addMapReduceJobs(HadoopCompiler compiler) {
        compiler.addMapReduce(EdgeListInputMapReduce.Map.class, EdgeListInputMapReduce.Combiner.class, EdgeListInputMapReduce.Reduce.class, LongWritable.class, FaunusVertex.class, NullWritable.class, FaunusVertex.class, new EmptyConfiguration());
    }
}

