/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.EdgeVertices;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;
import org.vertexium.accumulo.AccumuloElement;
import org.vertexium.accumulo.AccumuloGraph;
import org.vertexium.accumulo.iterator.EdgeIterator;
import org.vertexium.accumulo.util.DataInputStreamUtils;
import org.vertexium.mutation.ExistingEdgeMutation;
import org.vertexium.mutation.PropertyDeleteMutation;
import org.vertexium.mutation.PropertySoftDeleteMutation;
import org.vertexium.util.IterableUtils;

public class AccumuloEdge
extends AccumuloElement
implements Edge {
    public static final Text CF_SIGNAL = EdgeIterator.CF_SIGNAL;
    public static final Text CF_OUT_VERTEX = EdgeIterator.CF_OUT_VERTEX;
    public static final Text CF_IN_VERTEX = EdgeIterator.CF_IN_VERTEX;
    private final String outVertexId;
    private final String inVertexId;
    private final String label;
    private final String newEdgeLabel;

    public AccumuloEdge(Graph graph, String id, String outVertexId, String inVertexId, String label, String newEdgeLabel, Visibility visibility, Iterable<Property> properties, Iterable<PropertyDeleteMutation> propertyDeleteMutations, Iterable<PropertySoftDeleteMutation> propertySoftDeleteMutations, Iterable<Visibility> hiddenVisibilities, long timestamp, Authorizations authorizations) {
        super(graph, id, visibility, properties, propertyDeleteMutations, propertySoftDeleteMutations, hiddenVisibilities, timestamp, authorizations);
        this.outVertexId = outVertexId;
        this.inVertexId = inVertexId;
        this.label = label;
        this.newEdgeLabel = newEdgeLabel;
    }

    public static Edge createFromIteratorValue(AccumuloGraph graph, Key key, Value value, Authorizations authorizations) {
        try {
            ArrayList<PropertyDeleteMutation> propertyDeleteMutations = new ArrayList<PropertyDeleteMutation>();
            ArrayList<PropertySoftDeleteMutation> propertySoftDeleteMutations = new ArrayList<PropertySoftDeleteMutation>();
            ByteArrayInputStream bain = new ByteArrayInputStream(value.get());
            DataInputStream in = new DataInputStream(bain);
            DataInputStreamUtils.decodeHeader(in, (byte)2);
            String edgeId = DataInputStreamUtils.decodeText(in).toString();
            long timestamp = in.readLong();
            Visibility vertexVisibility = new Visibility(DataInputStreamUtils.decodeText(in).toString());
            Iterable hiddenVisibilities = Iterables.transform(DataInputStreamUtils.decodeTextList(in), (Function)new Function<Text, Visibility>(){

                @Nullable
                public Visibility apply(Text input) {
                    return new Visibility(input.toString());
                }
            });
            Iterable<Property> properties = DataInputStreamUtils.decodeProperties(graph, in);
            String inVertexId = DataInputStreamUtils.decodeText(in).toString();
            String outVertexId = DataInputStreamUtils.decodeText(in).toString();
            String label = graph.getNameSubstitutionStrategy().inflate(DataInputStreamUtils.decodeText(in));
            return new AccumuloEdge((Graph)graph, edgeId, outVertexId, inVertexId, label, null, vertexVisibility, properties, propertyDeleteMutations, propertySoftDeleteMutations, hiddenVisibilities, timestamp, authorizations);
        }
        catch (IOException ex) {
            throw new VertexiumException("Could not read vertex", (Throwable)ex);
        }
    }

    String getNewEdgeLabel() {
        return this.newEdgeLabel;
    }

    public String getLabel() {
        return this.label;
    }

    public String getVertexId(Direction direction) {
        switch (direction) {
            case OUT: {
                return this.outVertexId;
            }
            case IN: {
                return this.inVertexId;
            }
        }
        throw new IllegalArgumentException("Unexpected direction: " + direction);
    }

    public Vertex getVertex(Direction direction, Authorizations authorizations) {
        return this.getVertex(direction, FetchHint.ALL, authorizations);
    }

    public String getOtherVertexId(String myVertexId) {
        if (this.inVertexId.equals(myVertexId)) {
            return this.outVertexId;
        }
        if (this.outVertexId.equals(myVertexId)) {
            return this.inVertexId;
        }
        throw new VertexiumException("myVertexId(" + myVertexId + ") does not appear on edge (" + this.getId() + ") in either the in (" + this.inVertexId + ") or the out (" + this.outVertexId + ").");
    }

    public Vertex getOtherVertex(String myVertexId, Authorizations authorizations) {
        return this.getOtherVertex(myVertexId, FetchHint.ALL, authorizations);
    }

    public Vertex getOtherVertex(String myVertexId, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getVertex(this.getOtherVertexId(myVertexId), fetchHints, authorizations);
    }

    public EdgeVertices getVertices(Authorizations authorizations) {
        return this.getVertices(FetchHint.ALL, authorizations);
    }

    public EdgeVertices getVertices(EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.getVertexId(Direction.OUT));
        ids.add(this.getVertexId(Direction.IN));
        Map vertices = IterableUtils.toMapById((Iterable)this.getGraph().getVertices(ids, fetchHints, authorizations));
        return new EdgeVertices((Vertex)vertices.get(this.getVertexId(Direction.OUT)), (Vertex)vertices.get(this.getVertexId(Direction.IN)));
    }

    public Vertex getVertex(Direction direction, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getVertex(this.getVertexId(direction), fetchHints, authorizations);
    }

    public ExistingEdgeMutation prepareMutation() {
        return new ExistingEdgeMutation(this){

            public Edge save(Authorizations authorizations) {
                AccumuloEdge.this.saveExistingElementMutation(this, authorizations);
                return (Edge)this.getElement();
            }
        };
    }
}

