/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.Trace;
import org.vertexium.Authorizations;
import org.vertexium.ElementType;
import org.vertexium.FetchHint;
import org.vertexium.FindPathOptions;
import org.vertexium.Path;
import org.vertexium.ProgressCallback;
import org.vertexium.VertexiumException;
import org.vertexium.accumulo.AccumuloGraph;
import org.vertexium.accumulo.iterator.ConnectedVertexIdsIterator;
import org.vertexium.accumulo.util.RangeUtils;
import org.vertexium.util.IterableUtils;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class AccumuloFindPathStrategy {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(AccumuloFindPathStrategy.class);
    private final AccumuloGraph graph;
    private final FindPathOptions options;
    private final ProgressCallback progressCallback;
    private final Authorizations authorizations;

    public AccumuloFindPathStrategy(AccumuloGraph graph, FindPathOptions options, ProgressCallback progressCallback, Authorizations authorizations) {
        this.graph = graph;
        this.options = options;
        this.progressCallback = progressCallback;
        this.authorizations = authorizations;
    }

    public Iterable<Path> findPaths() {
        this.progressCallback.progress(0.0, ProgressCallback.Step.FINDING_PATH);
        ArrayList<Path> foundPaths = new ArrayList<Path>();
        if (this.options.getMaxHops() < 1) {
            throw new IllegalArgumentException("maxHops cannot be less than 1");
        }
        if (this.options.getMaxHops() == 1) {
            Set<String> sourceConnectedVertexIds = this.getConnectedVertexIds(this.options.getSourceVertexId());
            if (sourceConnectedVertexIds.contains(this.options.getDestVertexId())) {
                foundPaths.add(new Path(new String[]{this.options.getSourceVertexId(), this.options.getDestVertexId()}));
            }
        } else if (this.options.getMaxHops() == 2) {
            this.findPathsSetIntersection(foundPaths);
        } else {
            this.findPathsBreadthFirst(foundPaths, this.options.getSourceVertexId(), this.options.getDestVertexId(), this.options.getMaxHops());
        }
        this.progressCallback.progress(1.0, ProgressCallback.Step.COMPLETE);
        return foundPaths;
    }

    private void findPathsSetIntersection(List<Path> foundPaths) {
        HashSet<String> vertexIds = new HashSet<String>();
        vertexIds.add(this.options.getSourceVertexId());
        vertexIds.add(this.options.getDestVertexId());
        Map<String, Set<String>> connectedVertexIds = this.getConnectedVertexIds(vertexIds);
        this.progressCallback.progress(0.1, ProgressCallback.Step.SEARCHING_SOURCE_VERTEX_EDGES);
        Set<String> sourceVertexConnectedVertexIds = connectedVertexIds.get(this.options.getSourceVertexId());
        if (sourceVertexConnectedVertexIds == null) {
            return;
        }
        this.progressCallback.progress(0.3, ProgressCallback.Step.SEARCHING_DESTINATION_VERTEX_EDGES);
        Set<String> destVertexConnectedVertexIds = connectedVertexIds.get(this.options.getDestVertexId());
        if (destVertexConnectedVertexIds == null) {
            return;
        }
        this.progressCallback.progress(0.6, ProgressCallback.Step.MERGING_EDGES);
        sourceVertexConnectedVertexIds.retainAll(destVertexConnectedVertexIds);
        this.progressCallback.progress(0.9, ProgressCallback.Step.ADDING_PATHS);
        foundPaths.addAll(sourceVertexConnectedVertexIds.stream().map(connectedVertexId -> new Path(new String[]{this.options.getSourceVertexId(), connectedVertexId, this.options.getDestVertexId()})).collect(Collectors.toList()));
    }

    private void findPathsBreadthFirst(List<Path> foundPaths, String sourceVertexId, String destVertexId, int hops) {
        Map<String, Set<String>> connectedVertexIds = this.getConnectedVertexIds(sourceVertexId, destVertexId);
        for (int i = 2; i < hops; ++i) {
            this.progressCallback.progress((double)i / (double)hops, ProgressCallback.Step.FINDING_PATH);
            HashSet<String> vertexIdsToSearch = new HashSet<String>();
            for (Map.Entry<String, Set<String>> entry : connectedVertexIds.entrySet()) {
                vertexIdsToSearch.addAll((Collection<String>)entry.getValue());
            }
            vertexIdsToSearch.removeAll(connectedVertexIds.keySet());
            Map<String, Set<String>> r = this.getConnectedVertexIds(vertexIdsToSearch);
            connectedVertexIds.putAll(r);
        }
        this.progressCallback.progress(0.9, ProgressCallback.Step.ADDING_PATHS);
        HashSet<String> seenVertices = new HashSet<String>();
        Path currentPath = new Path(new String[]{sourceVertexId});
        this.findPathsRecursive(connectedVertexIds, foundPaths, sourceVertexId, destVertexId, hops, seenVertices, currentPath, this.progressCallback);
    }

    private void findPathsRecursive(Map<String, Set<String>> connectedVertexIds, List<Path> foundPaths, String sourceVertexId, String destVertexId, int hops, Set<String> seenVertices, Path currentPath, ProgressCallback progressCallback) {
        Set<String> vertexIds;
        seenVertices.add(sourceVertexId);
        if (sourceVertexId.equals(destVertexId)) {
            foundPaths.add(currentPath);
        } else if (hops > 0 && (vertexIds = connectedVertexIds.get(sourceVertexId)) != null) {
            for (String childId : vertexIds) {
                if (seenVertices.contains(childId)) continue;
                this.findPathsRecursive(connectedVertexIds, foundPaths, childId, destVertexId, hops - 1, seenVertices, new Path(currentPath, childId), progressCallback);
            }
        }
        seenVertices.remove(sourceVertexId);
    }

    private Set<String> getConnectedVertexIds(String vertexId) {
        HashSet<String> vertexIds = new HashSet<String>();
        vertexIds.add(vertexId);
        Map<String, Set<String>> results = this.getConnectedVertexIds(vertexIds);
        Set<String> vertexIdResults = results.get(vertexId);
        if (vertexIdResults == null) {
            return new HashSet<String>();
        }
        return vertexIdResults;
    }

    private Map<String, Set<String>> getConnectedVertexIds(String vertexId1, String vertexId2) {
        HashSet<String> vertexIds = new HashSet<String>();
        vertexIds.add(vertexId1);
        vertexIds.add(vertexId2);
        return this.getConnectedVertexIds(vertexIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<String>> getConnectedVertexIds(Set<String> vertexIds) {
        Span trace = Trace.start((String)"getConnectedVertexIds");
        try {
            HashMap<String, Set> hashMap;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("getConnectedVertexIds:\n  %s", new Object[]{IterableUtils.join(vertexIds, (String)"\n  ")});
            }
            if (vertexIds.size() == 0) {
                HashMap<String, Set<String>> hashMap2 = new HashMap<String, Set<String>>();
                return hashMap2;
            }
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (String vertexId : vertexIds) {
                ranges.add(RangeUtils.createRangeFromString(vertexId));
            }
            int maxVersions = 1;
            Long startTime = null;
            Long endTime = null;
            ScannerBase scanner = this.graph.createElementScanner(FetchHint.EDGE_REFS, ElementType.VERTEX, maxVersions, startTime, endTime, ranges, false, this.authorizations);
            IteratorSetting connectedVertexIdsIteratorSettings = new IteratorSetting(1000, ConnectedVertexIdsIterator.class.getSimpleName(), ConnectedVertexIdsIterator.class);
            ConnectedVertexIdsIterator.setLabels((IteratorSetting)connectedVertexIdsIteratorSettings, (String[])this.options.getLabels());
            ConnectedVertexIdsIterator.setExcludedLabels((IteratorSetting)connectedVertexIdsIteratorSettings, (String[])this.options.getExcludedLabels());
            scanner.addScanIterator(connectedVertexIdsIteratorSettings);
            long timerStartTime = System.currentTimeMillis();
            try {
                HashMap<String, Set> results = new HashMap<String, Set>();
                for (Map.Entry row : scanner) {
                    try {
                        Set rowVertexIds = ConnectedVertexIdsIterator.decodeValue((Value)((Value)row.getValue()));
                        results.put(((Key)row.getKey()).getRow().toString(), rowVertexIds);
                    }
                    catch (IOException e) {
                        throw new VertexiumException("Could not decode vertex ids for row: " + ((Key)row.getKey()).toString(), (Throwable)e);
                    }
                }
                hashMap = results;
            }
            catch (Throwable throwable) {
                scanner.close();
                AccumuloGraph.GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
                throw throwable;
            }
            scanner.close();
            AccumuloGraph.GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
            return hashMap;
        }
        finally {
            trace.stop();
        }
    }
}

