/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.NoSuchMetaStoreException;
import org.apache.accumulo.core.file.blockfile.ABlockReader;
import org.apache.accumulo.core.file.blockfile.ABlockWriter;
import org.apache.accumulo.core.file.blockfile.BlockFileReader;
import org.apache.accumulo.core.file.blockfile.BlockFileWriter;
import org.apache.accumulo.core.file.rfile.BlockIndex;
import org.apache.accumulo.core.file.rfile.MetricsGatherer;
import org.apache.accumulo.core.file.rfile.MultiIndexIterator;
import org.apache.accumulo.core.file.rfile.MultiLevelIndex;
import org.apache.accumulo.core.file.rfile.RelativeKey;
import org.apache.accumulo.core.file.rfile.bcfile.MetaBlockDoesNotExist;
import org.apache.accumulo.core.iterators.IterationInterruptedException;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.HeapIterator;
import org.apache.accumulo.core.iterators.system.InterruptibleIterator;
import org.apache.accumulo.core.iterators.system.LocalityGroupIterator;
import org.apache.accumulo.core.util.MutableByteSequence;
import org.apache.commons.lang.mutable.MutableLong;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RFile {
    public static final String EXTENSION = "rf";
    private static final Logger log = LoggerFactory.getLogger(RFile.class);
    private static final int RINDEX_MAGIC = 543388788;
    static final int RINDEX_VER_7 = 7;
    static final int RINDEX_VER_6 = 6;
    static final int RINDEX_VER_4 = 4;
    static final int RINDEX_VER_3 = 3;

    private RFile() {
    }

    public static class Reader
    extends HeapIterator
    implements FileSKVIterator {
        private BlockFileReader reader;
        private ArrayList<LocalityGroupMetadata> localityGroups = new ArrayList();
        private LocalityGroupReader[] lgReaders;
        private HashSet<ByteSequence> nonDefaultColumnFamilies;
        private List<Reader> deepCopies;
        private boolean deepCopy = false;
        private AtomicBoolean interruptFlag;
        private int numLGSeeked = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Reader(BlockFileReader rdr) throws IOException {
            this.reader = rdr;
            try (ABlockReader mb = this.reader.getMetaBlock("RFile.index");){
                int magic = mb.readInt();
                int ver = mb.readInt();
                if (magic != 543388788) {
                    throw new IOException("Did not see expected magic number, saw " + magic);
                }
                if (ver != 7 && ver != 6 && ver != 4 && ver != 3) {
                    throw new IOException("Did not see expected version, saw " + ver);
                }
                int size = mb.readInt();
                this.lgReaders = new LocalityGroupReader[size];
                this.deepCopies = new LinkedList<Reader>();
                for (int i = 0; i < size; ++i) {
                    LocalityGroupMetadata lgm = new LocalityGroupMetadata(ver, rdr);
                    lgm.readFields(mb);
                    this.localityGroups.add(lgm);
                    this.lgReaders[i] = new LocalityGroupReader(this.reader, lgm, ver);
                }
            }
            this.nonDefaultColumnFamilies = new HashSet();
            for (LocalityGroupMetadata lgm : this.localityGroups) {
                if (lgm.isDefaultLG) continue;
                this.nonDefaultColumnFamilies.addAll(lgm.columnFamilies.keySet());
            }
            this.createHeap(this.lgReaders.length);
        }

        private Reader(Reader r) {
            super(r.lgReaders.length);
            this.reader = r.reader;
            this.nonDefaultColumnFamilies = r.nonDefaultColumnFamilies;
            this.lgReaders = new LocalityGroupReader[r.lgReaders.length];
            this.deepCopies = r.deepCopies;
            this.deepCopy = true;
            for (int i = 0; i < this.lgReaders.length; ++i) {
                this.lgReaders[i] = new LocalityGroupReader(r.lgReaders[i]);
                this.lgReaders[i].setInterruptFlag(r.interruptFlag);
            }
        }

        private void closeLocalityGroupReaders() {
            for (LocalityGroupReader lgr : this.lgReaders) {
                try {
                    lgr.close();
                }
                catch (IOException e) {
                    log.warn("Errored out attempting to close LocalityGroupReader.", (Throwable)e);
                }
            }
        }

        @Override
        public void closeDeepCopies() {
            if (this.deepCopy) {
                throw new RuntimeException("Calling closeDeepCopies on a deep copy is not supported");
            }
            for (Reader deepCopy : this.deepCopies) {
                deepCopy.closeLocalityGroupReaders();
            }
            this.deepCopies.clear();
        }

        @Override
        public void close() throws IOException {
            if (this.deepCopy) {
                throw new RuntimeException("Calling close on a deep copy is not supported");
            }
            this.closeDeepCopies();
            this.closeLocalityGroupReaders();
            this.reader.close();
        }

        @Override
        public Key getFirstKey() throws IOException {
            if (this.lgReaders.length == 0) {
                return null;
            }
            Key minKey = null;
            for (int i = 0; i < this.lgReaders.length; ++i) {
                if (minKey == null) {
                    minKey = this.lgReaders[i].getFirstKey();
                    continue;
                }
                Key firstKey = this.lgReaders[i].getFirstKey();
                if (firstKey == null || firstKey.compareTo(minKey) >= 0) continue;
                minKey = firstKey;
            }
            return minKey;
        }

        @Override
        public Key getLastKey() throws IOException {
            if (this.lgReaders.length == 0) {
                return null;
            }
            Key maxKey = null;
            for (int i = 0; i < this.lgReaders.length; ++i) {
                if (maxKey == null) {
                    maxKey = this.lgReaders[i].getLastKey();
                    continue;
                }
                Key lastKey = this.lgReaders[i].getLastKey();
                if (lastKey == null || lastKey.compareTo(maxKey) <= 0) continue;
                maxKey = lastKey;
            }
            return maxKey;
        }

        @Override
        public DataInputStream getMetaStore(String name) throws IOException, NoSuchMetaStoreException {
            try {
                return this.reader.getMetaBlock(name).getStream();
            }
            catch (MetaBlockDoesNotExist e) {
                throw new NoSuchMetaStoreException("name = " + name, e);
            }
        }

        @Override
        public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
            Reader copy = new Reader(this);
            copy.setInterruptFlagInternal(this.interruptFlag);
            this.deepCopies.add(copy);
            return copy;
        }

        @Override
        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Map<String, ArrayList<ByteSequence>> getLocalityGroupCF() {
            HashMap<String, ArrayList<ByteSequence>> cf = new HashMap<String, ArrayList<ByteSequence>>();
            for (LocalityGroupMetadata lcg : this.localityGroups) {
                ArrayList setCF = new ArrayList();
                for (Map.Entry entry : lcg.columnFamilies.entrySet()) {
                    setCF.add(entry.getKey());
                }
                cf.put(lcg.name, setCF);
            }
            return cf;
        }

        public void registerMetrics(MetricsGatherer<?> vmg) {
            vmg.init(this.getLocalityGroupCF());
            for (LocalityGroupReader lgr : this.lgReaders) {
                lgr.registerMetrics(vmg);
            }
        }

        @Override
        public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
            this.numLGSeeked = LocalityGroupIterator.seek(this, this.lgReaders, this.nonDefaultColumnFamilies, range, columnFamilies, inclusive);
        }

        int getNumLocalityGroupsSeeked() {
            return this.numLGSeeked;
        }

        public FileSKVIterator getIndex() throws IOException {
            ArrayList<Iterator<MultiLevelIndex.IndexEntry>> indexes = new ArrayList<Iterator<MultiLevelIndex.IndexEntry>>();
            for (LocalityGroupReader lgr : this.lgReaders) {
                indexes.add(lgr.getIndex());
            }
            return new MultiIndexIterator(this, indexes);
        }

        public void printInfo() throws IOException {
            for (LocalityGroupMetadata lgm : this.localityGroups) {
                lgm.printInfo();
            }
        }

        @Override
        public void setInterruptFlag(AtomicBoolean flag) {
            if (this.deepCopy) {
                throw new RuntimeException("Calling setInterruptFlag on a deep copy is not supported");
            }
            if (this.deepCopies.size() != 0) {
                throw new RuntimeException("Setting interrupt flag after calling deep copy not supported");
            }
            this.setInterruptFlagInternal(flag);
        }

        private void setInterruptFlagInternal(AtomicBoolean flag) {
            this.interruptFlag = flag;
            for (LocalityGroupReader lgr : this.lgReaders) {
                lgr.setInterruptFlag(this.interruptFlag);
            }
        }
    }

    private static class LocalityGroupReader
    extends LocalityGroupIterator.LocalityGroup
    implements FileSKVIterator {
        private BlockFileReader reader;
        private MultiLevelIndex.Reader index;
        private int blockCount;
        private Key firstKey;
        private int startBlock;
        private boolean closed = false;
        private int version;
        private boolean checkRange = true;
        private MultiLevelIndex.Reader.IndexIterator iiter;
        private int entriesLeft;
        private ABlockReader currBlock;
        private RelativeKey rk;
        private Value val;
        private Key prevKey = null;
        private Range range = null;
        private boolean hasTop = false;
        private AtomicBoolean interruptFlag;
        private MetricsGatherer<?> metricsGatherer;

        private LocalityGroupReader(BlockFileReader reader, LocalityGroupMetadata lgm, int version) throws IOException {
            super(lgm.columnFamilies, lgm.isDefaultLG);
            this.firstKey = lgm.firstKey;
            this.index = lgm.indexReader;
            this.startBlock = lgm.startBlock;
            this.blockCount = this.index.size();
            this.version = version;
            this.reader = reader;
        }

        public LocalityGroupReader(LocalityGroupReader lgr) {
            super(lgr.columnFamilies, lgr.isDefaultLocalityGroup);
            this.firstKey = lgr.firstKey;
            this.index = lgr.index;
            this.startBlock = lgr.startBlock;
            this.blockCount = lgr.blockCount;
            this.reader = lgr.reader;
            this.version = lgr.version;
        }

        Iterator<MultiLevelIndex.IndexEntry> getIndex() throws IOException {
            return this.index.lookup(new Key());
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            this.hasTop = false;
            if (this.currBlock != null) {
                this.currBlock.close();
            }
        }

        @Override
        public Key getTopKey() {
            return this.rk.getKey();
        }

        @Override
        public Value getTopValue() {
            return this.val;
        }

        @Override
        public boolean hasTop() {
            return this.hasTop;
        }

        @Override
        public void next() throws IOException {
            try {
                this._next();
            }
            catch (IOException ioe) {
                this.reset();
                throw ioe;
            }
        }

        private void _next() throws IOException {
            if (!this.hasTop) {
                throw new IllegalStateException();
            }
            if (this.entriesLeft == 0) {
                this.currBlock.close();
                if (this.metricsGatherer != null) {
                    this.metricsGatherer.startBlock();
                }
                if (this.iiter.hasNext()) {
                    MultiLevelIndex.IndexEntry indexEntry = this.iiter.next();
                    this.entriesLeft = indexEntry.getNumEntries();
                    this.currBlock = this.getDataBlock(indexEntry);
                    this.checkRange = this.range.afterEndKey(indexEntry.getKey());
                    if (!this.checkRange) {
                        this.hasTop = true;
                    }
                } else {
                    this.rk = null;
                    this.val = null;
                    this.hasTop = false;
                    return;
                }
            }
            this.prevKey = this.rk.getKey();
            this.rk.readFields(this.currBlock);
            this.val.readFields(this.currBlock);
            if (this.metricsGatherer != null) {
                this.metricsGatherer.addMetric(this.rk.getKey(), this.val);
            }
            --this.entriesLeft;
            if (this.checkRange) {
                this.hasTop = !this.range.afterEndKey(this.rk.getKey());
            }
        }

        private ABlockReader getDataBlock(MultiLevelIndex.IndexEntry indexEntry) throws IOException {
            if (this.interruptFlag != null && this.interruptFlag.get()) {
                throw new IterationInterruptedException();
            }
            if (this.version == 3 || this.version == 4) {
                return this.reader.getDataBlock(this.startBlock + this.iiter.previousIndex());
            }
            return this.reader.getDataBlock(indexEntry.getOffset(), indexEntry.getCompressedSize(), indexEntry.getRawSize());
        }

        @Override
        public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("Locality group reader closed");
            }
            if (columnFamilies.size() != 0 || inclusive) {
                throw new IllegalArgumentException("I do not know how to filter column families");
            }
            if (this.interruptFlag != null && this.interruptFlag.get()) {
                throw new IterationInterruptedException();
            }
            try {
                this._seek(range);
            }
            catch (IOException ioe) {
                this.reset();
                throw ioe;
            }
        }

        private void reset() {
            this.rk = null;
            this.hasTop = false;
            if (this.currBlock != null) {
                try {
                    try {
                        this.currBlock.close();
                    }
                    catch (IOException e) {
                        log.warn("Failed to close block reader", (Throwable)e);
                    }
                }
                finally {
                    this.currBlock = null;
                }
            }
        }

        private void _seek(Range range) throws IOException {
            this.range = range;
            this.checkRange = true;
            if (this.blockCount == 0) {
                this.rk = null;
                return;
            }
            Key startKey = range.getStartKey();
            if (startKey == null) {
                startKey = new Key();
            }
            boolean reseek = true;
            if (range.afterEndKey(this.firstKey)) {
                this.reset();
                reseek = false;
            }
            if (this.rk != null) {
                if (range.beforeStartKey(this.prevKey) && range.afterEndKey(this.getTopKey())) {
                    reseek = false;
                }
                if (startKey.compareTo(this.getTopKey()) <= 0 && startKey.compareTo(this.prevKey) > 0) {
                    reseek = false;
                }
                if (startKey.compareTo(this.getTopKey()) >= 0 && startKey.compareTo(this.iiter.peekPrevious().getKey()) <= 0) {
                    MutableByteSequence valbs = new MutableByteSequence(new byte[64], 0, 0);
                    RelativeKey.SkippR skippr = RelativeKey.fastSkip(this.currBlock, startKey, valbs, this.prevKey, this.getTopKey());
                    if (skippr.skipped > 0) {
                        this.entriesLeft -= skippr.skipped;
                        this.val = new Value(valbs.toArray());
                        this.prevKey = skippr.prevKey;
                        this.rk = skippr.rk;
                    }
                    reseek = false;
                }
                if (this.iiter.previousIndex() == 0 && this.getTopKey().equals(this.firstKey) && startKey.compareTo(this.firstKey) <= 0) {
                    reseek = false;
                }
            }
            if (reseek) {
                this.iiter = this.index.lookup(startKey);
                this.reset();
                if (this.iiter.hasNext()) {
                    BlockIndex.BlockIndexEntry bie;
                    BlockIndex blockIndex;
                    while (this.iiter.hasPrevious() && this.iiter.peekPrevious().getKey().equals(this.iiter.peek().getKey())) {
                        this.iiter.previous();
                    }
                    this.prevKey = this.iiter.hasPrevious() ? new Key(this.iiter.peekPrevious().getKey()) : new Key();
                    MultiLevelIndex.IndexEntry indexEntry = this.iiter.next();
                    this.entriesLeft = indexEntry.getNumEntries();
                    this.currBlock = this.getDataBlock(indexEntry);
                    this.checkRange = range.afterEndKey(indexEntry.getKey());
                    if (!this.checkRange) {
                        this.hasTop = true;
                    }
                    MutableByteSequence valbs = new MutableByteSequence(new byte[64], 0, 0);
                    Key currKey = null;
                    if (this.currBlock.isIndexable() && (blockIndex = BlockIndex.getIndex(this.currBlock, indexEntry)) != null && (bie = blockIndex.seekBlock(startKey, this.currBlock)) != null) {
                        RelativeKey tmpRk = new RelativeKey();
                        tmpRk.setPrevKey(bie.getPrevKey());
                        tmpRk.readFields(this.currBlock);
                        this.val = new Value();
                        this.val.readFields(this.currBlock);
                        valbs = new MutableByteSequence(this.val.get(), 0, this.val.getSize());
                        this.entriesLeft = bie.getEntriesLeft() - 1;
                        this.prevKey = new Key(bie.getPrevKey());
                        currKey = tmpRk.getKey();
                    }
                    RelativeKey.SkippR skippr = RelativeKey.fastSkip(this.currBlock, startKey, valbs, this.prevKey, currKey);
                    this.prevKey = skippr.prevKey;
                    this.entriesLeft -= skippr.skipped;
                    this.val = new Value(valbs.toArray());
                    this.rk = skippr.rk;
                }
            }
            boolean bl = this.hasTop = this.rk != null && !range.afterEndKey(this.rk.getKey());
            while (this.hasTop() && range.beforeStartKey(this.getTopKey())) {
                this.next();
            }
            if (this.metricsGatherer != null) {
                this.metricsGatherer.startLocalityGroup(this.rk.getKey().getColumnFamily());
                this.metricsGatherer.addMetric(this.rk.getKey(), this.val);
            }
        }

        @Override
        public Key getFirstKey() throws IOException {
            return this.firstKey;
        }

        @Override
        public Key getLastKey() throws IOException {
            if (this.index.size() == 0) {
                return null;
            }
            return this.index.getLastKey();
        }

        @Override
        public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void closeDeepCopies() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public DataInputStream getMetaStore(String name) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setInterruptFlag(AtomicBoolean flag) {
            this.interruptFlag = flag;
        }

        @Override
        public InterruptibleIterator getIterator() {
            return this;
        }

        public void registerMetrics(MetricsGatherer<?> vmg) {
            this.metricsGatherer = vmg;
        }
    }

    public static class Writer
    implements FileSKVWriter {
        public static final int MAX_CF_IN_DLG = 1000;
        private static final double MAX_BLOCK_MULTIPLIER = 1.1;
        private BlockFileWriter fileWriter;
        private ABlockWriter blockWriter;
        private final long blockSize;
        private final long maxBlockSize;
        private final int indexBlockSize;
        private int entries = 0;
        private ArrayList<LocalityGroupMetadata> localityGroups = new ArrayList();
        private LocalityGroupMetadata currentLocalityGroup = null;
        private int nextBlock = 0;
        private Key lastKeyInBlock = null;
        private boolean dataClosed = false;
        private boolean closed = false;
        private Key prevKey = new Key();
        private boolean startedDefaultLocalityGroup = false;
        private HashSet<ByteSequence> previousColumnFamilies;
        private SummaryStatistics keyLenStats = new SummaryStatistics();
        private double avergageKeySize = 0.0;

        public Writer(BlockFileWriter bfw, int blockSize) throws IOException {
            this(bfw, blockSize, (int)AccumuloConfiguration.getDefaultConfiguration().getMemoryInBytes(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE_INDEX));
        }

        public Writer(BlockFileWriter bfw, int blockSize, int indexBlockSize) throws IOException {
            this.blockSize = blockSize;
            this.maxBlockSize = (long)((double)blockSize * 1.1);
            this.indexBlockSize = indexBlockSize;
            this.fileWriter = bfw;
            this.blockWriter = null;
            this.previousColumnFamilies = new HashSet();
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closeData();
            ABlockWriter mba = this.fileWriter.prepareMetaBlock("RFile.index");
            mba.writeInt(543388788);
            mba.writeInt(7);
            if (this.currentLocalityGroup != null) {
                this.localityGroups.add(this.currentLocalityGroup);
            }
            mba.writeInt(this.localityGroups.size());
            for (LocalityGroupMetadata lc : this.localityGroups) {
                lc.write(mba);
            }
            mba.close();
            this.fileWriter.close();
            this.closed = true;
        }

        private void closeData() throws IOException {
            if (this.dataClosed) {
                return;
            }
            this.dataClosed = true;
            if (this.blockWriter != null) {
                this.closeBlock(this.lastKeyInBlock, true);
            }
        }

        private boolean isGiantKey(Key k) {
            return (double)k.getSize() > this.keyLenStats.getMean() + this.keyLenStats.getStandardDeviation() * 3.0;
        }

        @Override
        public void append(Key key, Value value) throws IOException {
            if (this.dataClosed) {
                throw new IllegalStateException("Cannont append, data closed");
            }
            if (key.compareTo(this.prevKey) < 0) {
                throw new IllegalStateException("Keys appended out-of-order.  New key " + key + ", previous key " + this.prevKey);
            }
            this.currentLocalityGroup.updateColumnCount(key);
            if (this.currentLocalityGroup.getFirstKey() == null) {
                this.currentLocalityGroup.setFirstKey(key);
            }
            if (this.blockWriter == null) {
                this.blockWriter = this.fileWriter.prepareDataBlock();
            } else if (this.blockWriter.getRawSize() > this.blockSize) {
                if (this.avergageKeySize == 0.0) {
                    this.avergageKeySize = this.keyLenStats.getMean();
                }
                if (((double)this.prevKey.getSize() <= this.avergageKeySize || this.blockWriter.getRawSize() > this.maxBlockSize) && !this.isGiantKey(this.prevKey)) {
                    this.closeBlock(this.prevKey, false);
                    this.blockWriter = this.fileWriter.prepareDataBlock();
                    this.avergageKeySize = 0.0;
                }
            }
            RelativeKey rk = new RelativeKey(this.lastKeyInBlock, key);
            rk.write(this.blockWriter);
            value.write(this.blockWriter);
            ++this.entries;
            this.keyLenStats.addValue((double)key.getSize());
            this.lastKeyInBlock = this.prevKey = new Key(key);
        }

        private void closeBlock(Key key, boolean lastBlock) throws IOException {
            this.blockWriter.close();
            if (lastBlock) {
                this.currentLocalityGroup.indexWriter.addLast(key, this.entries, this.blockWriter.getStartPos(), this.blockWriter.getCompressedSize(), this.blockWriter.getRawSize());
            } else {
                this.currentLocalityGroup.indexWriter.add(key, this.entries, this.blockWriter.getStartPos(), this.blockWriter.getCompressedSize(), this.blockWriter.getRawSize());
            }
            this.blockWriter = null;
            this.lastKeyInBlock = null;
            this.entries = 0;
            ++this.nextBlock;
        }

        @Override
        public DataOutputStream createMetaStore(String name) throws IOException {
            this.closeData();
            return (DataOutputStream)((Object)this.fileWriter.prepareMetaBlock(name));
        }

        private void _startNewLocalityGroup(String name, Set<ByteSequence> columnFamilies) throws IOException {
            if (this.dataClosed) {
                throw new IllegalStateException("data closed");
            }
            if (this.startedDefaultLocalityGroup) {
                throw new IllegalStateException("Can not start anymore new locality groups after default locality group started");
            }
            if (this.blockWriter != null) {
                this.closeBlock(this.lastKeyInBlock, true);
            }
            if (this.currentLocalityGroup != null) {
                this.localityGroups.add(this.currentLocalityGroup);
            }
            if (columnFamilies == null) {
                this.startedDefaultLocalityGroup = true;
                this.currentLocalityGroup = new LocalityGroupMetadata(this.nextBlock, this.previousColumnFamilies, this.indexBlockSize, this.fileWriter);
            } else {
                if (!Collections.disjoint(columnFamilies, this.previousColumnFamilies)) {
                    HashSet<ByteSequence> overlap = new HashSet<ByteSequence>(columnFamilies);
                    overlap.retainAll(this.previousColumnFamilies);
                    throw new IllegalArgumentException("Column families over lap with previous locality group : " + overlap);
                }
                this.currentLocalityGroup = new LocalityGroupMetadata(name, columnFamilies, this.nextBlock, this.indexBlockSize, this.fileWriter);
                this.previousColumnFamilies.addAll(columnFamilies);
            }
            this.prevKey = new Key();
        }

        @Override
        public void startNewLocalityGroup(String name, Set<ByteSequence> columnFamilies) throws IOException {
            if (columnFamilies == null) {
                throw new NullPointerException();
            }
            this._startNewLocalityGroup(name, columnFamilies);
        }

        @Override
        public void startDefaultLocalityGroup() throws IOException {
            this._startNewLocalityGroup(null, null);
        }

        @Override
        public boolean supportsLocalityGroups() {
            return true;
        }
    }

    private static class LocalityGroupMetadata
    implements Writable {
        private int startBlock;
        private Key firstKey;
        private Map<ByteSequence, MutableLong> columnFamilies;
        private boolean isDefaultLG = false;
        private String name;
        private Set<ByteSequence> previousColumnFamilies;
        private MultiLevelIndex.BufferedWriter indexWriter;
        private MultiLevelIndex.Reader indexReader;

        public LocalityGroupMetadata(int version, BlockFileReader br) {
            this.columnFamilies = new HashMap<ByteSequence, MutableLong>();
            this.indexReader = new MultiLevelIndex.Reader(br, version);
        }

        public LocalityGroupMetadata(int nextBlock, Set<ByteSequence> pcf, int indexBlockSize, BlockFileWriter bfw) {
            this.startBlock = nextBlock;
            this.isDefaultLG = true;
            this.columnFamilies = new HashMap<ByteSequence, MutableLong>();
            this.previousColumnFamilies = pcf;
            this.indexWriter = new MultiLevelIndex.BufferedWriter(new MultiLevelIndex.Writer(bfw, indexBlockSize));
        }

        public LocalityGroupMetadata(String name, Set<ByteSequence> cfset, int nextBlock, int indexBlockSize, BlockFileWriter bfw) {
            this.startBlock = nextBlock;
            this.name = name;
            this.isDefaultLG = false;
            this.columnFamilies = new HashMap<ByteSequence, MutableLong>();
            for (ByteSequence cf : cfset) {
                this.columnFamilies.put(cf, new MutableLong(0L));
            }
            this.indexWriter = new MultiLevelIndex.BufferedWriter(new MultiLevelIndex.Writer(bfw, indexBlockSize));
        }

        private Key getFirstKey() {
            return this.firstKey;
        }

        private void setFirstKey(Key key) {
            if (this.firstKey != null) {
                throw new IllegalStateException();
            }
            this.firstKey = new Key(key);
        }

        public void updateColumnCount(Key key) {
            if (this.isDefaultLG && this.columnFamilies == null) {
                ByteSequence cf;
                if (this.previousColumnFamilies.size() > 0 && this.previousColumnFamilies.contains(cf = key.getColumnFamilyData())) {
                    throw new IllegalArgumentException("Added column family \"" + cf + "\" to default locality group that was in previous locality group");
                }
                return;
            }
            ByteSequence cf = key.getColumnFamilyData();
            MutableLong count = this.columnFamilies.get(cf);
            if (count == null) {
                if (!this.isDefaultLG) {
                    throw new IllegalArgumentException("invalid column family : " + cf);
                }
                if (this.previousColumnFamilies.contains(cf)) {
                    throw new IllegalArgumentException("Added column family \"" + cf + "\" to default locality group that was in previous locality group");
                }
                if (this.columnFamilies.size() > 1000) {
                    this.columnFamilies = null;
                    return;
                }
                count = new MutableLong(0L);
                this.columnFamilies.put(new ArrayByteSequence(cf.getBackingArray(), cf.offset(), cf.length()), count);
            }
            count.increment();
        }

        public void readFields(DataInput in) throws IOException {
            this.isDefaultLG = in.readBoolean();
            if (!this.isDefaultLG) {
                this.name = in.readUTF();
            }
            this.startBlock = in.readInt();
            int size = in.readInt();
            if (size == -1) {
                if (!this.isDefaultLG) {
                    throw new IllegalStateException("Non default LG " + this.name + " does not have column families");
                }
                this.columnFamilies = null;
            } else {
                if (this.columnFamilies == null) {
                    this.columnFamilies = new HashMap<ByteSequence, MutableLong>();
                } else {
                    this.columnFamilies.clear();
                }
                for (int i = 0; i < size; ++i) {
                    int len = in.readInt();
                    byte[] cf = new byte[len];
                    in.readFully(cf);
                    long count = in.readLong();
                    this.columnFamilies.put(new ArrayByteSequence(cf), new MutableLong(count));
                }
            }
            if (in.readBoolean()) {
                this.firstKey = new Key();
                this.firstKey.readFields(in);
            } else {
                this.firstKey = null;
            }
            this.indexReader.readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.isDefaultLG);
            if (!this.isDefaultLG) {
                out.writeUTF(this.name);
            }
            out.writeInt(this.startBlock);
            if (this.isDefaultLG && this.columnFamilies == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(this.columnFamilies.size());
                for (Map.Entry<ByteSequence, MutableLong> entry : this.columnFamilies.entrySet()) {
                    out.writeInt(entry.getKey().length());
                    out.write(entry.getKey().getBackingArray(), entry.getKey().offset(), entry.getKey().length());
                    out.writeLong(entry.getValue().longValue());
                }
            }
            out.writeBoolean(this.firstKey != null);
            if (this.firstKey != null) {
                this.firstKey.write(out);
            }
            this.indexWriter.close(out);
        }

        public void printInfo() throws IOException {
            PrintStream out = System.out;
            out.println("Locality group         : " + (this.isDefaultLG ? "<DEFAULT>" : this.name));
            out.println("\tStart block          : " + this.startBlock);
            out.println("\tNum   blocks         : " + String.format("%,d", this.indexReader.size()));
            TreeMap<Integer, Long> sizesByLevel = new TreeMap<Integer, Long>();
            TreeMap<Integer, Long> countsByLevel = new TreeMap<Integer, Long>();
            this.indexReader.getIndexInfo(sizesByLevel, countsByLevel);
            for (Map.Entry entry : sizesByLevel.descendingMap().entrySet()) {
                out.println("\tIndex level " + entry.getKey() + "        : " + String.format("%,d bytes  %,d blocks", entry.getValue(), countsByLevel.get(entry.getKey())));
            }
            out.println("\tFirst key            : " + this.firstKey);
            Key lastKey = null;
            if (this.indexReader.size() > 0) {
                lastKey = this.indexReader.getLastKey();
            }
            out.println("\tLast key             : " + lastKey);
            long numKeys = 0L;
            MultiLevelIndex.Reader.IndexIterator countIter = this.indexReader.lookup(new Key());
            while (countIter.hasNext()) {
                numKeys += (long)countIter.next().getNumEntries();
            }
            out.println("\tNum entries          : " + String.format("%,d", numKeys));
            out.println("\tColumn families      : " + (this.isDefaultLG && this.columnFamilies == null ? "<UNKNOWN>" : this.columnFamilies.keySet()));
        }
    }
}

