/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k;

import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.cache2k.Cache;
import org.cache2k.spi.Cache2kExtensionProvider;

public abstract class CacheManager
implements Iterable<Cache>,
Closeable {
    protected static final String DEFAULT_MANAGER_NAME = "default";
    private static CacheManager defaultManager;
    private static String defaultName;
    private static Map<String, CacheManager> name2manager;

    public static String getDefaultName() {
        return defaultName;
    }

    public static void setDefaultName(String defaultName) {
        if (defaultManager != null) {
            throw new IllegalStateException("default CacheManager already created");
        }
        CacheManager.defaultName = defaultName;
    }

    public static synchronized CacheManager getInstance() {
        if (defaultManager != null && !defaultManager.isDestroyed()) {
            return defaultManager;
        }
        try {
            defaultManager = (CacheManager)CacheManager.getManagerClass().newInstance();
        }
        catch (Exception e) {
            return CacheManager.implNotFound(e);
        }
        name2manager.put(defaultManager.getName(), defaultManager);
        return defaultManager;
    }

    private static CacheManager implNotFound(Exception e) {
        throw new Error("cache2k implementation not found, cache2k-core.jar missing?", e);
    }

    private static Class<?> getManagerClass() throws ClassNotFoundException {
        return Class.forName("org.cache2k.impl.CacheManagerImpl");
    }

    public static synchronized CacheManager getInstance(String _name) {
        if (defaultName.equals(_name)) {
            return CacheManager.getInstance();
        }
        CacheManager m = name2manager.get(_name);
        if (m != null) {
            return m;
        }
        try {
            Class<?> c = CacheManager.getManagerClass();
            Constructor<?> cc = c.getConstructor(String.class);
            m = (CacheManager)cc.newInstance(_name);
        }
        catch (Exception e) {
            return CacheManager.implNotFound(e);
        }
        name2manager.put(_name, m);
        return m;
    }

    public abstract String getName();

    @Override
    public abstract Iterator<Cache> iterator();

    public abstract Cache getCache(String var1);

    public abstract void clear();

    public abstract void destroy();

    @Override
    public abstract void close();

    public abstract boolean isDestroyed();

    static {
        defaultName = DEFAULT_MANAGER_NAME;
        name2manager = new HashMap<String, CacheManager>();
        ServiceLoader<Cache2kExtensionProvider> _loader = ServiceLoader.load(Cache2kExtensionProvider.class);
        for (Cache2kExtensionProvider p : _loader) {
            p.register();
        }
    }
}

