/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.sink.CharSink;
import org.semarglproject.source.AbstractSource;
import org.semarglproject.source.BaseStreamProcessor;

final class CharSource
extends AbstractSource<CharSink> {
    CharSource(CharSink sink) {
        super(sink);
    }

    @Override
    public void process(Reader reader, String mimeType, String baseUri) throws ParseException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String buffer;
            ((CharSink)this.sink).setBaseUri(baseUri);
            while ((buffer = bufferedReader.readLine()) != null) {
                ((CharSink)this.sink).process(buffer);
            }
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        finally {
            BaseStreamProcessor.closeQuietly(bufferedReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(InputStream inputStream, String mimeType, String baseUri) throws ParseException {
        InputStreamReader reader = new InputStreamReader(inputStream, Charset.forName("UTF-8"));
        try {
            this.process(reader, mimeType, baseUri);
        }
        finally {
            BaseStreamProcessor.closeQuietly(reader);
        }
    }
}

