/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import org.elasticsearch.bootstrap.ConsoleCtrlHandler;
import org.elasticsearch.bootstrap.JNANatives;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

class Natives {
    private static final ESLogger logger = Loggers.getLogger(Natives.class);
    private static boolean jnaAvailable = false;

    Natives() {
    }

    static void tryMlockall() {
        if (!jnaAvailable) {
            logger.warn("cannot mlockall because JNA is not available", new Object[0]);
            return;
        }
        JNANatives.tryMlockall();
    }

    static void tryVirtualLock() {
        if (!jnaAvailable) {
            logger.warn("cannot mlockall because JNA is not available", new Object[0]);
            return;
        }
        JNANatives.tryVirtualLock();
    }

    static void addConsoleCtrlHandler(ConsoleCtrlHandler handler) {
        if (!jnaAvailable) {
            logger.warn("cannot register console handler because JNA is not available", new Object[0]);
            return;
        }
        JNANatives.addConsoleCtrlHandler(handler);
    }

    static boolean isMemoryLocked() {
        if (!jnaAvailable) {
            return false;
        }
        return JNANatives.LOCAL_MLOCKALL;
    }

    static {
        try {
            Class.forName("com.sun.jna.Version");
            jnaAvailable = true;
        }
        catch (ClassNotFoundException e) {
            logger.warn("JNA not found. native methods will be disabled.", new Object[0]);
        }
    }
}

