/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.action.shard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ImmutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingService;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.FailedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class ShardStateAction
extends AbstractComponent {
    public static final String SHARD_STARTED_ACTION_NAME = "internal:cluster/shard/started";
    public static final String SHARD_FAILED_ACTION_NAME = "internal:cluster/shard/failure";
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final RoutingService routingService;
    private final BlockingQueue<ShardRoutingEntry> startedShardsQueue = ConcurrentCollections.newBlockingQueue();
    private final BlockingQueue<ShardRoutingEntry> failedShardQueue = ConcurrentCollections.newBlockingQueue();

    @Inject
    public ShardStateAction(Settings settings, ClusterService clusterService, TransportService transportService, AllocationService allocationService, RoutingService routingService) {
        super(settings);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.allocationService = allocationService;
        this.routingService = routingService;
        transportService.registerHandler(SHARD_STARTED_ACTION_NAME, new ShardStartedTransportHandler());
        transportService.registerHandler(SHARD_FAILED_ACTION_NAME, new ShardFailedTransportHandler());
    }

    public void shardFailed(ShardRouting shardRouting, String indexUUID, String reason) throws ElasticsearchException {
        DiscoveryNode masterNode = this.clusterService.state().nodes().masterNode();
        if (masterNode == null) {
            this.logger.warn("can't send shard failed for {}, no master known.", shardRouting);
            return;
        }
        this.innerShardFailed(shardRouting, indexUUID, reason, masterNode);
    }

    public void resendShardFailed(ShardRouting shardRouting, String indexUUID, String reason, DiscoveryNode masterNode) throws ElasticsearchException {
        this.logger.trace("{} re-sending failed shard for {}, indexUUID [{}], reason [{}]", shardRouting.shardId(), shardRouting, indexUUID, reason);
        this.innerShardFailed(shardRouting, indexUUID, reason, masterNode);
    }

    private void innerShardFailed(ShardRouting shardRouting, String indexUUID, String reason, final DiscoveryNode masterNode) {
        ShardRoutingEntry shardRoutingEntry = new ShardRoutingEntry(shardRouting, indexUUID, reason);
        if (this.clusterService.localNode().equals(masterNode)) {
            this.innerShardFailed(shardRoutingEntry);
        } else {
            this.transportService.sendRequest(masterNode, SHARD_FAILED_ACTION_NAME, shardRoutingEntry, new EmptyTransportResponseHandler("same"){

                @Override
                public void handleException(TransportException exp) {
                    ShardStateAction.this.logger.warn("failed to send failed shard to {}", exp, masterNode);
                }
            });
        }
    }

    public void shardStarted(ShardRouting shardRouting, String indexUUID, String reason) throws ElasticsearchException {
        DiscoveryNode masterNode = this.clusterService.state().nodes().masterNode();
        if (masterNode == null) {
            this.logger.warn("can't send shard started for {}. no master known.", shardRouting);
            return;
        }
        this.shardStarted(shardRouting, indexUUID, reason, masterNode);
    }

    public void shardStarted(ShardRouting shardRouting, String indexUUID, String reason, final DiscoveryNode masterNode) throws ElasticsearchException {
        ShardRoutingEntry shardRoutingEntry = new ShardRoutingEntry(shardRouting, indexUUID, reason);
        this.logger.debug("sending shard started for {}", shardRoutingEntry);
        if (this.clusterService.localNode().equals(masterNode)) {
            this.shardStartedOnMaster(shardRoutingEntry);
        } else {
            this.transportService.sendRequest(masterNode, SHARD_STARTED_ACTION_NAME, new ShardRoutingEntry(shardRouting, indexUUID, reason), new EmptyTransportResponseHandler("same"){

                @Override
                public void handleException(TransportException exp) {
                    ShardStateAction.this.logger.warn("failed to send shard started to [{}]", exp, masterNode);
                }
            });
        }
    }

    private void innerShardFailed(final ShardRoutingEntry shardRoutingEntry) {
        this.logger.warn("{} received shard failed for {}", shardRoutingEntry.shardRouting.shardId(), shardRoutingEntry);
        this.failedShardQueue.add(shardRoutingEntry);
        this.clusterService.submitStateUpdateTask("shard-failed (" + shardRoutingEntry.shardRouting + "), reason [" + shardRoutingEntry.reason + "]", Priority.HIGH, new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                if (shardRoutingEntry.processed) {
                    return currentState;
                }
                ArrayList<ShardRoutingEntry> shardRoutingEntries = new ArrayList<ShardRoutingEntry>();
                ShardStateAction.this.failedShardQueue.drainTo(shardRoutingEntries);
                if (shardRoutingEntries.isEmpty()) {
                    return currentState;
                }
                MetaData metaData = currentState.getMetaData();
                ArrayList<FailedRerouteAllocation.FailedShard> shardRoutingsToBeApplied = new ArrayList<FailedRerouteAllocation.FailedShard>(shardRoutingEntries.size());
                for (ShardRoutingEntry entry : ShardStateAction.extractShardsToBeApplied(shardRoutingEntries, "failed", metaData, ShardStateAction.this.logger)) {
                    shardRoutingsToBeApplied.add(new FailedRerouteAllocation.FailedShard(entry.shardRouting, entry.reason));
                }
                for (ShardRoutingEntry entry : shardRoutingEntries) {
                    entry.processed = true;
                }
                RoutingAllocation.Result routingResult = ShardStateAction.this.allocationService.applyFailedShards(currentState, shardRoutingsToBeApplied);
                if (!routingResult.changed()) {
                    return currentState;
                }
                return ClusterState.builder(currentState).routingResult(routingResult).build();
            }

            @Override
            public void onFailure(String source, Throwable t) {
                ShardStateAction.this.logger.error("unexpected failure during [{}]", t, source);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (oldState != newState && newState.getRoutingNodes().unassigned().size() > 0) {
                    ShardStateAction.this.logger.trace("unassigned shards after shard failures. scheduling a reroute.", new Object[0]);
                    ShardStateAction.this.routingService.reroute("unassigned shards after shard failures, scheduling a reroute");
                }
            }
        });
    }

    static List<ShardRoutingEntry> extractShardsToBeApplied(List<ShardRoutingEntry> shardRoutingEntries, String type, MetaData metaData, ESLogger logger) {
        ArrayList<ShardRoutingEntry> shardRoutingsToBeApplied = new ArrayList<ShardRoutingEntry>(shardRoutingEntries.size());
        for (int i = 0; i < shardRoutingEntries.size(); ++i) {
            ShardRoutingEntry shardRoutingEntry = shardRoutingEntries.get(i);
            ShardRouting shardRouting = shardRoutingEntry.shardRouting;
            IndexMetaData indexMetaData = metaData.index(shardRouting.index());
            if (indexMetaData == null) {
                logger.debug("{} ignoring shard {}, unknown index in {}", shardRouting.shardId(), type, shardRoutingEntry);
                continue;
            }
            if (!indexMetaData.isSameUUID(shardRoutingEntry.indexUUID)) {
                logger.debug("{} ignoring shard {}, different index uuid, current {}, got {}", shardRouting.shardId(), type, indexMetaData.getUUID(), shardRoutingEntry);
                continue;
            }
            logger.trace("{} will apply shard {} {}", shardRouting.shardId(), type, shardRoutingEntry);
            shardRoutingsToBeApplied.add(shardRoutingEntry);
        }
        return shardRoutingsToBeApplied;
    }

    private void shardStartedOnMaster(final ShardRoutingEntry shardRoutingEntry) {
        this.logger.debug("received shard started for {}", shardRoutingEntry);
        this.startedShardsQueue.add(shardRoutingEntry);
        this.clusterService.submitStateUpdateTask("shard-started (" + shardRoutingEntry.shardRouting + "), reason [" + shardRoutingEntry.reason + "]", Priority.URGENT, new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                if (shardRoutingEntry.processed) {
                    return currentState;
                }
                ArrayList<ShardRoutingEntry> shardRoutingEntries = new ArrayList<ShardRoutingEntry>();
                ShardStateAction.this.startedShardsQueue.drainTo(shardRoutingEntries);
                if (shardRoutingEntries.isEmpty()) {
                    return currentState;
                }
                RoutingTable routingTable = currentState.routingTable();
                MetaData metaData = currentState.getMetaData();
                ArrayList<ShardRouting> shardRoutingToBeApplied = new ArrayList<ShardRouting>(shardRoutingEntries.size());
                for (ShardRoutingEntry entry : ShardStateAction.extractShardsToBeApplied(shardRoutingEntries, "started", metaData, ShardStateAction.this.logger)) {
                    shardRoutingToBeApplied.add(entry.shardRouting);
                }
                for (ShardRoutingEntry entry : shardRoutingEntries) {
                    entry.processed = true;
                }
                if (shardRoutingToBeApplied.isEmpty()) {
                    return currentState;
                }
                RoutingAllocation.Result routingResult = ShardStateAction.this.allocationService.applyStartedShards(currentState, shardRoutingToBeApplied, true);
                if (!routingResult.changed()) {
                    return currentState;
                }
                return ClusterState.builder(currentState).routingResult(routingResult).build();
            }

            @Override
            public void onFailure(String source, Throwable t) {
                ShardStateAction.this.logger.error("unexpected failure during [{}]", t, source);
            }
        });
    }

    public static class ShardRoutingEntry
    extends TransportRequest {
        ShardRouting shardRouting;
        String indexUUID = "_na_";
        String reason;
        volatile boolean processed;

        private ShardRoutingEntry() {
        }

        ShardRoutingEntry(ShardRouting shardRouting, String indexUUID, String reason) {
            this.shardRouting = shardRouting;
            this.reason = reason;
            this.indexUUID = indexUUID;
        }

        public ShardRouting getShardRouting() {
            return this.shardRouting;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardRouting = ImmutableShardRouting.readShardRoutingEntry(in);
            this.reason = in.readString();
            this.indexUUID = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardRouting.writeTo(out);
            out.writeString(this.reason);
            out.writeString(this.indexUUID);
        }

        public String toString() {
            return "" + this.shardRouting + ", indexUUID [" + this.indexUUID + "], reason [" + this.reason + "]";
        }
    }

    class ShardStartedTransportHandler
    extends BaseTransportRequestHandler<ShardRoutingEntry> {
        ShardStartedTransportHandler() {
        }

        @Override
        public ShardRoutingEntry newInstance() {
            return new ShardRoutingEntry();
        }

        @Override
        public void messageReceived(ShardRoutingEntry request, TransportChannel channel) throws Exception {
            ShardStateAction.this.shardStartedOnMaster(request);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    private class ShardFailedTransportHandler
    extends BaseTransportRequestHandler<ShardRoutingEntry> {
        private ShardFailedTransportHandler() {
        }

        @Override
        public ShardRoutingEntry newInstance() {
            return new ShardRoutingEntry();
        }

        @Override
        public void messageReceived(ShardRoutingEntry request, TransportChannel channel) throws Exception {
            ShardStateAction.this.innerShardFailed(request);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }
}

