/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog.fs;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TranslogStream;
import org.elasticsearch.index.translog.fs.BufferingFsTranslogFile;
import org.elasticsearch.index.translog.fs.FsChannelSnapshot;
import org.elasticsearch.index.translog.fs.RafReference;
import org.elasticsearch.index.translog.fs.SimpleFsTranslogFile;

public interface FsTranslogFile {
    public long id();

    public int estimatedNumberOfOperations();

    public long translogSizeInBytes();

    public Translog.Location add(BytesReference var1) throws IOException;

    public byte[] read(Translog.Location var1) throws IOException;

    public void close(boolean var1) throws TranslogException;

    public FsChannelSnapshot snapshot() throws TranslogException;

    public void reuse(FsTranslogFile var1) throws TranslogException;

    public void updateBufferSize(int var1) throws TranslogException;

    public void sync() throws IOException;

    public boolean syncNeeded();

    public TranslogStream getStream();

    public boolean closed();

    public static enum Type {
        SIMPLE{

            @Override
            public FsTranslogFile create(ShardId shardId, long id, RafReference raf, int bufferSize) throws IOException {
                return new SimpleFsTranslogFile(shardId, id, raf);
            }
        }
        ,
        BUFFERED{

            @Override
            public FsTranslogFile create(ShardId shardId, long id, RafReference raf, int bufferSize) throws IOException {
                return new BufferingFsTranslogFile(shardId, id, raf, bufferSize);
            }
        };


        public abstract FsTranslogFile create(ShardId var1, long var2, RafReference var4, int var5) throws IOException;

        public static Type fromString(String type) throws ElasticsearchIllegalArgumentException {
            if (SIMPLE.name().equalsIgnoreCase(type)) {
                return SIMPLE;
            }
            if (BUFFERED.name().equalsIgnoreCase(type)) {
                return BUFFERED;
            }
            throw new ElasticsearchIllegalArgumentException("No translog fs type [" + type + "]");
        }
    }
}

