/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.CompressorStream;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.zlib.ZlibFactory;

public class ReusableStreamGzipCodec
extends GzipCodec {
    private static final Log LOG = LogFactory.getLog(Compression.class);

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        if (ZlibFactory.isNativeZlibLoaded((Configuration)this.getConf())) {
            return super.createOutputStream(out);
        }
        return new ReusableGzipOutputStream(out);
    }

    protected static class ReusableGzipOutputStream
    extends CompressorStream {
        private static final int GZIP_HEADER_LENGTH = 10;
        private static final byte[] GZIP_HEADER;

        public ReusableGzipOutputStream(OutputStream out) throws IOException {
            super((OutputStream)new ResetableGZIPOutputStream(out));
        }

        public void close() throws IOException {
            this.out.close();
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] data, int offset, int length) throws IOException {
            this.out.write(data, offset, length);
        }

        public void finish() throws IOException {
            ((GZIPOutputStream)this.out).finish();
        }

        public void resetState() throws IOException {
            ((ResetableGZIPOutputStream)this.out).resetState();
        }

        static {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] header = null;
            GZIPOutputStream gzipStream = null;
            try {
                gzipStream = new GZIPOutputStream(baos);
                gzipStream.finish();
                header = Arrays.copyOfRange(baos.toByteArray(), 0, 10);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create gzip stream", e);
            }
            finally {
                if (gzipStream != null) {
                    try {
                        gzipStream.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)e);
                    }
                }
            }
            GZIP_HEADER = header;
        }

        private static class ResetableGZIPOutputStream
        extends GZIPOutputStream {
            public ResetableGZIPOutputStream(OutputStream out) throws IOException {
                super(out);
            }

            public void resetState() throws IOException {
                this.def.reset();
                this.crc.reset();
                this.out.write(GZIP_HEADER);
            }
        }
    }
}

