/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public final class Canary
implements Tool {
    private static final long DEFAULT_INTERVAL = 6000L;
    private static final Log LOG = LogFactory.getLog(Canary.class);
    private Configuration conf = null;
    private HBaseAdmin admin = null;
    private long interval = 0L;
    private Sink sink = null;

    public Canary() {
        this(new StdOutSink());
    }

    public Canary(Sink sink) {
        this.sink = sink;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public int run(String[] args) throws Exception {
        int i;
        int tables_index = -1;
        for (i = 0; i < args.length; ++i) {
            String cmd = args[i];
            if (cmd.startsWith("-")) {
                if (tables_index >= 0) {
                    System.err.println("Invalid command line options");
                    this.printUsageAndExit();
                }
                if (cmd.equals("-help")) {
                    this.printUsageAndExit();
                    continue;
                }
                if (cmd.equals("-daemon") && this.interval == 0L) {
                    this.interval = 6000L;
                    continue;
                }
                if (cmd.equals("-interval")) {
                    if (++i == args.length) {
                        System.err.println("-interval needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    try {
                        this.interval = Long.parseLong(args[i]) * 1000L;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("-interval needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    continue;
                }
                System.err.println(cmd + " options is invalid.");
                this.printUsageAndExit();
                continue;
            }
            if (tables_index >= 0) continue;
            tables_index = i;
        }
        if (this.conf == null) {
            this.conf = HBaseConfiguration.create();
        }
        this.admin = new HBaseAdmin(this.conf);
        do {
            if (this.admin.isAborted()) {
                LOG.error((Object)"HBaseAdmin aborted");
                return 1;
            }
            if (tables_index >= 0) {
                for (i = tables_index; i < args.length; ++i) {
                    this.sniff(args[i]);
                }
            } else {
                this.sniff();
            }
            Thread.sleep(this.interval);
        } while (this.interval > 0L);
        return 0;
    }

    private void printUsageAndExit() {
        System.err.printf("Usage: bin/hbase %s [opts] [table 1 [table 2...]]\n", this.getClass().getName());
        System.err.println(" where [opts] are:");
        System.err.println("   -help          Show this help and exit.");
        System.err.println("   -daemon        Continuous check at defined intervals.");
        System.err.println("   -interval <N>  Interval between checks (sec)");
        System.exit(1);
    }

    private void sniff() throws Exception {
        for (HTableDescriptor table : this.admin.listTables()) {
            this.sniff(table);
        }
    }

    private void sniff(String tableName) throws Exception {
        if (this.admin.isTableAvailable(tableName)) {
            this.sniff(this.admin.getTableDescriptor(tableName.getBytes()));
        } else {
            LOG.warn((Object)String.format("Table %s is not available", tableName));
        }
    }

    private void sniff(HTableDescriptor tableDesc) throws Exception {
        HTable table = null;
        try {
            table = new HTable(this.admin.getConfiguration(), tableDesc.getName());
        }
        catch (TableNotFoundException e) {
            return;
        }
        for (HRegionInfo region : this.admin.getTableRegions(tableDesc.getName())) {
            try {
                this.sniffRegion(region, table);
            }
            catch (Exception e) {
                this.sink.publishReadFailure(region);
            }
        }
    }

    private void sniffRegion(HRegionInfo region, HTable table) throws Exception {
        HTableDescriptor tableDesc = table.getTableDescriptor();
        for (HColumnDescriptor column : tableDesc.getColumnFamilies()) {
            Get get2 = new Get(region.getStartKey());
            get2.addFamily(column.getName());
            try {
                long startTime = System.currentTimeMillis();
                table.get(get2);
                long time = System.currentTimeMillis() - startTime;
                this.sink.publishReadTiming(region, column, time);
            }
            catch (Exception e) {
                this.sink.publishReadFailure(region, column);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new Canary(), (String[])args);
        System.exit(exitCode);
    }

    public static class StdOutSink
    implements Sink {
        @Override
        public void publishReadFailure(HRegionInfo region) {
            LOG.error((Object)String.format("read from region %s failed", region.getRegionNameAsString()));
        }

        @Override
        public void publishReadFailure(HRegionInfo region, HColumnDescriptor column) {
            LOG.error((Object)String.format("read from region %s column family %s failed", region.getRegionNameAsString(), column.getNameAsString()));
        }

        @Override
        public void publishReadTiming(HRegionInfo region, HColumnDescriptor column, long msTime) {
            LOG.info((Object)String.format("read from region %s column family %s in %dms", region.getRegionNameAsString(), column.getNameAsString(), msTime));
        }
    }

    public static interface Sink {
        public void publishReadFailure(HRegionInfo var1);

        public void publishReadFailure(HRegionInfo var1, HColumnDescriptor var2);

        public void publishReadTiming(HRegionInfo var1, HColumnDescriptor var2, long var3);
    }
}

