/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.cache2k.Cache;
import org.cache2k.CacheException;
import org.cache2k.CacheManager;
import org.cache2k.impl.BaseCache;
import org.cache2k.impl.CacheClosedException;
import org.cache2k.impl.CacheInternalError;
import org.cache2k.impl.CacheLifeCycleListener;
import org.cache2k.impl.CacheManagerLifeCycleListener;
import org.cache2k.impl.CacheUsageExcpetion;
import org.cache2k.impl.threading.Futures;
import org.cache2k.impl.threading.GlobalPooledExecutor;
import org.cache2k.impl.util.Cache2kVersion;
import org.cache2k.impl.util.Log;

public class CacheManagerImpl
extends CacheManager {
    static List<CacheLifeCycleListener> cacheLifeCycleListeners = new ArrayList<CacheLifeCycleListener>();
    static List<CacheManagerLifeCycleListener> cacheManagerLifeCycleListeners = new ArrayList<CacheManagerLifeCycleListener>();
    private Log log;
    private String name;
    private Map<String, BaseCache> cacheNames = new HashMap<String, BaseCache>();
    private Set<Cache> caches = new HashSet<Cache>();
    private int disambiguationCounter = 1;
    private GlobalPooledExecutor threadPool;
    private AtomicInteger evictionThreadCount = new AtomicInteger();
    private ExecutorService evictionExecutor;
    private String version;
    private String buildNumber;

    public CacheManagerImpl() {
        this(CacheManagerImpl.getDefaultName());
    }

    public CacheManagerImpl(String _name) {
        this.name = _name;
        this.log = Log.getLog(CacheManager.class.getName() + '.' + this.name);
        String _buildNumber = Cache2kVersion.getBuildNumber();
        String _version = Cache2kVersion.getVersion();
        StringBuilder sb = new StringBuilder();
        sb.append("org.cache2k manager starting. ");
        sb.append("name=");
        sb.append(this.name);
        sb.append(", version=");
        sb.append(_version);
        sb.append(", build=");
        sb.append(_buildNumber);
        this.log.info(sb.toString());
        for (CacheManagerLifeCycleListener lc : cacheManagerLifeCycleListeners) {
            lc.managerCreated(this);
        }
    }

    private void sendCreatedEvent(Cache c) {
        for (CacheLifeCycleListener e : cacheLifeCycleListeners) {
            e.cacheCreated(this, c);
        }
    }

    private void sendDestroyedEvent(Cache c) {
        for (CacheLifeCycleListener e : cacheLifeCycleListeners) {
            e.cacheDestroyed(this, c);
        }
    }

    private void checkName(String s) {
        for (char c : s.toCharArray()) {
            if (c == '.' || c == '-' || c == '~' || Character.isJavaIdentifierPart(c)) continue;
            throw new CacheUsageExcpetion("Cache name contains illegal chars: '" + c + "', name=\"" + s + "\"");
        }
    }

    public synchronized void newCache(Cache c) {
        String _requestedName;
        BaseCache bc = (BaseCache)c;
        String _name = _requestedName = c.getName();
        while (this.cacheNames.containsKey(_name)) {
            _name = _requestedName + "~" + Integer.toString(this.disambiguationCounter++, 36);
        }
        if (!_requestedName.equals(_name)) {
            this.log.warn("duplicate name, disambiguating: " + _requestedName + " -> " + _name, new StackTrace());
            bc.setName(_name);
        }
        this.checkName(_name);
        this.caches.add(c);
        this.sendCreatedEvent(c);
        bc.setCacheManager(this);
        this.cacheNames.put(c.getName(), bc);
    }

    public synchronized void cacheDestroyed(Cache c) {
        this.cacheNames.remove(c.getName());
        this.caches.remove(c);
        this.sendDestroyedEvent(c);
    }

    public String getName() {
        return this.name;
    }

    public synchronized Iterator<Cache> iterator() {
        this.checkClosed();
        return this.caches.iterator();
    }

    public Cache getCache(String name) {
        return this.cacheNames.get(name);
    }

    public synchronized void clear() {
        this.checkClosed();
        for (Cache c : this.caches) {
            c.clear();
        }
    }

    public synchronized void destroy() {
        this.close();
    }

    public synchronized void close() {
        ArrayList<Throwable> _suppressedExceptions = new ArrayList<Throwable>();
        if (this.caches != null) {
            Futures.WaitForAllFuture<Void> _wait = new Futures.WaitForAllFuture<Void>(new Future[0]);
            for (Cache c : this.caches) {
                if (!(c instanceof BaseCache)) continue;
                try {
                    Future<Void> f = ((BaseCache)c).cancelTimerJobs();
                    _wait.add(f);
                }
                catch (Throwable t) {
                    _suppressedExceptions.add(t);
                }
            }
            try {
                _wait.get(3000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception ex) {
                _suppressedExceptions.add(ex);
            }
            if (!_wait.isDone()) {
                for (Cache c : this.caches) {
                    if (!(c instanceof BaseCache)) continue;
                    BaseCache bc = (BaseCache)c;
                    try {
                        Future<Void> f = bc.cancelTimerJobs();
                        if (f.isDone()) continue;
                        bc.getLog().info("fetches ongoing, terminating anyway...");
                    }
                    catch (Throwable t) {
                        _suppressedExceptions.add(t);
                    }
                }
            }
            HashSet<Cache> _caches = new HashSet<Cache>();
            _caches.addAll(this.caches);
            for (Cache c : _caches) {
                try {
                    c.destroy();
                }
                catch (Throwable t) {
                    _suppressedExceptions.add(t);
                }
            }
            try {
                if (this.threadPool != null) {
                    this.threadPool.close();
                }
                for (CacheManagerLifeCycleListener lc : cacheManagerLifeCycleListeners) {
                    lc.managerDestroyed(this);
                }
                this.caches = null;
            }
            catch (Throwable t) {
                _suppressedExceptions.add(t);
            }
        }
        this.eventuallyThrowException(_suppressedExceptions);
    }

    private void eventuallyThrowException(List<Throwable> _suppressedExceptions) {
        if (_suppressedExceptions.size() > 0) {
            CacheInternalError _throwNow;
            Throwable _error = null;
            for (Throwable t : _suppressedExceptions) {
                if (t instanceof Error) {
                    _error = t;
                }
                if (!(t instanceof ExecutionException) || !(((ExecutionException)t).getCause() instanceof Error)) continue;
                _error = t;
            }
            String _text = "shutdown";
            if (_suppressedExceptions.size() > 1) {
                _text = " (" + _suppressedExceptions.size() + " exceptions)";
            }
            if (_error != null) {
                _throwNow = new CacheInternalError(_text, _error);
            } else {
                _throwNow = new CacheException(_text, _suppressedExceptions.get(0));
                _suppressedExceptions.remove(0);
            }
            for (Throwable t : _suppressedExceptions) {
                if (t == _error) continue;
                _throwNow.addSuppressed(t);
            }
            if (_error != null) {
                throw (Error)_throwNow;
            }
            throw (RuntimeException)((Object)_throwNow);
        }
    }

    public boolean isDestroyed() {
        return this.caches == null;
    }

    private String getThreadNamePrefix() {
        if (!"default".equals(this.name)) {
            return "cache2k:" + this.name + ":";
        }
        return "cache2k-";
    }

    public synchronized GlobalPooledExecutor getThreadPool() {
        if (this.threadPool == null) {
            this.threadPool = new GlobalPooledExecutor(this.getThreadNamePrefix() + "pool-");
        }
        return this.threadPool;
    }

    public ExecutorService createEvictionExecutor() {
        ThreadFactory _threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                String _name = CacheManagerImpl.this.getThreadNamePrefix() + "eviction-" + CacheManagerImpl.this.evictionThreadCount.incrementAndGet();
                Thread t = new Thread((Runnable)new ExceptionWrapper(r), _name);
                t.setDaemon(true);
                return t;
            }
        };
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 17L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(Runtime.getRuntime().availableProcessors() * 2), _threadFactory);
    }

    public ExecutorService getEvictionExecutor() {
        if (this.evictionExecutor == null) {
            this.evictionExecutor = this.createEvictionExecutor();
        }
        return this.evictionExecutor;
    }

    public GlobalPooledExecutor getThreadPoolEventually() {
        return this.threadPool;
    }

    private void checkClosed() {
        if (this.caches == null) {
            throw new IllegalStateException("CacheManager already closed");
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    static {
        for (CacheLifeCycleListener cacheLifeCycleListener : ServiceLoader.load(CacheLifeCycleListener.class)) {
            cacheLifeCycleListeners.add(cacheLifeCycleListener);
        }
        for (CacheManagerLifeCycleListener cacheManagerLifeCycleListener : ServiceLoader.load(CacheManagerLifeCycleListener.class)) {
            cacheManagerLifeCycleListeners.add(cacheManagerLifeCycleListener);
        }
    }

    class ExceptionWrapper
    implements Runnable {
        Runnable runnable;

        ExceptionWrapper(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (CacheClosedException ignore) {
            }
            catch (Throwable t) {
                CacheManagerImpl.this.log.warn("Exception in thread \"" + Thread.currentThread().getName() + "\"", t);
            }
        }
    }

    static class StackTrace
    extends Exception {
        StackTrace() {
        }
    }
}

