/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.storage;

import java.util.Comparator;
import java.util.TreeSet;

public class FreeSpaceMap {
    long freeSpace;
    TreeSet<Slot> freeSet;
    TreeSet<Slot> pos2slot;
    final Slot reusedFreeSlotUnderLock = new Slot(0L, 0);

    public void init() {
        this.freeSpace = 0L;
        this.freeSet = new TreeSet();
        this.pos2slot = new TreeSet<Slot>(new PositionOrder());
    }

    public void put(Slot s) {
        this.freeSpace += (long)s.size;
        this.freeSet.add(s);
        this.pos2slot.add(s);
    }

    public Slot reserveSlotEndingAt(long pos) {
        this.reusedFreeSlotUnderLock.position = pos;
        Slot s = this.pos2slot.floor(this.reusedFreeSlotUnderLock);
        if (s != null && s.getNextPosition() == pos) {
            this.freeSet.remove(s);
            this.pos2slot.remove(s);
            this.freeSpace -= (long)s.size;
            return s;
        }
        return null;
    }

    public Slot getHighestSlot() {
        if (this.pos2slot.size() > 0) {
            return this.pos2slot.last();
        }
        return null;
    }

    public Slot findFree(int size) {
        this.reusedFreeSlotUnderLock.size = size;
        Slot s = this.freeSet.ceiling(this.reusedFreeSlotUnderLock);
        if (s != null) {
            this.freeSet.remove(s);
            this.pos2slot.remove(s);
            this.freeSpace -= (long)s.size;
            return s;
        }
        return null;
    }

    public void allocateSpace(Slot s) {
        this.allocateSpace(s.position, s.size);
    }

    public void allocateSpace(long _position, int _size) {
        this.freeSpace -= (long)_size;
        if (this.freeSpace < 0L) {
            throw new IllegalArgumentException("no free space.");
        }
        this.reusedFreeSlotUnderLock.position = _position;
        Slot s = this.pos2slot.floor(this.reusedFreeSlotUnderLock);
        if (s == null) {
            throw new IllegalArgumentException("no free space, no slot");
        }
        this.pos2slot.remove(s);
        this.freeSet.remove(s);
        if (s.size < _size) {
            throw new IllegalArgumentException("no free space, small slot");
        }
        if (s.position < _position) {
            if (s.getNextPosition() < _position + (long)_size) {
                throw new IllegalArgumentException("no free space, premature slot end");
            }
            Slot _preceding = new Slot();
            _preceding.position = s.position;
            _preceding.size = (int)(_position - s.position);
            this.pos2slot.add(_preceding);
            this.freeSet.add(_preceding);
            s.size -= _preceding.size;
        }
        if (s.size > _size) {
            s.position = (long)_size + _position;
            s.size -= _size;
            this.pos2slot.add(s);
            this.freeSet.add(s);
        }
    }

    public void freeSpace(Slot s) {
        this.freeSpace(s.position, s.size);
    }

    public void freeSpace(long _position, int _size) {
        this.freeSpace += (long)_size;
        this.reusedFreeSlotUnderLock.position = (long)_size + _position;
        Slot s = this.pos2slot.ceiling(this.reusedFreeSlotUnderLock);
        if (s != null && s.position == this.reusedFreeSlotUnderLock.position) {
            this.pos2slot.remove(s);
            this.freeSet.remove(s);
            s.position = _position;
            s.size += _size;
        } else {
            s = new Slot(_position, _size);
        }
        this.reusedFreeSlotUnderLock.position = _position;
        Slot s2 = this.pos2slot.lower(this.reusedFreeSlotUnderLock);
        if (s2 != null && s2.getNextPosition() == _position) {
            this.pos2slot.remove(s2);
            this.freeSet.remove(s2);
            s2.size += s.size;
            s = s2;
        }
        this.pos2slot.add(s);
        this.freeSet.add(s);
    }

    public long getFreeSpace() {
        return this.freeSpace;
    }

    private long calculateFreeSpace() {
        long s = 0L;
        Slot _prev = null;
        for (Slot fs : this.pos2slot) {
            s += (long)fs.size;
            _prev = fs;
        }
        return s;
    }

    public int getSlotCount() {
        return this.freeSet.size();
    }

    public long getSizeOfLargestSlot() {
        if (this.freeSet.size() == 0) {
            return 0L;
        }
        return this.freeSet.last().size;
    }

    public long getSizeOfSmallestSlot() {
        if (this.freeSet.size() == 0) {
            return 0L;
        }
        return this.freeSet.first().size;
    }

    public static class Slot
    implements Comparable<Slot> {
        long position;
        int size;

        public Slot() {
        }

        public Slot(long _position, int _size) {
            this.position = _position;
            this.size = _size;
        }

        public long getPosition() {
            return this.position;
        }

        public int getSize() {
            return this.size;
        }

        public long getNextPosition() {
            return this.position + (long)this.size;
        }

        @Override
        public int compareTo(Slot o) {
            int d = this.size - o.size;
            if (d != 0) {
                return d;
            }
            return this.position < o.position ? -1 : (this.position == o.position ? 0 : 1);
        }

        public String toString() {
            return "FreeSlot{position=" + this.position + ", size=" + this.size + '}';
        }
    }

    static class PositionOrder
    implements Comparator<Slot> {
        PositionOrder() {
        }

        @Override
        public int compare(Slot o1, Slot o2) {
            if (o1.position < o2.position) {
                return -1;
            }
            if (o1.position > o2.position) {
                return 1;
            }
            return 0;
        }
    }
}

