/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.keys;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.TreeMapBackedSortedColumns;
import org.apache.cassandra.db.filter.ExtendedFilter;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.index.AbstractSimplePerColumnSecondaryIndex;
import org.apache.cassandra.db.index.PerColumnSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.index.keys.KeysIndex;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.HeapAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeysSearcher
extends SecondaryIndexSearcher {
    private static final Logger logger = LoggerFactory.getLogger(KeysSearcher.class);

    public KeysSearcher(SecondaryIndexManager indexManager, Set<ByteBuffer> columns) {
        super(indexManager, columns);
    }

    @Override
    public List<Row> search(ExtendedFilter filter) {
        assert (filter.getClause() != null && !filter.getClause().isEmpty());
        return this.baseCfs.filter(this.getIndexedIterator(filter), filter);
    }

    private ColumnFamilyStore.AbstractScanIterator getIndexedIterator(final ExtendedFilter filter) {
        final IndexExpression primary = this.highestSelectivityPredicate(filter.getClause());
        final SecondaryIndex index = this.indexManager.getIndexForColumn(primary.column_name);
        assert (index != null);
        assert (index.getIndexCfs() != null);
        final DecoratedKey indexKey = index.getIndexKeyFor(primary.value);
        if (logger.isDebugEnabled()) {
            logger.debug("Most-selective indexed predicate is {}", (Object)((AbstractSimplePerColumnSecondaryIndex)index).expressionString(primary));
        }
        final AbstractBounds<RowPosition> range = filter.dataRange.keyRange();
        final ByteBuffer startKey = range.left instanceof DecoratedKey ? ((DecoratedKey)range.left).key : ByteBufferUtil.EMPTY_BYTE_BUFFER;
        final ByteBuffer endKey = range.right instanceof DecoratedKey ? ((DecoratedKey)range.right).key : ByteBufferUtil.EMPTY_BYTE_BUFFER;
        return new ColumnFamilyStore.AbstractScanIterator(){
            private ByteBuffer lastSeenKey;
            private Iterator<Column> indexColumns;
            private int columnsRead;
            {
                this.lastSeenKey = startKey;
                this.columnsRead = Integer.MAX_VALUE;
            }

            protected Row computeNext() {
                ColumnFamily data;
                DecoratedKey dk;
                int meanColumns = Math.max(index.getIndexCfs().getMeanColumns(), 1);
                int rowsPerQuery = Math.max(Math.min(filter.maxRows(), filter.maxColumns() / meanColumns), 2);
                block0: while (true) {
                    if (this.indexColumns == null || !this.indexColumns.hasNext()) {
                        if (this.columnsRead < rowsPerQuery) {
                            logger.trace("Read only {} (< {}) last page through, must be done", (Object)this.columnsRead, (Object)rowsPerQuery);
                            return (Row)this.endOfData();
                        }
                        if (logger.isTraceEnabled() && index instanceof AbstractSimplePerColumnSecondaryIndex) {
                            logger.trace("Scanning index {} starting with {}", (Object)((AbstractSimplePerColumnSecondaryIndex)index).expressionString(primary), (Object)index.getBaseCfs().metadata.getKeyValidator().getString(startKey));
                        }
                        QueryFilter indexFilter = QueryFilter.getSliceFilter(indexKey, index.getIndexCfs().name, this.lastSeenKey, endKey, false, rowsPerQuery, filter.timestamp);
                        ColumnFamily indexRow = index.getIndexCfs().getColumnFamily(indexFilter);
                        logger.trace("fetched {}", (Object)indexRow);
                        if (indexRow == null) {
                            logger.trace("no data, all done");
                            return (Row)this.endOfData();
                        }
                        Collection<Column> sortedColumns = indexRow.getSortedColumns();
                        this.columnsRead = sortedColumns.size();
                        this.indexColumns = sortedColumns.iterator();
                        Column firstColumn = sortedColumns.iterator().next();
                        if (this.lastSeenKey != startKey && this.lastSeenKey.equals(firstColumn.name())) {
                            this.indexColumns.next();
                            logger.trace("Skipping {}", (Object)((KeysSearcher)KeysSearcher.this).baseCfs.metadata.getKeyValidator().getString(firstColumn.name()));
                        } else if (range instanceof Range && this.indexColumns.hasNext() && firstColumn.name().equals(startKey)) {
                            this.indexColumns.next();
                            logger.trace("Skipping first key as range excludes it");
                        }
                    }
                    while (true) {
                        ColumnFamily cf;
                        IDiskAtomFilter extraFilter;
                        if (!this.indexColumns.hasNext()) continue block0;
                        Column column = this.indexColumns.next();
                        this.lastSeenKey = column.name();
                        if (column.isMarkedForDelete(filter.timestamp)) {
                            logger.trace("skipping {}", (Object)column.name());
                            continue;
                        }
                        dk = ((KeysSearcher)KeysSearcher.this).baseCfs.partitioner.decorateKey(this.lastSeenKey);
                        if (!((RowPosition)range.right).isMinimum(((KeysSearcher)KeysSearcher.this).baseCfs.partitioner) && ((RowPosition)range.right).compareTo(dk) < 0) {
                            logger.trace("Reached end of assigned scan range");
                            return (Row)this.endOfData();
                        }
                        if (!range.contains(dk)) {
                            logger.trace("Skipping entry {} outside of assigned scan range", (Object)dk.token);
                            continue;
                        }
                        logger.trace("Returning index hit for {}", (Object)dk);
                        data = KeysSearcher.this.baseCfs.getColumnFamily(new QueryFilter(dk, ((KeysSearcher)KeysSearcher.this).baseCfs.name, filter.columnFilter(this.lastSeenKey), filter.timestamp));
                        if (data == null) {
                            data = TreeMapBackedSortedColumns.factory.create(((KeysSearcher)KeysSearcher.this).baseCfs.metadata);
                        }
                        if ((extraFilter = filter.getExtraFilter(dk, data)) != null && (cf = KeysSearcher.this.baseCfs.getColumnFamily(new QueryFilter(dk, ((KeysSearcher)KeysSearcher.this).baseCfs.name, extraFilter, filter.timestamp))) != null) {
                            data.addAll(cf, HeapAllocator.instance);
                        }
                        if (!((KeysIndex)index).isIndexEntryStale(indexKey.key, data, filter.timestamp)) break block0;
                        Column dummyColumn = new Column(primary.column_name, indexKey.key, column.timestamp());
                        ((PerColumnSecondaryIndex)index).delete(dk.key, dummyColumn);
                    }
                    break;
                }
                return new Row(dk, data);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }
}

