/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.nested;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.hppc.IntArrayList;
import org.elasticsearch.common.hppc.IntObjectOpenHashMap;
import org.elasticsearch.common.lucene.ReaderContextAware;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.index.cache.fixedbitset.FixedBitSetFilter;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.nested.InternalNested;
import org.elasticsearch.search.aggregations.bucket.nested.ReverseNestedAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class NestedAggregator
extends SingleBucketAggregator
implements ReaderContextAware {
    private final Aggregator parentAggregator;
    private FixedBitSetFilter parentFilter;
    private final Filter childFilter;
    private DocIdSetIterator childDocs;
    private FixedBitSet parentDocs;
    private AtomicReaderContext reader;
    private FixedBitSet rootDocs;
    private int currentRootDoc = -1;
    private final IntObjectOpenHashMap<IntArrayList> childDocIdBuffers = new IntObjectOpenHashMap();

    public NestedAggregator(String name, AggregatorFactories factories, ObjectMapper objectMapper, AggregationContext aggregationContext, Aggregator parentAggregator) {
        super(name, factories, aggregationContext, parentAggregator);
        this.parentAggregator = parentAggregator;
        this.childFilter = aggregationContext.searchContext().filterCache().cache(objectMapper.nestedTypeFilter());
        aggregationContext.ensureScoreDocsInOrder();
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.parentFilter = null;
        this.reader = reader;
        try {
            DocIdSet childDocIdSet = this.childFilter.getDocIdSet(reader, null);
            this.childDocs = DocIdSets.isEmpty(childDocIdSet) ? null : childDocIdSet.iterator();
            this.rootDocs = this.context.searchContext().fixedBitSetFilterCache().getFixedBitSetFilter(NonNestedDocsFilter.INSTANCE).getDocIdSet(reader, null);
            this.currentRootDoc = -1;
            this.childDocIdBuffers.clear();
        }
        catch (IOException ioe) {
            throw new AggregationExecutionException("Failed to aggregate [" + this.name + "]", ioe);
        }
    }

    @Override
    public void collect(int parentDoc, long bucketOrd) throws IOException {
        if (parentDoc == 0 || this.childDocs == null) {
            return;
        }
        if (this.parentFilter == null) {
            Filter parentFilterNotCached = NestedAggregator.findClosestNestedPath(this.parentAggregator);
            if (parentFilterNotCached == null) {
                parentFilterNotCached = NonNestedDocsFilter.INSTANCE;
            }
            this.parentFilter = this.context.searchContext().fixedBitSetFilterCache().getFixedBitSetFilter(parentFilterNotCached);
            this.parentDocs = this.parentFilter.getDocIdSet(this.reader, null);
        }
        int numChildren = 0;
        IntArrayList iterator = this.getChildren(parentDoc);
        int[] buffer = iterator.buffer;
        int size = iterator.size();
        for (int i = 0; i < size; ++i) {
            ++numChildren;
            this.collectBucketNoCounts(buffer[i], bucketOrd);
        }
        this.incrementBucketDocCount(bucketOrd, numChildren);
    }

    @Override
    protected void doClose() {
        this.childDocIdBuffers.clear();
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        return new InternalNested(this.name, this.bucketDocCount(owningBucketOrdinal), this.bucketAggregations(owningBucketOrdinal));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalNested(this.name, 0L, this.buildEmptySubAggregations());
    }

    private static Filter findClosestNestedPath(Aggregator parent) {
        while (parent != null) {
            if (parent instanceof NestedAggregator) {
                return ((NestedAggregator)parent).childFilter;
            }
            if (parent instanceof ReverseNestedAggregator) {
                return ((ReverseNestedAggregator)parent).getParentFilter();
            }
            parent = parent.parent();
        }
        return null;
    }

    private IntArrayList getChildren(int parentDocId) throws IOException {
        int rootDocId = this.rootDocs.nextSetBit(parentDocId);
        if (this.currentRootDoc == rootDocId) {
            IntArrayList childDocIdBuffer = this.childDocIdBuffers.get(parentDocId);
            if (childDocIdBuffer != null) {
                return childDocIdBuffer;
            }
            IntArrayList newChildDocIdBuffer = new IntArrayList();
            this.childDocIdBuffers.put(parentDocId, newChildDocIdBuffer);
            int prevParentDoc = this.parentDocs.prevSetBit(parentDocId - 1);
            int childDocId = this.childDocs.docID() > prevParentDoc ? this.childDocs.docID() : this.childDocs.advance(prevParentDoc + 1);
            while (childDocId < parentDocId) {
                newChildDocIdBuffer.add(childDocId);
                childDocId = this.childDocs.nextDoc();
            }
            return newChildDocIdBuffer;
        }
        this.currentRootDoc = rootDocId;
        this.childDocIdBuffers.clear();
        return this.getChildren(parentDocId);
    }

    public static class Factory
    extends AggregatorFactory {
        private final String path;

        public Factory(String name, String path) {
            super(name, InternalNested.TYPE.name());
            this.path = path;
        }

        @Override
        public Aggregator create(AggregationContext context, Aggregator parent, long expectedBucketsCount) {
            MapperService.SmartNameObjectMapper mapper = context.searchContext().smartNameObjectMapper(this.path);
            if (mapper == null) {
                return new Unmapped(this.name, context, parent);
            }
            ObjectMapper objectMapper = mapper.mapper();
            if (objectMapper == null) {
                return new Unmapped(this.name, context, parent);
            }
            if (!objectMapper.nested().isNested()) {
                throw new AggregationExecutionException("[nested] nested path [" + this.path + "] is not nested");
            }
            return new NestedAggregator(this.name, this.factories, objectMapper, context, parent);
        }

        private static final class Unmapped
        extends NonCollectingAggregator {
            public Unmapped(String name, AggregationContext context, Aggregator parent) {
                super(name, context, parent);
            }

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return new InternalNested(this.name, 0L, this.buildEmptySubAggregations());
            }
        }
    }
}

