/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms.support;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.hppc.LongOpenHashSet;
import org.elasticsearch.common.hppc.LongSet;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

public class IncludeExclude {
    private final Matcher include;
    private final Matcher exclude;
    private final CharsRefBuilder scratch = new CharsRefBuilder();
    private Set<BytesRef> includeValues;
    private Set<BytesRef> excludeValues;
    private final boolean hasRegexTest;

    public IncludeExclude(Pattern include, Pattern exclude, Set<BytesRef> includeValues, Set<BytesRef> excludeValues) {
        assert (includeValues != null || include != null || exclude != null || excludeValues != null) : "includes & excludes cannot both be null";
        this.include = include != null ? include.matcher("") : null;
        this.exclude = exclude != null ? exclude.matcher("") : null;
        this.hasRegexTest = include != null || exclude != null;
        this.includeValues = includeValues;
        this.excludeValues = excludeValues;
    }

    public boolean accept(BytesRef value) {
        if (this.hasRegexTest) {
            this.scratch.copyUTF8Bytes(value);
        }
        return this.isIncluded(value, this.scratch.get()) && !this.isExcluded(value, this.scratch.get());
    }

    private boolean isIncluded(BytesRef value, CharsRef utf16Chars) {
        if (this.includeValues == null && this.include == null) {
            return true;
        }
        if (this.include != null && this.include.reset((CharSequence)this.scratch.get()).matches()) {
            return true;
        }
        return this.includeValues != null && this.includeValues.contains(value);
    }

    private boolean isExcluded(BytesRef value, CharsRef utf16Chars) {
        if (this.exclude != null && this.exclude.reset((CharSequence)this.scratch.get()).matches()) {
            return true;
        }
        return this.excludeValues != null && this.excludeValues.contains(value);
    }

    public LongBitSet acceptedGlobalOrdinals(RandomAccessOrds globalOrdinals, ValuesSource.Bytes.WithOrdinals valueSource) {
        LongBitSet acceptedGlobalOrdinals = new LongBitSet(globalOrdinals.getValueCount());
        if (this.includeValues != null) {
            for (BytesRef includeValue : this.includeValues) {
                long ord;
                this.scratch.copyUTF8Bytes(includeValue);
                if (this.isExcluded(includeValue, this.scratch.get()) || (ord = globalOrdinals.lookupTerm(includeValue)) < 0L) continue;
                acceptedGlobalOrdinals.set(ord);
            }
        } else if (this.hasRegexTest) {
            TermsEnum globalTermsEnum = valueSource.globalOrdinalsValues().termsEnum();
            try {
                BytesRef term = globalTermsEnum.next();
                while (term != null) {
                    if (this.accept(term)) {
                        acceptedGlobalOrdinals.set(globalTermsEnum.ord());
                    }
                    term = globalTermsEnum.next();
                }
            }
            catch (IOException e) {
                throw ExceptionsHelper.convertToElastic(e);
            }
        } else {
            acceptedGlobalOrdinals.set(0L, acceptedGlobalOrdinals.length());
            for (BytesRef excludeValue : this.excludeValues) {
                long ord = globalOrdinals.lookupTerm(excludeValue);
                if (ord < 0L) continue;
                acceptedGlobalOrdinals.clear(ord);
            }
        }
        return acceptedGlobalOrdinals;
    }

    public boolean isRegexBased() {
        return this.hasRegexTest;
    }

    public LongFilter convertToLongFilter() {
        int numValids = this.includeValues == null ? 0 : this.includeValues.size();
        int numInvalids = this.excludeValues == null ? 0 : this.excludeValues.size();
        LongFilter result = new LongFilter(numValids, numInvalids);
        if (this.includeValues != null) {
            for (BytesRef val : this.includeValues) {
                result.addAccept(Long.parseLong(val.utf8ToString()));
            }
        }
        if (this.excludeValues != null) {
            for (BytesRef val : this.excludeValues) {
                result.addReject(Long.parseLong(val.utf8ToString()));
            }
        }
        return result;
    }

    public LongFilter convertToDoubleFilter() {
        double dval;
        int numValids = this.includeValues == null ? 0 : this.includeValues.size();
        int numInvalids = this.excludeValues == null ? 0 : this.excludeValues.size();
        LongFilter result = new LongFilter(numValids, numInvalids);
        if (this.includeValues != null) {
            for (BytesRef val : this.includeValues) {
                dval = Double.parseDouble(val.utf8ToString());
                result.addAccept(NumericUtils.doubleToSortableLong((double)dval));
            }
        }
        if (this.excludeValues != null) {
            for (BytesRef val : this.excludeValues) {
                dval = Double.parseDouble(val.utf8ToString());
                result.addReject(NumericUtils.doubleToSortableLong((double)dval));
            }
        }
        return result;
    }

    public static class Parser {
        private final String aggName;
        private final InternalAggregation.Type aggType;
        private final SearchContext context;
        String include = null;
        int includeFlags = 0;
        String exclude = null;
        int excludeFlags = 0;
        Set<BytesRef> includeValues;
        Set<BytesRef> excludeValues;

        public Parser(String aggName, InternalAggregation.Type aggType, SearchContext context) {
            this.aggName = aggName;
            this.aggType = aggType;
            this.context = context;
        }

        public boolean token(String currentFieldName, XContentParser.Token token, XContentParser parser) throws IOException {
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("include".equals(currentFieldName)) {
                    this.include = parser.text();
                } else if ("exclude".equals(currentFieldName)) {
                    this.exclude = parser.text();
                } else {
                    return false;
                }
                return true;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("include".equals(currentFieldName)) {
                    this.includeValues = this.parseArrayToSet(parser);
                    return true;
                }
                if ("exclude".equals(currentFieldName)) {
                    this.excludeValues = this.parseArrayToSet(parser);
                    return true;
                }
                return false;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("include".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_STRING) {
                            if ("pattern".equals(currentFieldName)) {
                                this.include = parser.text();
                                continue;
                            }
                            if (!"flags".equals(currentFieldName)) continue;
                            this.includeFlags = Regex.flagsFromString(parser.text());
                            continue;
                        }
                        if (token != XContentParser.Token.VALUE_NUMBER || !"flags".equals(currentFieldName)) continue;
                        this.includeFlags = parser.intValue();
                    }
                } else if ("exclude".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_STRING) {
                            if ("pattern".equals(currentFieldName)) {
                                this.exclude = parser.text();
                                continue;
                            }
                            if (!"flags".equals(currentFieldName)) continue;
                            this.excludeFlags = Regex.flagsFromString(parser.text());
                            continue;
                        }
                        if (token != XContentParser.Token.VALUE_NUMBER || !"flags".equals(currentFieldName)) continue;
                        this.excludeFlags = parser.intValue();
                    }
                } else {
                    return false;
                }
                return true;
            }
            return false;
        }

        private Set<BytesRef> parseArrayToSet(XContentParser parser) throws IOException {
            HashSet<BytesRef> set = new HashSet<BytesRef>();
            if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
                throw new ElasticsearchParseException("Missing start of array in include/exclude clause");
            }
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                if (!parser.currentToken().isValue()) {
                    throw new ElasticsearchParseException("Array elements in include/exclude clauses should be string values");
                }
                set.add(new BytesRef((CharSequence)parser.text()));
            }
            return set;
        }

        public IncludeExclude includeExclude() {
            if (this.include == null && this.exclude == null && this.includeValues == null && this.excludeValues == null) {
                return null;
            }
            Pattern includePattern = this.include != null ? Pattern.compile(this.include, this.includeFlags) : null;
            Pattern excludePattern = this.exclude != null ? Pattern.compile(this.exclude, this.excludeFlags) : null;
            return new IncludeExclude(includePattern, excludePattern, this.includeValues, this.excludeValues);
        }
    }

    public static class LongFilter {
        private LongSet valids;
        private LongSet invalids;

        private LongFilter(int numValids, int numInvalids) {
            if (numValids > 0) {
                this.valids = new LongOpenHashSet(numValids);
            }
            if (numInvalids > 0) {
                this.invalids = new LongOpenHashSet(numInvalids);
            }
        }

        public boolean accept(long value) {
            return !(this.valids != null && !this.valids.contains(value) || this.invalids != null && this.invalids.contains(value));
        }

        private void addAccept(long val) {
            this.valids.add(val);
        }

        private void addReject(long val) {
            this.invalids.add(val);
        }
    }
}

