/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo;

import java.io.Serializable;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.ElementBase;
import org.vertexium.Graph;
import org.vertexium.HasTimestamp;
import org.vertexium.HistoricalPropertyValue;
import org.vertexium.Property;
import org.vertexium.Visibility;
import org.vertexium.accumulo.AccumuloEdge;
import org.vertexium.accumulo.AccumuloGraph;
import org.vertexium.accumulo.iterator.ElementIterator;
import org.vertexium.mutation.EdgeMutation;
import org.vertexium.mutation.ExistingElementMutationImpl;
import org.vertexium.mutation.PropertyDeleteMutation;
import org.vertexium.mutation.PropertySoftDeleteMutation;

public abstract class AccumuloElement
extends ElementBase
implements Serializable,
HasTimestamp {
    private static final long serialVersionUID = 1L;
    public static final Text CF_PROPERTY = ElementIterator.CF_PROPERTY;
    public static final Text CF_PROPERTY_METADATA = ElementIterator.CF_PROPERTY_METADATA;
    public static final Text CF_PROPERTY_SOFT_DELETE = ElementIterator.CF_PROPERTY_SOFT_DELETE;
    public static final Value SOFT_DELETE_VALUE = ElementIterator.SOFT_DELETE_VALUE;
    public static final Value HIDDEN_VALUE = ElementIterator.HIDDEN_VALUE;
    public static final Text CF_PROPERTY_HIDDEN = ElementIterator.CF_PROPERTY_HIDDEN;
    public static final Value HIDDEN_VALUE_DELETED = ElementIterator.HIDDEN_VALUE_DELETED;
    public static final Text DELETE_ROW_COLUMN_FAMILY = ElementIterator.DELETE_ROW_COLUMN_FAMILY;
    public static final Text DELETE_ROW_COLUMN_QUALIFIER = ElementIterator.DELETE_ROW_COLUMN_QUALIFIER;
    public static final Text CF_SOFT_DELETE = ElementIterator.CF_SOFT_DELETE;
    public static final Text CQ_SOFT_DELETE = ElementIterator.CQ_SOFT_DELETE;
    public static final Text CF_HIDDEN = ElementIterator.CF_HIDDEN;
    public static final Text CQ_HIDDEN = ElementIterator.CQ_HIDDEN;
    public static final Text METADATA_COLUMN_FAMILY = ElementIterator.METADATA_COLUMN_FAMILY;
    public static final Text METADATA_COLUMN_QUALIFIER = ElementIterator.METADATA_COLUMN_QUALIFIER;

    protected AccumuloElement(Graph graph, String id, Visibility visibility, Iterable<Property> properties, Iterable<PropertyDeleteMutation> propertyDeleteMutations, Iterable<PropertySoftDeleteMutation> propertySoftDeleteMutations, Iterable<Visibility> hiddenVisibilities, long timestamp, Authorizations authorizations) {
        super(graph, id, visibility, properties, propertyDeleteMutations, propertySoftDeleteMutations, hiddenVisibilities, timestamp, authorizations);
    }

    public void deleteProperty(String key, String name, Authorizations authorizations) {
        Property property = super.removePropertyInternal(key, name);
        if (property != null) {
            this.getGraph().deleteProperty(this, property, authorizations);
        }
    }

    public void deleteProperty(String key, String name, Visibility visibility, Authorizations authorizations) {
        Property property = super.removePropertyInternal(key, name, visibility);
        if (property != null) {
            this.getGraph().deleteProperty(this, property, authorizations);
        }
    }

    public void softDeleteProperty(String key, String name, Authorizations authorizations) {
        Property property = super.softDeletePropertyInternal(key, name);
        if (property != null) {
            this.getGraph().softDeleteProperty(this, property, authorizations);
        }
    }

    public void softDeleteProperty(String key, String name, Visibility visibility, Authorizations authorizations) {
        Property property = super.softDeletePropertyInternal(key, name, visibility);
        if (property != null) {
            this.getGraph().softDeleteProperty(this, property, authorizations);
        }
    }

    public void deleteProperties(String name, Authorizations authorizations) {
        Iterable properties = super.removePropertyInternal(name);
        for (Property property : properties) {
            this.getGraph().deleteProperty(this, property, authorizations);
        }
    }

    public void softDeleteProperties(String name, Authorizations authorizations) {
        Iterable properties = super.removePropertyInternal(name);
        for (Property property : properties) {
            this.getGraph().softDeleteProperty(this, property, authorizations);
        }
    }

    public void markPropertyHidden(Property property, Long timestamp, Visibility visibility, Authorizations authorizations) {
        this.getGraph().markPropertyHidden(this, property, timestamp, visibility, authorizations);
    }

    public void markPropertyVisible(Property property, Long timestamp, Visibility visibility, Authorizations authorizations) {
        this.getGraph().markPropertyVisible(this, property, timestamp, visibility, authorizations);
    }

    public AccumuloGraph getGraph() {
        return (AccumuloGraph)super.getGraph();
    }

    protected void setVisibility(Visibility visibility) {
        super.setVisibility(visibility);
    }

    protected <TElement extends Element> void saveExistingElementMutation(ExistingElementMutationImpl<TElement> mutation, Authorizations authorizations) {
        EdgeMutation edgeMutation;
        String newEdgeLabel;
        this.getGraph().alterPropertyMetadatas((AccumuloElement)mutation.getElement(), mutation.getSetPropertyMetadatas());
        this.getGraph().alterElementPropertyVisibilities((AccumuloElement)mutation.getElement(), mutation.getAlterPropertyVisibilities(), authorizations);
        Iterable propertyDeletes = mutation.getPropertyDeletes();
        Iterable propertySoftDeletes = mutation.getPropertySoftDeletes();
        Iterable properties = mutation.getProperties();
        this.updatePropertiesInternal(properties, propertyDeletes, propertySoftDeletes);
        this.getGraph().saveProperties((AccumuloElement)mutation.getElement(), properties, propertyDeletes, propertySoftDeletes, mutation.getIndexHint(), authorizations);
        if (mutation.getNewElementVisibility() != null) {
            this.getGraph().alterElementVisibility((AccumuloElement)mutation.getElement(), mutation.getNewElementVisibility(), authorizations);
        }
        if (mutation instanceof EdgeMutation && (newEdgeLabel = (edgeMutation = (EdgeMutation)mutation).getNewEdgeLabel()) != null) {
            this.getGraph().alterEdgeLabel((AccumuloEdge)mutation.getElement(), newEdgeLabel);
        }
    }

    public Iterable<HistoricalPropertyValue> getHistoricalPropertyValues(String key, String name, Visibility visibility, Long startTime, Long endTime, Authorizations authorizations) {
        return this.getGraph().getHistoricalPropertyValues((Element)this, key, name, visibility, startTime, endTime, authorizations);
    }
}

