/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo;

import java.util.Iterator;
import org.vertexium.accumulo.iterator.model.EdgeInfo;
import org.vertexium.util.LookAheadIterable;

class GetVertexIdsIterable
extends LookAheadIterable<EdgeInfo, String> {
    private final Iterable<EdgeInfo> edgeInfos;
    private final String[] labels;

    public GetVertexIdsIterable(Iterable<EdgeInfo> edgeInfos, String[] labels) {
        this.edgeInfos = edgeInfos;
        this.labels = labels;
    }

    protected boolean isIncluded(EdgeInfo edgeInfo, String vertexId) {
        if (this.labels == null || this.labels.length == 0) {
            return true;
        }
        for (String label : this.labels) {
            if (!edgeInfo.getLabel().equals(label)) continue;
            return true;
        }
        return false;
    }

    protected String convert(EdgeInfo edgeInfo) {
        return edgeInfo.getVertexId();
    }

    protected Iterator<EdgeInfo> createIterator() {
        return this.edgeInfos.iterator();
    }
}

