/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.ConditionalWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.admin.NamespaceOperations;
import org.apache.accumulo.core.client.admin.ReplicationOperations;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.impl.BatchWriterImpl;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ClientExec;
import org.apache.accumulo.core.client.impl.ConditionalWriterImpl;
import org.apache.accumulo.core.client.impl.InstanceOperationsImpl;
import org.apache.accumulo.core.client.impl.MultiTableBatchWriterImpl;
import org.apache.accumulo.core.client.impl.NamespaceOperationsImpl;
import org.apache.accumulo.core.client.impl.ReplicationOperationsImpl;
import org.apache.accumulo.core.client.impl.ScannerImpl;
import org.apache.accumulo.core.client.impl.SecurityOperationsImpl;
import org.apache.accumulo.core.client.impl.ServerClient;
import org.apache.accumulo.core.client.impl.TableOperationsImpl;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletServerBatchDeleter;
import org.apache.accumulo.core.client.impl.TabletServerBatchReader;
import org.apache.accumulo.core.client.impl.thrift.ClientService;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.Tracer;

public class ConnectorImpl
extends Connector {
    private static final String SYSTEM_TOKEN_NAME = "org.apache.accumulo.server.security.SystemCredentials$SystemToken";
    private final ClientContext context;
    private SecurityOperations secops = null;
    private TableOperationsImpl tableops = null;
    private NamespaceOperations namespaceops = null;
    private InstanceOperations instanceops = null;
    private ReplicationOperations replicationops = null;

    public ConnectorImpl(final ClientContext context) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        if (context.getCredentials().getToken().isDestroyed()) {
            throw new AccumuloSecurityException(context.getCredentials().getPrincipal(), SecurityErrorCode.TOKEN_EXPIRED);
        }
        this.context = context;
        String tokenClassName = context.getCredentials().getToken().getClass().getName();
        if (!SYSTEM_TOKEN_NAME.equals(tokenClassName)) {
            ServerClient.execute(context, new ClientExec<ClientService.Client>(){

                @Override
                public void execute(ClientService.Client iface) throws Exception {
                    if (!iface.authenticate(Tracer.traceInfo(), context.rpcCreds())) {
                        throw new AccumuloSecurityException("Authentication failed, access denied", SecurityErrorCode.BAD_CREDENTIALS);
                    }
                }
            });
        }
        this.tableops = new TableOperationsImpl(context);
        this.namespaceops = new NamespaceOperationsImpl(context, this.tableops);
    }

    private String getTableId(String tableName) throws TableNotFoundException {
        String tableId = Tables.getTableId(this.context.getInstance(), tableName);
        if (Tables.getTableState(this.context.getInstance(), tableId) == TableState.OFFLINE) {
            throw new TableOfflineException(this.context.getInstance(), tableId);
        }
        return tableId;
    }

    @Override
    public Instance getInstance() {
        return this.context.getInstance();
    }

    @Override
    public BatchScanner createBatchScanner(String tableName, Authorizations authorizations, int numQueryThreads) throws TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        return new TabletServerBatchReader(this.context, this.getTableId(tableName), authorizations, numQueryThreads);
    }

    @Override
    @Deprecated
    public BatchDeleter createBatchDeleter(String tableName, Authorizations authorizations, int numQueryThreads, long maxMemory, long maxLatency, int maxWriteThreads) throws TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        return new TabletServerBatchDeleter(this.context, this.getTableId(tableName), authorizations, numQueryThreads, new BatchWriterConfig().setMaxMemory(maxMemory).setMaxLatency(maxLatency, TimeUnit.MILLISECONDS).setMaxWriteThreads(maxWriteThreads));
    }

    @Override
    public BatchDeleter createBatchDeleter(String tableName, Authorizations authorizations, int numQueryThreads, BatchWriterConfig config) throws TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        return new TabletServerBatchDeleter(this.context, this.getTableId(tableName), authorizations, numQueryThreads, config);
    }

    @Override
    @Deprecated
    public BatchWriter createBatchWriter(String tableName, long maxMemory, long maxLatency, int maxWriteThreads) throws TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        return new BatchWriterImpl(this.context, this.getTableId(tableName), new BatchWriterConfig().setMaxMemory(maxMemory).setMaxLatency(maxLatency, TimeUnit.MILLISECONDS).setMaxWriteThreads(maxWriteThreads));
    }

    @Override
    public BatchWriter createBatchWriter(String tableName, BatchWriterConfig config) throws TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        return new BatchWriterImpl(this.context, this.getTableId(tableName), config);
    }

    @Override
    @Deprecated
    public MultiTableBatchWriter createMultiTableBatchWriter(long maxMemory, long maxLatency, int maxWriteThreads) {
        return new MultiTableBatchWriterImpl(this.context, new BatchWriterConfig().setMaxMemory(maxMemory).setMaxLatency(maxLatency, TimeUnit.MILLISECONDS).setMaxWriteThreads(maxWriteThreads));
    }

    @Override
    public MultiTableBatchWriter createMultiTableBatchWriter(BatchWriterConfig config) {
        return new MultiTableBatchWriterImpl(this.context, config);
    }

    @Override
    public ConditionalWriter createConditionalWriter(String tableName, ConditionalWriterConfig config) throws TableNotFoundException {
        return new ConditionalWriterImpl(this.context, this.getTableId(tableName), config);
    }

    @Override
    public Scanner createScanner(String tableName, Authorizations authorizations) throws TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        return new ScannerImpl(this.context, this.getTableId(tableName), authorizations);
    }

    @Override
    public String whoami() {
        return this.context.getCredentials().getPrincipal();
    }

    @Override
    public synchronized TableOperations tableOperations() {
        return this.tableops;
    }

    @Override
    public synchronized NamespaceOperations namespaceOperations() {
        return this.namespaceops;
    }

    @Override
    public synchronized SecurityOperations securityOperations() {
        if (this.secops == null) {
            this.secops = new SecurityOperationsImpl(this.context);
        }
        return this.secops;
    }

    @Override
    public synchronized InstanceOperations instanceOperations() {
        if (this.instanceops == null) {
            this.instanceops = new InstanceOperationsImpl(this.context);
        }
        return this.instanceops;
    }

    @Override
    public synchronized ReplicationOperations replicationOperations() {
        if (null == this.replicationops) {
            this.replicationops = new ReplicationOperationsImpl(this.context);
        }
        return this.replicationops;
    }
}

