/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccumuloConfiguration
implements Iterable<Map.Entry<String, String>> {
    private static final Logger log = LoggerFactory.getLogger(AccumuloConfiguration.class);

    public String get(String property) {
        HashMap<String, String> propMap = new HashMap<String, String>(1);
        this.getProperties(propMap, new MatchFilter(property));
        return (String)propMap.get(property);
    }

    public abstract String get(Property var1);

    public abstract void getProperties(Map<String, String> var1, Predicate<String> var2);

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        Predicate all = Predicates.alwaysTrue();
        TreeMap<String, String> entries = new TreeMap<String, String>();
        this.getProperties(entries, (Predicate<String>)all);
        return entries.entrySet().iterator();
    }

    private void checkType(Property property, PropertyType type) {
        if (!property.getType().equals((Object)type)) {
            String msg = "Configuration method intended for type " + (Object)((Object)type) + " called with a " + (Object)((Object)property.getType()) + " argument (" + property.getKey() + ")";
            IllegalArgumentException err = new IllegalArgumentException(msg);
            log.error(msg, (Throwable)err);
            throw err;
        }
    }

    public Map<String, String> getAllPropertiesWithPrefix(Property property) {
        this.checkType(property, PropertyType.PREFIX);
        HashMap<String, String> propMap = new HashMap<String, String>();
        this.getProperties(propMap, new PrefixFilter(property.getKey()));
        return propMap;
    }

    public long getMemoryInBytes(Property property) {
        this.checkType(property, PropertyType.MEMORY);
        String memString = this.get(property);
        return AccumuloConfiguration.getMemoryInBytes(memString);
    }

    public static long getMemoryInBytes(String str) {
        char lastChar = str.charAt(str.length() - 1);
        if (lastChar == 'b') {
            log.warn("The 'b' in " + str + " is being considered as bytes. " + "Setting memory by bits is not supported");
        }
        try {
            int multiplier;
            switch (Character.toUpperCase(lastChar)) {
                case 'G': {
                    multiplier = 30;
                    break;
                }
                case 'M': {
                    multiplier = 20;
                    break;
                }
                case 'K': {
                    multiplier = 10;
                    break;
                }
                case 'B': {
                    multiplier = 0;
                    break;
                }
                default: {
                    return Long.parseLong(str);
                }
            }
            return Long.parseLong(str.substring(0, str.length() - 1)) << multiplier;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("The value '" + str + "' is not a valid memory setting. A valid value would a number " + "possibily followed by an optional 'G', 'M', 'K', or 'B'.");
        }
    }

    public long getTimeInMillis(Property property) {
        this.checkType(property, PropertyType.TIMEDURATION);
        return AccumuloConfiguration.getTimeInMillis(this.get(property));
    }

    public static long getTimeInMillis(String str) {
        TimeUnit timeUnit;
        int unitsLen = 1;
        switch (str.charAt(str.length() - 1)) {
            case 'd': {
                timeUnit = TimeUnit.DAYS;
                break;
            }
            case 'h': {
                timeUnit = TimeUnit.HOURS;
                break;
            }
            case 'm': {
                timeUnit = TimeUnit.MINUTES;
                break;
            }
            case 's': {
                timeUnit = TimeUnit.SECONDS;
                if (!str.endsWith("ms")) break;
                timeUnit = TimeUnit.MILLISECONDS;
                unitsLen = 2;
                break;
            }
            default: {
                timeUnit = TimeUnit.SECONDS;
                unitsLen = 0;
            }
        }
        return timeUnit.toMillis(Long.parseLong(str.substring(0, str.length() - unitsLen)));
    }

    public boolean getBoolean(Property property) {
        this.checkType(property, PropertyType.BOOLEAN);
        return Boolean.parseBoolean(this.get(property));
    }

    public double getFraction(Property property) {
        this.checkType(property, PropertyType.FRACTION);
        return this.getFraction(this.get(property));
    }

    public double getFraction(String str) {
        if (str.charAt(str.length() - 1) == '%') {
            return Double.parseDouble(str.substring(0, str.length() - 1)) / 100.0;
        }
        return Double.parseDouble(str);
    }

    public int getPort(Property property) {
        this.checkType(property, PropertyType.PORT);
        String portString = this.get(property);
        int port = Integer.parseInt(portString);
        if (port != 0 && (port < 1024 || port > 65535)) {
            log.error("Invalid port number " + port + "; Using default " + property.getDefaultValue());
            port = Integer.parseInt(property.getDefaultValue());
        }
        return port;
    }

    public int getCount(Property property) {
        this.checkType(property, PropertyType.COUNT);
        String countString = this.get(property);
        return Integer.parseInt(countString);
    }

    public String getPath(Property property) {
        this.checkType(property, PropertyType.PATH);
        String pathString = this.get(property);
        if (pathString == null) {
            return null;
        }
        for (String replaceableEnvVar : Constants.PATH_PROPERTY_ENV_VARS) {
            String envValue = System.getenv(replaceableEnvVar);
            if (envValue == null) continue;
            pathString = pathString.replace("$" + replaceableEnvVar, envValue);
        }
        return pathString;
    }

    public static synchronized DefaultConfiguration getDefaultConfiguration() {
        return DefaultConfiguration.getInstance();
    }

    public static AccumuloConfiguration getTableConfiguration(Connector conn, String tableId) throws TableNotFoundException, AccumuloException {
        String tableName = Tables.getTableName(conn.getInstance(), tableId);
        return new ConfigurationCopy(conn.tableOperations().getProperties(tableName));
    }

    public int getMaxFilesPerTablet() {
        int maxFilesPerTablet = this.getCount(Property.TABLE_FILE_MAX);
        if (maxFilesPerTablet <= 0) {
            maxFilesPerTablet = this.getCount(Property.TSERV_SCAN_MAX_OPENFILES) - 1;
            log.debug("Max files per tablet " + maxFilesPerTablet);
        }
        return maxFilesPerTablet;
    }

    public void invalidateCache() {
    }

    public <T> T instantiateClassProperty(Property property, Class<T> base, T defaultInstance) {
        String clazzName = this.get(property);
        T instance = null;
        try {
            Class clazz = AccumuloVFSClassLoader.loadClass((String)clazzName, base);
            instance = clazz.newInstance();
            log.info("Loaded class : " + clazzName);
        }
        catch (Exception e) {
            log.warn("Failed to load class ", (Throwable)e);
        }
        if (instance == null) {
            log.info("Using " + defaultInstance.getClass().getName());
            instance = defaultInstance;
        }
        return instance;
    }

    public static class PrefixFilter
    implements Predicate<String> {
        private String prefix;

        public PrefixFilter(String prefix) {
            this.prefix = prefix;
        }

        public boolean apply(String key) {
            return key.startsWith(this.prefix);
        }
    }

    public static class MatchFilter
    implements Predicate<String> {
        private String match;

        public MatchFilter(String match) {
            this.match = match;
        }

        public boolean apply(String key) {
            return Objects.equals(this.match, key);
        }
    }

    @Deprecated
    public static interface PropertyFilter {
        public boolean accept(String var1);
    }
}

