/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import org.apache.htrace.fasterxml.jackson.core.JsonGenerator;
import org.apache.htrace.fasterxml.jackson.databind.JsonMappingException;
import org.apache.htrace.fasterxml.jackson.databind.JsonSerializer;
import org.apache.htrace.fasterxml.jackson.databind.PropertyName;
import org.apache.htrace.fasterxml.jackson.databind.SerializerProvider;
import org.apache.htrace.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import org.apache.htrace.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.htrace.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.htrace.fasterxml.jackson.databind.ser.PropertyWriter;

public class MapProperty
extends PropertyWriter {
    protected TypeSerializer _typeSerializer;
    protected Object _key;
    protected Object _value;
    protected JsonSerializer<Object> _keySerializer;
    protected JsonSerializer<Object> _valueSerializer;

    public MapProperty(TypeSerializer typeSer) {
        this._typeSerializer = typeSer;
    }

    public void reset(Object key, Object value, JsonSerializer<Object> keySer, JsonSerializer<Object> valueSer) {
        this._key = key;
        this._value = value;
        this._keySerializer = keySer;
        this._valueSerializer = valueSer;
    }

    @Override
    public String getName() {
        if (this._key instanceof String) {
            return (String)this._key;
        }
        return String.valueOf(this._key);
    }

    @Override
    public PropertyName getFullName() {
        return new PropertyName(this.getName());
    }

    @Override
    public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        this._keySerializer.serialize(this._key, jgen, provider);
        if (this._typeSerializer == null) {
            this._valueSerializer.serialize(this._value, jgen, provider);
        } else {
            this._valueSerializer.serializeWithType(this._value, jgen, provider, this._typeSerializer);
        }
    }

    @Override
    public void serializeAsOmittedField(Object pojo, JsonGenerator jgen, SerializerProvider provider) throws Exception {
        if (!jgen.canOmitFields()) {
            jgen.writeOmittedField(this.getName());
        }
    }

    @Override
    public void serializeAsElement(Object pojo, JsonGenerator jgen, SerializerProvider provider) throws Exception {
        if (this._typeSerializer == null) {
            this._valueSerializer.serialize(this._value, jgen, provider);
        } else {
            this._valueSerializer.serializeWithType(this._value, jgen, provider, this._typeSerializer);
        }
    }

    @Override
    public void serializeAsPlaceholder(Object pojo, JsonGenerator jgen, SerializerProvider provider) throws Exception {
        jgen.writeNull();
    }

    @Override
    public void depositSchemaProperty(JsonObjectFormatVisitor objectVisitor) throws JsonMappingException {
    }

    @Override
    @Deprecated
    public void depositSchemaProperty(ObjectNode propertiesNode, SerializerProvider provider) throws JsonMappingException {
    }
}

