/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import java.util.concurrent.Future;
import org.cache2k.ClosableIterator;
import org.cache2k.impl.BaseCache;
import org.cache2k.impl.Entry;
import org.cache2k.impl.NoopStorageAdapter;
import org.cache2k.impl.StorageAdapter;
import org.cache2k.impl.threading.Futures;
import org.cache2k.storage.StorageEntry;

public class AggregationStorageAdapter
extends StorageAdapter
implements StorageAdapter.Parent {
    StorageAdapter.Parent parent;
    BaseCache cache;
    StorageAdapter[] storages;

    @Override
    public void open() {
        for (StorageAdapter a : this.storages) {
            a.open();
        }
    }

    @Override
    public void flush() {
        for (StorageAdapter a : this.storages) {
            a.flush();
        }
    }

    @Override
    public void purge() {
        for (StorageAdapter a : this.storages) {
            a.purge();
        }
    }

    @Override
    public Future<Void> shutdown() {
        Futures.WaitForAllFuture<Void> _waitForAll = new Futures.WaitForAllFuture<Void>(new Future[0]);
        for (StorageAdapter a : this.storages) {
            _waitForAll.add(a.shutdown());
        }
        return _waitForAll;
    }

    @Override
    public boolean checkStorageStillDisconnectedForClear() {
        boolean _flag = true;
        for (StorageAdapter a : this.storages) {
            _flag &= a.checkStorageStillDisconnectedForClear();
        }
        return _flag;
    }

    @Override
    public void disconnectStorageForClear() {
        for (StorageAdapter a : this.storages) {
            a.disconnectStorageForClear();
        }
    }

    @Override
    public Future<Void> clearAndReconnect() {
        Futures.WaitForAllFuture<Void> _waitForAllFuture = new Futures.WaitForAllFuture<Void>(new Future[0]);
        for (StorageAdapter a : this.storages) {
            _waitForAllFuture.add(a.clearAndReconnect());
        }
        return _waitForAllFuture;
    }

    @Override
    public void put(Entry e, long _nextRefreshTime) {
        for (StorageAdapter a : this.storages) {
            a.put(e, _nextRefreshTime);
        }
    }

    @Override
    public StorageEntry get(Object key) {
        for (StorageAdapter a : this.storages) {
            StorageEntry e = a.get(key);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    @Override
    public boolean remove(Object key) {
        boolean f = false;
        for (StorageAdapter a : this.storages) {
            f |= a.remove(key);
        }
        return f;
    }

    @Override
    public void evict(Entry e) {
        for (StorageAdapter a : this.storages) {
            a.evict(e);
        }
    }

    @Override
    public void expire(Entry e) {
        for (StorageAdapter a : this.storages) {
            a.expire(e);
        }
    }

    @Override
    public ClosableIterator<Entry> iterateAll() {
        return this.storages[this.storages.length - 1].iterateAll();
    }

    @Override
    public int getTotalEntryCount() {
        int cnt = 0;
        for (StorageAdapter a : this.storages) {
            cnt = Math.max(a.getTotalEntryCount(), cnt);
        }
        return cnt;
    }

    @Override
    public int getAlert() {
        int _level = 0;
        for (StorageAdapter a : this.storages) {
            if (a.getAlert() <= _level) continue;
            _level = a.getAlert();
        }
        return _level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disable(Throwable t) {
        Object object = this.cache.lock;
        synchronized (object) {
            this.parent.resetStorage(this, new NoopStorageAdapter(this.cache));
            this.parent = null;
            for (StorageAdapter a : this.storages) {
                a.disable(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void resetStorage(StorageAdapter _current, StorageAdapter _new) {
        StorageAdapter[] sa;
        Object object = this.cache.lock;
        // MONITORENTER : object
        if (this.parent == null) {
            // MONITOREXIT : object
            return;
        }
        if (_new instanceof NoopStorageAdapter) {
            StorageAdapter[] sa2;
            if (this.storages.length == 1) {
                this.parent.resetStorage(this, _new);
                return;
            }
            StorageAdapter[] storageAdapterArray = sa2 = new StorageAdapter[this.storages.length - 1];
            // MONITORENTER : sa2
            int i = 0;
            StorageAdapter[] arr$ = this.storages;
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                if (i$ >= len$) {
                    // MONITOREXIT : storageAdapterArray
                    this.storages = sa2;
                    return;
                }
                StorageAdapter a = arr$[i$];
                if (a != _current) {
                    sa2[i++] = a;
                }
                ++i$;
            }
        }
        StorageAdapter[] storageAdapterArray = sa = new StorageAdapter[this.storages.length];
        // MONITORENTER : sa
        int i = 0;
        StorageAdapter[] arr$ = this.storages;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            if (i$ >= len$) {
                // MONITOREXIT : storageAdapterArray
                this.storages = sa;
                // MONITOREXIT : object
                return;
            }
            StorageAdapter a = arr$[i$];
            sa[i++] = a != _current ? a : _new;
            ++i$;
        }
    }

    @Override
    public Future<Void> cancelTimerJobs() {
        Futures.WaitForAllFuture<Void> w = new Futures.WaitForAllFuture<Void>(new Future[0]);
        for (StorageAdapter s : this.storages) {
            Future<Void> f = s.cancelTimerJobs();
            if (f == null) continue;
            w.add(f);
        }
        return w;
    }
}

