/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.storage;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.cache2k.storage.Marshaller;
import org.cache2k.storage.MarshallerFactory;

public class Marshallers
implements MarshallerFactory {
    private static ServiceLoader<? extends MarshallerFactory> loader = ServiceLoader.load(MarshallerFactory.class);
    private static MarshallerFactory instance;
    private Set<MarshallerFactory> factorySet = new HashSet<MarshallerFactory>();
    private Map<Class<?>, MarshallerFactory> type2factory = new HashMap();
    private Map<Class<?>, MarshallerFactory> factoryType2factory = new HashMap();

    public static MarshallerFactory getInstance() {
        if (instance == null) {
            instance = new Marshallers();
        }
        return instance;
    }

    public synchronized void registerMarshallerFactory(MarshallerFactory f) {
        this.factorySet.add(f);
        this.type2factory.clear();
        this.factoryType2factory.clear();
    }

    @Override
    public Class<?> getType() {
        return Object.class;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public synchronized Marshaller createMarshaller(Class<?> _type) {
        return this.resolveFactory(_type).createMarshaller(_type);
    }

    @Override
    public synchronized Marshaller createMarshaller(MarshallerFactory.Parameters c) {
        if (c.getMarshallerFactory() != null) {
            MarshallerFactory f = this.factoryType2factory.get(c.getMarshallerFactory());
            if (f == null) {
                try {
                    f = (MarshallerFactory)c.getMarshallerFactory().newInstance();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
                this.factoryType2factory.put(c.getMarshallerFactory(), f);
            }
            return f.createMarshaller(c);
        }
        try {
            Marshaller m = (Marshaller)c.getMarshallerType().newInstance();
            return m;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    MarshallerFactory resolveFactory(Class<?> _type) {
        MarshallerFactory f = this.type2factory.get(_type);
        if (f != null) {
            return f;
        }
        for (MarshallerFactory marshallerFactory : loader) {
            this.factorySet.add(marshallerFactory);
        }
        for (MarshallerFactory marshallerFactory : this.factorySet) {
            if (!marshallerFactory.getType().isAssignableFrom(_type) || f != null && f.getPriority() >= marshallerFactory.getPriority()) continue;
            f = marshallerFactory;
        }
        this.type2factory.put(_type, f);
        return f;
    }
}

