/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintDeclarationException;
import org.hibernate.validator.internal.metadata.aggregated.AbstractConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.MetaDataBuilder;
import org.hibernate.validator.internal.metadata.aggregated.ParameterMetaData;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.MethodDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.MethodConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedMethod;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.method.metadata.MethodDescriptor;
import org.hibernate.validator.method.metadata.ParameterDescriptor;

public class MethodMetaData
extends AbstractConstraintMetaData {
    private static final Log log = LoggerFactory.make();
    private final Class<?>[] parameterTypes;
    private final List<ParameterMetaData> parameterMetaData;
    private final ConstraintDeclarationException parameterConstraintDeclarationException;

    private MethodMetaData(String name, Class<?> returnType, Class<?>[] parameterTypes, Set<MetaConstraint<?>> returnValueConstraints, List<ParameterMetaData> parameterMetaData, ConstraintDeclarationException parameterConstraintDeclarationException, boolean isCascading, boolean isConstrained) {
        super(name, returnType, returnValueConstraints, ConstraintMetaData.ConstraintMetaDataKind.METHOD, isCascading, isConstrained);
        this.parameterTypes = parameterTypes;
        this.parameterMetaData = Collections.unmodifiableList(parameterMetaData);
        this.parameterConstraintDeclarationException = parameterConstraintDeclarationException;
    }

    public void assertCorrectnessOfMethodParameterConstraints() throws ConstraintDeclarationException {
        if (this.parameterConstraintDeclarationException != null) {
            throw this.parameterConstraintDeclarationException;
        }
    }

    public ParameterMetaData getParameterMetaData(int parameterIndex) {
        if (parameterIndex < 0 || parameterIndex > this.parameterMetaData.size() - 1) {
            throw log.getInvalidMethodParameterIndexException(this.getName(), parameterIndex);
        }
        return this.parameterMetaData.get(parameterIndex);
    }

    public List<ParameterMetaData> getAllParameterMetaData() {
        return this.parameterMetaData;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public MethodDescriptor asDescriptor(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        return new MethodDescriptorImpl(this.getType(), this.getName(), this.asDescriptors(this.getConstraints()), this.isCascading(), this.parametersAsDescriptors(defaultGroupSequenceRedefined, defaultGroupSequence), defaultGroupSequenceRedefined, defaultGroupSequence);
    }

    private List<ParameterDescriptor> parametersAsDescriptors(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        ArrayList<ParameterDescriptor> theValue = CollectionHelper.newArrayList();
        for (ParameterMetaData oneParameter : this.parameterMetaData) {
            theValue.add((ParameterDescriptor)oneParameter.asDescriptor(defaultGroupSequenceRedefined, (List)defaultGroupSequence));
        }
        return theValue;
    }

    @Override
    public String toString() {
        StringBuilder parameterBuilder = new StringBuilder();
        for (Class<?> oneParameterType : this.getParameterTypes()) {
            parameterBuilder.append(oneParameterType.getSimpleName());
            parameterBuilder.append(", ");
        }
        String parameters = parameterBuilder.length() > 0 ? parameterBuilder.substring(0, parameterBuilder.length() - 2) : parameterBuilder.toString();
        return "MethodMetaData [method=" + this.getType().getSimpleName() + " " + this.getName() + "(" + parameters + "), isCascading=" + this.isCascading() + ", isConstrained=" + this.isConstrained() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodMetaData other = (MethodMetaData)obj;
        return Arrays.equals(this.parameterTypes, other.parameterTypes);
    }

    public static class Builder
    extends MetaDataBuilder {
        private Set<ConstrainedMethod> constrainedMethods = CollectionHelper.newHashSet();
        private MethodConstraintLocation location;
        private final Set<MetaConstraint<?>> returnValueConstraints = CollectionHelper.newHashSet();
        private boolean isCascading = false;
        private boolean isConstrained = false;

        public Builder(ConstrainedMethod constrainedMethod, ConstraintHelper constraintHelper) {
            super(constraintHelper);
            this.location = constrainedMethod.getLocation();
            this.add(constrainedMethod);
        }

        @Override
        public boolean accepts(ConstrainedElement constrainedElement) {
            return constrainedElement.getKind() == ConstrainedElement.ConstrainedElementKind.METHOD && ReflectionHelper.haveSameSignature(this.location.getMember(), ((ConstrainedMethod)constrainedElement).getLocation().getMember());
        }

        @Override
        public void add(ConstrainedElement constrainedElement) {
            ConstrainedMethod constrainedMethod = (ConstrainedMethod)constrainedElement;
            this.constrainedMethods.add(constrainedMethod);
            this.isCascading = this.isCascading || constrainedMethod.isCascading();
            this.isConstrained = this.isConstrained || constrainedMethod.isConstrained();
            this.returnValueConstraints.addAll(constrainedMethod.getConstraints());
        }

        @Override
        public MethodMetaData build() {
            Method method = this.location.getMember();
            return new MethodMetaData(method.getName(), method.getReturnType(), method.getParameterTypes(), this.adaptOriginsAndImplicitGroups(this.location.getBeanClass(), this.returnValueConstraints), this.findParameterMetaData(), this.checkParameterConstraints(), this.isCascading, this.isConstrained);
        }

        private List<ParameterMetaData> findParameterMetaData() {
            ArrayList<ParameterMetaData.Builder> parameterBuilders = null;
            for (ConstrainedMethod oneMethod : this.constrainedMethods) {
                if (parameterBuilders == null) {
                    parameterBuilders = CollectionHelper.newArrayList();
                    for (ConstrainedParameter oneParameter : oneMethod.getAllParameterMetaData()) {
                        parameterBuilders.add(new ParameterMetaData.Builder(this.location.getBeanClass(), oneParameter, this.constraintHelper));
                    }
                    continue;
                }
                int i = 0;
                for (ConstrainedParameter oneParameter : oneMethod.getAllParameterMetaData()) {
                    ((ParameterMetaData.Builder)parameterBuilders.get(i)).add(oneParameter);
                    ++i;
                }
            }
            ArrayList<ParameterMetaData> parameterMetaDatas = CollectionHelper.newArrayList();
            for (ParameterMetaData.Builder oneBuilder : parameterBuilders) {
                parameterMetaDatas.add(oneBuilder.build());
            }
            return parameterMetaDatas;
        }

        private ConstraintDeclarationException checkParameterConstraints() {
            Set<ConstrainedMethod> methodsWithParameterConstraints = this.getMethodsWithParameterConstraints(this.constrainedMethods);
            if (methodsWithParameterConstraints.isEmpty()) {
                return null;
            }
            HashSet definingTypes = CollectionHelper.newHashSet();
            for (ConstrainedMethod constrainedMethod : methodsWithParameterConstraints) {
                definingTypes.add(constrainedMethod.getLocation().getBeanClass());
            }
            if (definingTypes.size() > 1) {
                return new ConstraintDeclarationException("Only the root method of an overridden method in an inheritance hierarchy may be annotated with parameter constraints, but there are parameter constraints defined at all of the following overridden methods: " + methodsWithParameterConstraints);
            }
            ConstrainedMethod constrainedMethod = methodsWithParameterConstraints.iterator().next();
            for (ConstrainedMethod oneMethod : this.constrainedMethods) {
                if (constrainedMethod.getLocation().getBeanClass().isAssignableFrom(oneMethod.getLocation().getBeanClass())) continue;
                return new ConstraintDeclarationException("Only the root method of an overridden method in an inheritance hierarchy may be annotated with parameter constraints. The following method itself has no parameter constraints but it is not defined on a sub-type of " + constrainedMethod.getLocation().getBeanClass() + ": " + oneMethod);
            }
            return null;
        }

        private Set<ConstrainedMethod> getMethodsWithParameterConstraints(Iterable<ConstrainedMethod> methods) {
            HashSet<ConstrainedMethod> theValue = CollectionHelper.newHashSet();
            for (ConstrainedMethod oneMethod : methods) {
                if (!oneMethod.hasParameterConstraints()) continue;
                theValue.add(oneMethod);
            }
            return theValue;
        }
    }
}

