/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.SettableFuture;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.node.info.PluginInfo;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilteredQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermFilterBuilder;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.vertexium.Authorizations;
import org.vertexium.DateOnly;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.GraphConfiguration;
import org.vertexium.Property;
import org.vertexium.PropertyDefinition;
import org.vertexium.PropertyDescriptor;
import org.vertexium.SearchIndexSecurityGranularity;
import org.vertexium.TextIndexHint;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;
import org.vertexium.elasticsearch.ElasticSearchElementType;
import org.vertexium.elasticsearch.ElasticSearchSearchIndexConfiguration;
import org.vertexium.elasticsearch.ElasticSearchSingleDocumentSearchGraphQuery;
import org.vertexium.elasticsearch.ElasticSearchSingleDocumentSearchQueryBase;
import org.vertexium.elasticsearch.ElasticSearchSingleDocumentSearchVertexQuery;
import org.vertexium.elasticsearch.ElasticsearchPropertyNameInfo;
import org.vertexium.elasticsearch.IndexInfo;
import org.vertexium.elasticsearch.IndexSelectionStrategy;
import org.vertexium.elasticsearch.MetadataTablePropertyNameVisibilitiesStore;
import org.vertexium.elasticsearch.PropertyNameVisibilitiesStore;
import org.vertexium.elasticsearch.VertexiumNoMatchingPropertiesException;
import org.vertexium.id.NameSubstitutionStrategy;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.query.DefaultMultiVertexQuery;
import org.vertexium.query.GraphQuery;
import org.vertexium.query.MultiVertexQuery;
import org.vertexium.query.SimilarToGraphQuery;
import org.vertexium.query.VertexQuery;
import org.vertexium.search.SearchIndex;
import org.vertexium.search.SearchIndexWithVertexPropertyCountByValue;
import org.vertexium.type.GeoCircle;
import org.vertexium.type.GeoPoint;
import org.vertexium.type.GeoShape;
import org.vertexium.type.IpV4Address;
import org.vertexium.util.ConfigurationUtils;
import org.vertexium.util.IOUtils;
import org.vertexium.util.Preconditions;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class ElasticsearchSingleDocumentSearchIndex
implements SearchIndex,
SearchIndexWithVertexPropertyCountByValue {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(ElasticsearchSingleDocumentSearchIndex.class);
    protected static final VertexiumLogger MUTATION_LOGGER = VertexiumLoggerFactory.getMutationLogger(SearchIndex.class);
    public static final String ELEMENT_TYPE = "element";
    public static final String ELEMENT_TYPE_FIELD_NAME = "__elementType";
    public static final String VISIBILITY_FIELD_NAME = "__visibility";
    public static final String OUT_VERTEX_ID_FIELD_NAME = "__outVertexId";
    public static final String IN_VERTEX_ID_FIELD_NAME = "__inVertexId";
    public static final String EDGE_LABEL_FIELD_NAME = "__edgeLabel";
    public static final String EXACT_MATCH_PROPERTY_NAME_SUFFIX = "_e";
    public static final String GEO_PROPERTY_NAME_SUFFIX = "_g";
    public static final String SORT_PROPERTY_NAME_SUFFIX = "_s";
    public static final int MAX_BATCH_COUNT = 25000;
    public static final long MAX_BATCH_SIZE = 0xF00000L;
    public static final int EXACT_MATCH_IGNORE_ABOVE_LIMIT = 10000;
    private static final long IN_PROCESS_NODE_WAIT_TIME_MS = 600000L;
    private static final int MAX_RETRIES = 10;
    private final Client client;
    private final ElasticSearchSearchIndexConfiguration config;
    private Map<String, IndexInfo> indexInfos;
    private int indexInfosLastSize = 0;
    private String[] indexNamesAsArray;
    private IndexSelectionStrategy indexSelectionStrategy;
    private boolean allFieldEnabled;
    private Node inProcessNode;
    public static final Pattern AGGREGATION_NAME_PATTERN = Pattern.compile("(.*?)_([0-9a-f]+)");
    public static final String CONFIG_PROPERTY_NAME_VISIBILITIES_STORE = "propertyNameVisibilitiesStore";
    public static final Class<? extends PropertyNameVisibilitiesStore> DEFAULT_PROPERTY_NAME_VISIBILITIES_STORE = MetadataTablePropertyNameVisibilitiesStore.class;
    private final NameSubstitutionStrategy nameSubstitutionStrategy;
    private final PropertyNameVisibilitiesStore propertyNameVisibilitiesStore;
    private final ThreadLocal<Queue<FlushObject>> flushFutures = new ThreadLocal();
    private final Random random = new Random();
    private boolean serverPluginInstalled;

    public ElasticsearchSingleDocumentSearchIndex(Graph graph, GraphConfiguration config) {
        this.config = new ElasticSearchSearchIndexConfiguration(graph, config);
        this.nameSubstitutionStrategy = this.config.getNameSubstitutionStrategy();
        this.indexSelectionStrategy = this.config.getIndexSelectionStrategy();
        this.allFieldEnabled = this.config.isAllFieldEnabled(false);
        this.propertyNameVisibilitiesStore = this.createPropertyNameVisibilitiesStore(graph, config);
        this.client = this.createClient(this.config);
        this.serverPluginInstalled = this.checkPluginInstalled(this.client);
    }

    protected Client createClient(ElasticSearchSearchIndexConfiguration config) {
        if (config.isInProcessNode()) {
            return this.createInProcessNode(config);
        }
        return ElasticsearchSingleDocumentSearchIndex.createTransportClient(config);
    }

    private Client createInProcessNode(ElasticSearchSearchIndexConfiguration config) {
        try {
            Class.forName("groovy.lang.GroovyShell");
        }
        catch (ClassNotFoundException e) {
            throw new VertexiumException("Unable to load Groovy. This is required when running in-process ES.", (Throwable)e);
        }
        Settings settings = ElasticsearchSingleDocumentSearchIndex.tryReadSettingsFromFile(config);
        if (settings == null) {
            String dataPath = config.getInProcessNodeDataPath();
            Preconditions.checkNotNull((Object)dataPath, (Object)"inProcessNode.dataPath is required for in process Elasticsearch node");
            String logsPath = config.getInProcessNodeLogsPath();
            Preconditions.checkNotNull((Object)logsPath, (Object)"inProcessNode.logsPath is required for in process Elasticsearch node");
            String workPath = config.getInProcessNodeWorkPath();
            Preconditions.checkNotNull((Object)workPath, (Object)"inProcessNode.workPath is required for in process Elasticsearch node");
            int numberOfShards = config.getNumberOfShards();
            HashMap<String, String> mapSettings = new HashMap<String, String>();
            mapSettings.put("script.disable_dynamic", "false");
            mapSettings.put("index.number_of_shards", Integer.toString(numberOfShards));
            mapSettings.put("index.number_of_replicas", "0");
            mapSettings.put("path.data", dataPath);
            mapSettings.put("path.logs", logsPath);
            mapSettings.put("path.work", workPath);
            mapSettings.put("discovery.zen.ping.multicast.enabled", "false");
            mapSettings.putAll(config.getInProcessNodeAdditionalSettings());
            settings = ImmutableSettings.settingsBuilder().put(mapSettings).build();
        }
        NodeBuilder nodeBuilder = NodeBuilder.nodeBuilder();
        if (config.getClusterName() != null) {
            nodeBuilder = nodeBuilder.clusterName(config.getClusterName());
        }
        this.inProcessNode = nodeBuilder.settings(settings).node();
        this.inProcessNode.start();
        Client client = this.inProcessNode.client();
        long startTime = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() > startTime + 600000L) {
                throw new VertexiumException("Status failed to exit red status after waiting 600000ms. Giving up.");
            }
            ClusterHealthResponse health = (ClusterHealthResponse)client.admin().cluster().prepareHealth(new String[0]).get();
            if (health.getStatus() != ClusterHealthStatus.RED) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new VertexiumException("Could not sleep", (Throwable)e);
            }
            LOGGER.info("Status is %s, waiting...", new Object[]{health.getStatus()});
        }
        return client;
    }

    private static TransportClient createTransportClient(ElasticSearchSearchIndexConfiguration config) {
        Settings settings = ElasticsearchSingleDocumentSearchIndex.tryReadSettingsFromFile(config);
        if (settings == null) {
            ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder();
            if (config.getClusterName() != null) {
                settingsBuilder.put("cluster.name", config.getClusterName());
            }
            settings = settingsBuilder.build();
        }
        TransportClient transportClient = new TransportClient(settings);
        for (String esLocation : config.getEsLocations()) {
            int port;
            String hostname;
            String[] locationSocket = esLocation.split(":");
            if (locationSocket.length == 2) {
                hostname = locationSocket[0];
                port = Integer.parseInt(locationSocket[1]);
            } else if (locationSocket.length == 1) {
                hostname = locationSocket[0];
                port = config.getPort();
            } else {
                throw new VertexiumException("Invalid elastic search location: " + esLocation);
            }
            transportClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(hostname, port));
        }
        return transportClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Settings tryReadSettingsFromFile(ElasticSearchSearchIndexConfiguration config) {
        File esConfigFile = config.getEsConfigFile();
        if (esConfigFile == null) {
            return null;
        }
        if (!esConfigFile.exists()) {
            throw new VertexiumException(esConfigFile.getAbsolutePath() + " does not exist");
        }
        try (FileInputStream fileIn = new FileInputStream(esConfigFile);){
            Settings settings = ImmutableSettings.builder().loadFromStream(esConfigFile.getAbsolutePath(), (InputStream)fileIn).build();
            return settings;
        }
        catch (IOException e) {
            throw new VertexiumException("Could not read ES config file: " + esConfigFile.getAbsolutePath(), (Throwable)e);
        }
    }

    private boolean checkPluginInstalled(Client client) {
        NodesInfoResponse nodesInfoResponse = (NodesInfoResponse)client.admin().cluster().prepareNodesInfo(new String[0]).setPlugins(true).get();
        for (NodeInfo nodeInfo : (NodeInfo[])nodesInfoResponse.getNodes()) {
            for (PluginInfo pluginInfo : nodeInfo.getPlugins().getInfos()) {
                if (!"Vertexium".equals(pluginInfo.getName())) continue;
                return true;
            }
        }
        LOGGER.warn("Running without the server side Vertexium plugin will be deprecated in the future.", new Object[0]);
        return false;
    }

    protected final boolean isAllFieldEnabled() {
        return this.allFieldEnabled;
    }

    private Map<String, IndexStats> getExistingIndexNames() {
        return ((IndicesStatsResponse)this.client.admin().indices().prepareStats(new String[0]).execute().actionGet()).getIndices();
    }

    void clearIndexInfoCache() {
        this.indexInfos = null;
    }

    private Map<String, IndexInfo> getIndexInfos(Graph graph) {
        if (this.indexInfos == null) {
            this.indexInfos = new HashMap<String, IndexInfo>();
            this.loadIndexInfos(graph, this.indexInfos);
        }
        return this.indexInfos;
    }

    private void loadIndexInfos(Graph graph, Map<String, IndexInfo> indexInfos) {
        Map<String, IndexStats> indices = this.getExistingIndexNames();
        for (String indexName : indices.keySet()) {
            if (!this.indexSelectionStrategy.isIncluded(this, indexName)) {
                LOGGER.debug("skipping index %s, not in indicesToQuery", new Object[]{indexName});
                continue;
            }
            IndexInfo indexInfo = indexInfos.get(indexName);
            if (indexInfo != null) continue;
            LOGGER.debug("loading index info for %s", new Object[]{indexName});
            indexInfo = this.createIndexInfo(indexName);
            this.addPropertyNameVisibility(graph, indexInfo, ELEMENT_TYPE_FIELD_NAME, null);
            this.addPropertyNameVisibility(graph, indexInfo, VISIBILITY_FIELD_NAME, null);
            this.addPropertyNameVisibility(graph, indexInfo, OUT_VERTEX_ID_FIELD_NAME, null);
            this.addPropertyNameVisibility(graph, indexInfo, IN_VERTEX_ID_FIELD_NAME, null);
            this.addPropertyNameVisibility(graph, indexInfo, EDGE_LABEL_FIELD_NAME, null);
            this.loadExistingMappingIntoIndexInfo(graph, indexInfo, indexName);
            indexInfos.put(indexName, indexInfo);
            this.updateMetadata(graph, indexInfo);
        }
    }

    private void loadExistingMappingIntoIndexInfo(Graph graph, IndexInfo indexInfo, String indexName) {
        try {
            GetMappingsResponse mapping = (GetMappingsResponse)this.client.admin().indices().prepareGetMappings(new String[]{indexName}).get();
            for (ObjectCursor mappingIndexName : mapping.getMappings().keys()) {
                ImmutableOpenMap typeMappings = (ImmutableOpenMap)mapping.getMappings().get(mappingIndexName.value);
                for (ObjectCursor typeName : typeMappings.keys()) {
                    MappingMetaData typeMapping = (MappingMetaData)typeMappings.get(typeName.value);
                    Map<String, Map<String, String>> properties = this.getPropertiesFromTypeMapping(typeMapping);
                    if (properties == null) continue;
                    for (Map.Entry<String, Map<String, String>> propertyEntry : properties.entrySet()) {
                        String rawPropertyName = propertyEntry.getKey();
                        this.loadExistingPropertyMappingIntoIndexInfo(graph, indexInfo, rawPropertyName);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new VertexiumException("Could not load type mappings", (Throwable)ex);
        }
    }

    private Map<String, Map<String, String>> getPropertiesFromTypeMapping(MappingMetaData typeMapping) throws IOException {
        return (Map)typeMapping.getSourceAsMap().get("properties");
    }

    private void loadExistingPropertyMappingIntoIndexInfo(Graph graph, IndexInfo indexInfo, String rawPropertyName) {
        ElasticsearchPropertyNameInfo p = ElasticsearchPropertyNameInfo.parse(graph, this.propertyNameVisibilitiesStore, rawPropertyName);
        if (p == null) {
            return;
        }
        this.addPropertyNameVisibility(graph, indexInfo, p.getPropertyName(), p.getPropertyVisibility());
    }

    private PropertyNameVisibilitiesStore createPropertyNameVisibilitiesStore(Graph graph, GraphConfiguration config) {
        String className = config.getString("search.propertyNameVisibilitiesStore", DEFAULT_PROPERTY_NAME_VISIBILITIES_STORE.getName());
        return (PropertyNameVisibilitiesStore)ConfigurationUtils.createProvider((String)className, (Graph)graph, (GraphConfiguration)config);
    }

    public void addElement(Graph graph, Element element, Authorizations authorizations) {
        this.addElementWithScript(graph, element, authorizations);
    }

    private void addElementWithScript(Graph graph, Element element, Authorizations authorizations) {
        if (MUTATION_LOGGER.isTraceEnabled()) {
            MUTATION_LOGGER.trace("addElement: %s", new Object[]{element.getId()});
        }
        if (!this.getConfig().isIndexEdges() && element instanceof Edge) {
            return;
        }
        IndexInfo indexInfo = this.addPropertiesToIndex(graph, element, element.getProperties());
        try {
            XContentBuilder jsonBuilder = this.buildJsonContentFromElement(graph, element, authorizations);
            XContentBuilder source = jsonBuilder.endObject();
            if (MUTATION_LOGGER.isTraceEnabled()) {
                MUTATION_LOGGER.trace("addElement json: %s: %s", new Object[]{element.getId(), source.string()});
            }
            if (this.flushObjectQueueContainsElementId(element.getId())) {
                this.flushFlushObjectQueue();
            }
            UpdateRequestBuilder updateRequestBuilder = this.getClient().prepareUpdate(indexInfo.getIndexName(), ELEMENT_TYPE, element.getId()).setDocAsUpsert(true).setDoc(source).setRetryOnConflict(10);
            this.addActionRequestBuilderForFlush(element.getId(), updateRequestBuilder);
            if (this.getConfig().isAutoFlush()) {
                this.flush(graph);
            }
        }
        catch (Exception e) {
            throw new VertexiumException("Could not add element", (Throwable)e);
        }
        this.getConfig().getScoringStrategy().addElement(this, graph, element, authorizations);
    }

    private boolean flushObjectQueueContainsElementId(String elementId) {
        return this.getFlushObjectQueue().stream().anyMatch(flushObject -> flushObject.elementId.equals(elementId));
    }

    private void addActionRequestBuilderForFlush(String elementId, UpdateRequestBuilder updateRequestBuilder) {
        ListenableActionFuture future;
        try {
            future = updateRequestBuilder.execute();
        }
        catch (Exception ex) {
            LOGGER.debug("Could not execute update: %s", new Object[]{ex.getMessage()});
            future = SettableFuture.create();
            ((SettableFuture)future).setException((Throwable)ex);
        }
        this.getFlushObjectQueue().add(new FlushObject(elementId, updateRequestBuilder, (Future)future));
    }

    private Queue<FlushObject> getFlushObjectQueue() {
        Queue<FlushObject> queue = this.flushFutures.get();
        if (queue == null) {
            queue = new LinkedList<FlushObject>();
            this.flushFutures.set(queue);
        }
        return queue;
    }

    public void alterElementVisibility(Graph graph, Element element, Visibility oldVisibility, Visibility newVisibility, Authorizations authorizations) {
        String oldFieldName = this.deflatePropertyName(graph, ELEMENT_TYPE_FIELD_NAME, oldVisibility);
        this.removeFieldsFromDocument(element, oldFieldName);
        this.addElement(graph, element, authorizations);
    }

    private XContentBuilder buildJsonContentFromElement(Graph graph, Element element, Authorizations authorizations) throws IOException {
        XContentBuilder jsonBuilder = XContentFactory.jsonBuilder().startObject();
        String elementTypeVisibilityPropertyName = this.addElementTypeVisibilityPropertyToIndex(graph, element);
        jsonBuilder.field(ELEMENT_TYPE_FIELD_NAME, this.getElementTypeValueFromElement(element));
        if (element instanceof Vertex) {
            jsonBuilder.field(elementTypeVisibilityPropertyName, ElasticSearchElementType.VERTEX.getKey());
            this.getConfig().getScoringStrategy().addFieldsToVertexDocument(this, jsonBuilder, (Vertex)element, null, authorizations);
        } else if (element instanceof Edge) {
            Edge edge = (Edge)element;
            jsonBuilder.field(elementTypeVisibilityPropertyName, ElasticSearchElementType.VERTEX.getKey());
            this.getConfig().getScoringStrategy().addFieldsToEdgeDocument(this, jsonBuilder, edge, null, authorizations);
            jsonBuilder.field(IN_VERTEX_ID_FIELD_NAME, edge.getVertexId(Direction.IN));
            jsonBuilder.field(OUT_VERTEX_ID_FIELD_NAME, edge.getVertexId(Direction.OUT));
            jsonBuilder.field(EDGE_LABEL_FIELD_NAME, edge.getLabel());
        } else {
            throw new VertexiumException("Unexpected element type " + element.getClass().getName());
        }
        Map<String, Object> properties = this.getProperties(graph, element);
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            if (property.getValue() instanceof List) {
                List list = (List)property.getValue();
                jsonBuilder.field(property.getKey(), list.toArray(new Object[list.size()]));
                continue;
            }
            jsonBuilder.field(property.getKey(), this.convertValueForIndexing(property.getValue()));
        }
        return jsonBuilder;
    }

    private String getElementTypeValueFromElement(Element element) {
        if (element instanceof Vertex) {
            return ElasticSearchElementType.VERTEX.getKey();
        }
        if (element instanceof Edge) {
            return ElasticSearchElementType.EDGE.getKey();
        }
        throw new VertexiumException("Unhandled element type: " + element.getClass().getName());
    }

    protected Object convertValueForIndexing(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).doubleValue();
        }
        if (obj instanceof BigInteger) {
            return ((BigInteger)obj).intValue();
        }
        return obj;
    }

    private String addElementTypeVisibilityPropertyToIndex(Graph graph, Element element) throws IOException {
        String elementTypeVisibilityPropertyName = this.deflatePropertyName(graph, ELEMENT_TYPE_FIELD_NAME, element.getVisibility());
        String indexName = this.getIndexName(element);
        IndexInfo indexInfo = this.ensureIndexCreatedAndInitialized(graph, indexName);
        this.addPropertyToIndex(graph, indexInfo, elementTypeVisibilityPropertyName, element.getVisibility(), String.class, false);
        return elementTypeVisibilityPropertyName;
    }

    private Map<String, Object> getProperties(Graph graph, Element element) throws IOException {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        ArrayList<Property> streamingProperties = new ArrayList<Property>();
        for (Property property : element.getProperties()) {
            if (property.getValue() != null && this.shouldIgnoreType(property.getValue().getClass())) continue;
            if (property.getValue() instanceof StreamingPropertyValue) {
                StreamingPropertyValue spv = (StreamingPropertyValue)property.getValue();
                if (!this.isStreamingPropertyValueIndexable(graph, property.getName(), spv)) continue;
                streamingProperties.add(property);
                continue;
            }
            this.addPropertyToMap(graph, property, propertiesMap);
        }
        this.addStreamingPropertyValuesToMap(graph, streamingProperties, propertiesMap);
        return propertiesMap;
    }

    private void addPropertyToMap(Graph graph, Property property, Map<String, Object> propertiesMap) throws IOException {
        Object propertyValue = property.getValue();
        this.addPropertyToMap(graph, property, propertyValue, propertiesMap);
    }

    private void addPropertyToMap(Graph graph, Property property, Object propertyValue, Map<String, Object> propertiesMap) {
        String propertyName = this.deflatePropertyName(graph, property);
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(graph, propertyName);
        if (propertyValue instanceof GeoPoint) {
            this.convertGeoPoint(graph, propertiesMap, property, (GeoPoint)propertyValue);
            return;
        }
        if (propertyValue instanceof GeoCircle) {
            this.convertGeoCircle(graph, propertiesMap, property, (GeoCircle)propertyValue);
            return;
        }
        if (propertyValue instanceof StreamingPropertyString) {
            propertyValue = ((StreamingPropertyString)propertyValue).getPropertyValue();
        } else if (propertyValue instanceof String) {
            if (propertyDefinition == null || propertyDefinition.getTextIndexHints().contains(TextIndexHint.EXACT_MATCH)) {
                this.addPropertyValueToPropertiesMap(propertiesMap, propertyName + EXACT_MATCH_PROPERTY_NAME_SUFFIX, propertyValue);
            }
            if (propertyDefinition == null || propertyDefinition.getTextIndexHints().contains(TextIndexHint.FULL_TEXT)) {
                this.addPropertyValueToPropertiesMap(propertiesMap, propertyName, propertyValue);
            }
            if (propertyDefinition != null && propertyDefinition.isSortable()) {
                String s = ((String)propertyValue).substring(0, Math.min(100, ((String)propertyValue).length()));
                this.addPropertyValueToPropertiesMap(propertiesMap, propertyDefinition.getPropertyName() + SORT_PROPERTY_NAME_SUFFIX, s);
            }
            return;
        }
        if (propertyValue instanceof DateOnly) {
            propertyValue = ((DateOnly)propertyValue).getDate();
        }
        this.addPropertyValueToPropertiesMap(propertiesMap, propertyName, propertyValue);
        if (propertyDefinition != null && propertyDefinition.isSortable()) {
            this.addPropertyValueToPropertiesMap(propertiesMap, propertyDefinition.getPropertyName() + SORT_PROPERTY_NAME_SUFFIX, propertyValue);
        }
    }

    private boolean isStreamingPropertyValueIndexable(Graph graph, String propertyName, StreamingPropertyValue streamingPropertyValue) {
        if (!streamingPropertyValue.isSearchIndex()) {
            return false;
        }
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(graph, propertyName);
        if (propertyDefinition != null && !propertyDefinition.getTextIndexHints().contains(TextIndexHint.FULL_TEXT)) {
            return false;
        }
        Class valueType = streamingPropertyValue.getValueType();
        if (valueType == String.class) {
            return true;
        }
        throw new VertexiumException("Unhandled StreamingPropertyValue type: " + valueType.getName());
    }

    private void addStreamingPropertyValuesToMap(Graph graph, List<Property> properties, Map<String, Object> propertiesMap) {
        List streamingPropertyValues = properties.stream().map(property -> {
            if (!(property.getValue() instanceof StreamingPropertyValue)) {
                throw new VertexiumException("property with a value that is not a StreamingPropertyValue passed to addStreamingPropertyValuesToMap");
            }
            return (StreamingPropertyValue)property.getValue();
        }).collect(Collectors.toList());
        List inputStreams = graph.getStreamingPropertyValueInputStreams(streamingPropertyValues);
        for (int i = 0; i < properties.size(); ++i) {
            try {
                String propertyValue = IOUtils.toString((InputStream)((InputStream)inputStreams.get(i)));
                this.addPropertyToMap(graph, properties.get(i), new StreamingPropertyString(propertyValue), propertiesMap);
                continue;
            }
            catch (IOException ex) {
                throw new VertexiumException("could not convert streaming property to string", (Throwable)ex);
            }
        }
    }

    public boolean isServerPluginInstalled() {
        return this.serverPluginInstalled;
    }

    protected String deflatePropertyName(Graph graph, Property property) {
        String propertyName = property.getName();
        Visibility propertyVisibility = property.getVisibility();
        return this.deflatePropertyName(graph, propertyName, propertyVisibility);
    }

    protected String deflatePropertyName(Graph graph, String propertyName, Visibility propertyVisibility) {
        String visibilityHash = this.getVisibilityHash(graph, propertyName, propertyVisibility);
        return this.nameSubstitutionStrategy.deflate(propertyName) + "_" + visibilityHash;
    }

    protected String inflatePropertyName(String string) {
        Matcher m = ElasticsearchPropertyNameInfo.PROPERTY_NAME_PATTERN.matcher(string);
        if (m.matches()) {
            string = m.group(1);
        }
        return this.nameSubstitutionStrategy.inflate(string);
    }

    private String inflatePropertyNameWithTypeSuffix(String string) {
        Matcher m = ElasticsearchPropertyNameInfo.PROPERTY_NAME_PATTERN.matcher(string);
        if (m.matches()) {
            string = m.groupCount() >= 5 && m.group(5) != null ? m.group(1) + "_" + m.group(5) : m.group(1);
        }
        return this.nameSubstitutionStrategy.inflate(string);
    }

    public String getPropertyVisibilityHashFromDeflatedPropertyName(String deflatedPropertyName) {
        Matcher m = ElasticsearchPropertyNameInfo.PROPERTY_NAME_PATTERN.matcher(deflatedPropertyName);
        if (m.matches()) {
            return m.group(3);
        }
        throw new VertexiumException("Could not match property name: " + deflatedPropertyName);
    }

    public String getAggregationName(String name) {
        Matcher m = AGGREGATION_NAME_PATTERN.matcher(name);
        if (m.matches()) {
            return m.group(1);
        }
        throw new VertexiumException("Could not get aggregation name from: " + name);
    }

    public String[] getAllMatchingPropertyNames(Graph graph, String propertyName, Authorizations authorizations) {
        Collection<String> hashes = this.propertyNameVisibilitiesStore.getHashes(graph, propertyName, authorizations);
        if (hashes.size() == 0) {
            return new String[0];
        }
        String[] results = new String[hashes.size()];
        String deflatedPropertyName = this.nameSubstitutionStrategy.deflate(propertyName);
        int i = 0;
        for (String hash : hashes) {
            results[i++] = deflatedPropertyName + "_" + hash;
        }
        return results;
    }

    public Collection<String> getQueryableElementTypeVisibilityPropertyNames(Graph graph, Authorizations authorizations) {
        HashSet<String> propertyNames = new HashSet<String>();
        for (String hash : this.propertyNameVisibilitiesStore.getHashes(graph, ELEMENT_TYPE_FIELD_NAME, authorizations)) {
            propertyNames.add("__elementType_" + hash);
        }
        if (propertyNames.size() == 0) {
            throw new VertexiumNoMatchingPropertiesException("No queryable __elementType for authorizations " + authorizations);
        }
        return propertyNames;
    }

    public Collection<String> getQueryablePropertyNames(Graph graph, Authorizations authorizations) {
        HashSet<String> propertyNames = new HashSet<String>();
        for (PropertyDefinition propertyDefinition : graph.getPropertyDefinitions()) {
            List<String> queryableTypeSuffixes = ElasticsearchSingleDocumentSearchIndex.getQueryableTypeSuffixes(propertyDefinition);
            if (queryableTypeSuffixes.size() == 0) continue;
            String inflatedPropertyName = this.inflatePropertyName(propertyDefinition.getPropertyName());
            String deflatedPropertyName = this.nameSubstitutionStrategy.deflate(inflatedPropertyName);
            if (ElasticsearchSingleDocumentSearchIndex.isReservedFieldName(inflatedPropertyName)) continue;
            for (String hash : this.propertyNameVisibilitiesStore.getHashes(graph, inflatedPropertyName, authorizations)) {
                for (String typeSuffix : queryableTypeSuffixes) {
                    propertyNames.add(deflatedPropertyName + "_" + hash + typeSuffix);
                }
            }
        }
        return propertyNames;
    }

    private static List<String> getQueryableTypeSuffixes(PropertyDefinition propertyDefinition) {
        ArrayList<String> typeSuffixes = new ArrayList<String>();
        if (propertyDefinition.getDataType() == String.class) {
            if (propertyDefinition.getTextIndexHints().contains(TextIndexHint.EXACT_MATCH)) {
                typeSuffixes.add(EXACT_MATCH_PROPERTY_NAME_SUFFIX);
            }
            if (propertyDefinition.getTextIndexHints().contains(TextIndexHint.FULL_TEXT)) {
                typeSuffixes.add("");
            }
        } else if (propertyDefinition.getDataType() == GeoPoint.class || propertyDefinition.getDataType() == GeoCircle.class) {
            typeSuffixes.add("");
        }
        return typeSuffixes;
    }

    protected static boolean isReservedFieldName(String fieldName) {
        return fieldName.startsWith("__");
    }

    private String getVisibilityHash(Graph graph, String propertyName, Visibility visibility) {
        return this.propertyNameVisibilitiesStore.getHash(graph, propertyName, visibility);
    }

    public void deleteElement(Graph graph, Element element, Authorizations authorizations) {
        String indexName = this.getIndexName(element);
        String id = element.getId();
        if (MUTATION_LOGGER.isTraceEnabled()) {
            LOGGER.trace("deleting document %s", new Object[]{id});
        }
        this.getClient().delete((DeleteRequest)this.getClient().prepareDelete(indexName, ELEMENT_TYPE, id).request()).actionGet();
    }

    public SearchIndexSecurityGranularity getSearchIndexSecurityGranularity() {
        return SearchIndexSecurityGranularity.PROPERTY;
    }

    public GraphQuery queryGraph(Graph graph, String queryString, Authorizations authorizations) {
        return new ElasticSearchSingleDocumentSearchGraphQuery(this.getClient(), graph, queryString, this.getConfig().getScoringStrategy(), this.getIndexSelectionStrategy(), this.getConfig().getQueryPageSize(), authorizations);
    }

    public VertexQuery queryVertex(Graph graph, Vertex vertex, String queryString, Authorizations authorizations) {
        return new ElasticSearchSingleDocumentSearchVertexQuery(this.getClient(), graph, vertex, queryString, this.getConfig().getScoringStrategy(), this.getIndexSelectionStrategy(), this.getConfig().getQueryPageSize(), authorizations);
    }

    public SimilarToGraphQuery querySimilarTo(Graph graph, String[] similarToFields, String similarToText, Authorizations authorizations) {
        return new ElasticSearchSingleDocumentSearchGraphQuery(this.getClient(), graph, similarToFields, similarToText, this.getConfig().getScoringStrategy(), this.getIndexSelectionStrategy(), this.getConfig().getQueryPageSize(), authorizations);
    }

    public boolean isFieldLevelSecuritySupported() {
        return true;
    }

    protected boolean addPropertyDefinitionToIndex(Graph graph, IndexInfo indexInfo, String propertyName, Visibility propertyVisibility, PropertyDefinition propertyDefinition) throws IOException {
        if (propertyDefinition.getDataType() == String.class) {
            if (propertyDefinition.getTextIndexHints().contains(TextIndexHint.EXACT_MATCH)) {
                this.addPropertyToIndex(graph, indexInfo, propertyName + EXACT_MATCH_PROPERTY_NAME_SUFFIX, propertyVisibility, String.class, false, propertyDefinition.getBoost());
            }
            if (propertyDefinition.getTextIndexHints().contains(TextIndexHint.FULL_TEXT)) {
                this.addPropertyToIndex(graph, indexInfo, propertyName, propertyVisibility, String.class, true, propertyDefinition.getBoost());
            }
            if (propertyDefinition.isSortable()) {
                String sortPropertyName = this.inflatePropertyName(propertyName) + SORT_PROPERTY_NAME_SUFFIX;
                this.addPropertyToIndex(graph, indexInfo, sortPropertyName, null, String.class, false, null);
            }
            return true;
        }
        if (propertyDefinition.getDataType() == GeoPoint.class || propertyDefinition.getDataType() == GeoCircle.class) {
            this.addPropertyToIndex(graph, indexInfo, propertyName + GEO_PROPERTY_NAME_SUFFIX, propertyVisibility, propertyDefinition.getDataType(), true, propertyDefinition.getBoost());
            this.addPropertyToIndex(graph, indexInfo, propertyName, propertyVisibility, String.class, true, propertyDefinition.getBoost());
            return true;
        }
        this.addPropertyToIndex(graph, indexInfo, propertyName, propertyVisibility, propertyDefinition.getDataType(), true, propertyDefinition.getBoost());
        return true;
    }

    protected PropertyDefinition getPropertyDefinition(Graph graph, String propertyName) {
        propertyName = this.inflatePropertyNameWithTypeSuffix(propertyName);
        return graph.getPropertyDefinition(propertyName);
    }

    public void addPropertyToIndex(Graph graph, IndexInfo indexInfo, Property property) throws IOException {
        String deflatedPropertyName;
        Object propertyValue = property.getValue();
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(graph, property.getName());
        if (propertyDefinition != null) {
            deflatedPropertyName = this.deflatePropertyName(graph, property);
            this.addPropertyDefinitionToIndex(graph, indexInfo, deflatedPropertyName, property.getVisibility(), propertyDefinition);
        } else {
            this.addPropertyToIndexInner(graph, indexInfo, property);
        }
        propertyDefinition = this.getPropertyDefinition(graph, property.getName() + EXACT_MATCH_PROPERTY_NAME_SUFFIX);
        if (propertyDefinition != null) {
            deflatedPropertyName = this.deflatePropertyName(graph, property);
            this.addPropertyDefinitionToIndex(graph, indexInfo, deflatedPropertyName, property.getVisibility(), propertyDefinition);
        }
        if (propertyValue instanceof GeoShape && (propertyDefinition = this.getPropertyDefinition(graph, property.getName() + GEO_PROPERTY_NAME_SUFFIX)) != null) {
            deflatedPropertyName = this.deflatePropertyName(graph, property);
            this.addPropertyDefinitionToIndex(graph, indexInfo, deflatedPropertyName, property.getVisibility(), propertyDefinition);
        }
    }

    public void addPropertyToIndexInner(Graph graph, IndexInfo indexInfo, Property property) throws IOException {
        String deflatedPropertyName = this.deflatePropertyName(graph, property);
        if (indexInfo.isPropertyDefined(deflatedPropertyName, property.getVisibility())) {
            return;
        }
        Object propertyValue = property.getValue();
        if (propertyValue instanceof StreamingPropertyValue) {
            StreamingPropertyValue streamingPropertyValue = (StreamingPropertyValue)propertyValue;
            if (!streamingPropertyValue.isSearchIndex()) {
                return;
            }
            Class dataType = streamingPropertyValue.getValueType();
            this.addPropertyToIndex(graph, indexInfo, deflatedPropertyName, property.getVisibility(), dataType, true);
        } else if (propertyValue instanceof String) {
            Class<String> dataType = String.class;
            this.addPropertyToIndex(graph, indexInfo, deflatedPropertyName + EXACT_MATCH_PROPERTY_NAME_SUFFIX, property.getVisibility(), dataType, false);
            this.addPropertyToIndex(graph, indexInfo, deflatedPropertyName, property.getVisibility(), dataType, true);
        } else if (propertyValue instanceof GeoPoint) {
            this.addPropertyToIndex(graph, indexInfo, deflatedPropertyName + GEO_PROPERTY_NAME_SUFFIX, property.getVisibility(), GeoPoint.class, true);
            this.addPropertyToIndex(graph, indexInfo, deflatedPropertyName, property.getVisibility(), String.class, true);
        } else if (propertyValue instanceof GeoCircle) {
            this.addPropertyToIndex(graph, indexInfo, deflatedPropertyName + GEO_PROPERTY_NAME_SUFFIX, property.getVisibility(), GeoCircle.class, true);
            this.addPropertyToIndex(graph, indexInfo, deflatedPropertyName, property.getVisibility(), String.class, true);
        } else {
            Preconditions.checkNotNull((Object)propertyValue, (Object)("property value cannot be null for property: " + deflatedPropertyName));
            Class<?> dataType = propertyValue.getClass();
            this.addPropertyToIndex(graph, indexInfo, deflatedPropertyName, property.getVisibility(), dataType, true);
        }
    }

    protected void addPropertyToIndex(Graph graph, IndexInfo indexInfo, String propertyName, Visibility propertyVisibility, Class dataType, boolean analyzed, Double boost) throws IOException {
        if (indexInfo.isPropertyDefined(propertyName, propertyVisibility)) {
            return;
        }
        if (this.shouldIgnoreType(dataType)) {
            return;
        }
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject(ELEMENT_TYPE).startObject("properties").startObject(propertyName);
        this.addTypeToMapping(mapping, propertyName, dataType, analyzed, boost);
        mapping.endObject().endObject().endObject().endObject();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("addPropertyToIndex: %s: %s", new Object[]{dataType.getName(), mapping.string()});
        }
        this.getClient().admin().indices().preparePutMapping(new String[]{indexInfo.getIndexName()}).setIgnoreConflicts(false).setType(ELEMENT_TYPE).setSource(mapping).execute().actionGet();
        this.addPropertyNameVisibility(graph, indexInfo, propertyName, propertyVisibility);
        this.updateMetadata(graph, indexInfo);
    }

    private void updateMetadata(Graph graph, IndexInfo indexInfo) {
        try {
            XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject(ELEMENT_TYPE);
            GetMappingsResponse existingMapping = (GetMappingsResponse)this.getClient().admin().indices().prepareGetMappings(new String[]{indexInfo.getIndexName()}).execute().actionGet();
            Map existingElementData = ((MappingMetaData)((ImmutableOpenMap)existingMapping.mappings().get((Object)indexInfo.getIndexName())).get((Object)ELEMENT_TYPE)).getSourceAsMap();
            mapping = mapping.startObject("_meta").startObject("vertexium");
            Map properties = (Map)existingElementData.get("properties");
            for (String propertyName : properties.keySet()) {
                ElasticsearchPropertyNameInfo p = ElasticsearchPropertyNameInfo.parse(graph, this.propertyNameVisibilitiesStore, propertyName);
                if (p == null || p.getPropertyVisibility() == null) continue;
                mapping.field(propertyName, (Object)p.getPropertyVisibility());
            }
            mapping.endObject().endObject().endObject().endObject();
            this.getClient().admin().indices().preparePutMapping(new String[]{indexInfo.getIndexName()}).setIgnoreConflicts(false).setType(ELEMENT_TYPE).setSource(mapping).execute().actionGet();
        }
        catch (IOException ex) {
            throw new VertexiumException("Could not update mapping", (Throwable)ex);
        }
    }

    protected void addPropertyNameVisibility(Graph graph, IndexInfo indexInfo, String propertyName, Visibility propertyVisibility) {
        String inflatedPropertyName = this.inflatePropertyName(propertyName);
        if (propertyVisibility != null) {
            this.propertyNameVisibilitiesStore.getHash(graph, inflatedPropertyName, propertyVisibility);
        }
        indexInfo.addPropertyNameVisibility(inflatedPropertyName, propertyVisibility);
        indexInfo.addPropertyNameVisibility(propertyName, propertyVisibility);
    }

    public void addElementToBulkRequest(Graph graph, BulkRequest bulkRequest, IndexInfo indexInfo, Element element, Authorizations authorizations) {
        try {
            XContentBuilder json = this.buildJsonContentFromElement(graph, element, authorizations);
            UpdateRequest indexRequest = new UpdateRequest(indexInfo.getIndexName(), ELEMENT_TYPE, element.getId()).doc(json);
            indexRequest.retryOnConflict(10);
            indexRequest.docAsUpsert(true);
            bulkRequest.add(indexRequest);
        }
        catch (IOException ex) {
            throw new VertexiumException("Could not add element to bulk request", (Throwable)ex);
        }
    }

    public Map<Object, Long> getVertexPropertyCountByValue(Graph graph, String propertyName, Authorizations authorizations) {
        TermFilterBuilder elementTypeFilterBuilder = new TermFilterBuilder(ELEMENT_TYPE_FIELD_NAME, ElasticSearchElementType.VERTEX.getKey());
        FilteredQueryBuilder queryBuilder = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)elementTypeFilterBuilder);
        SearchRequestBuilder q = this.getClient().prepareSearch(this.getIndexNamesAsArray(graph)).setQuery((QueryBuilder)queryBuilder).setSearchType(SearchType.COUNT);
        for (String p : this.getAllMatchingPropertyNames(graph, propertyName, authorizations)) {
            String countAggName = "count-" + p;
            PropertyDefinition propertyDefinition = this.getPropertyDefinition(graph, p);
            if (propertyDefinition != null && propertyDefinition.getTextIndexHints().contains(TextIndexHint.EXACT_MATCH)) {
                p = p + EXACT_MATCH_PROPERTY_NAME_SUFFIX;
            }
            TermsBuilder countAgg = ((TermsBuilder)new TermsBuilder(countAggName).field(p)).size(500000);
            q = q.addAggregation((AbstractAggregationBuilder)countAgg);
        }
        if (ElasticSearchSingleDocumentSearchQueryBase.QUERY_LOGGER.isTraceEnabled()) {
            ElasticSearchSingleDocumentSearchQueryBase.QUERY_LOGGER.trace("query: %s", new Object[]{q});
        }
        SearchResponse response = (SearchResponse)this.getClient().search(q.request()).actionGet();
        HashMap<Object, Long> results = new HashMap<Object, Long>();
        for (Aggregation agg : response.getAggregations().asList()) {
            Terms propertyCountResults = (Terms)agg;
            for (Terms.Bucket propertyCountResult : propertyCountResults.getBuckets()) {
                String mapKey = propertyCountResult.getKey().toLowerCase();
                Long previousValue = (Long)results.get(mapKey);
                if (previousValue == null) {
                    previousValue = 0L;
                }
                results.put(mapKey, previousValue + propertyCountResult.getDocCount());
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexInfo ensureIndexCreatedAndInitialized(Graph graph, String indexName) {
        Map<String, IndexInfo> indexInfos = this.getIndexInfos(graph);
        IndexInfo indexInfo = indexInfos.get(indexName);
        if (indexInfo != null && indexInfo.isElementTypeDefined()) {
            return indexInfo;
        }
        ElasticsearchSingleDocumentSearchIndex elasticsearchSingleDocumentSearchIndex = this;
        synchronized (elasticsearchSingleDocumentSearchIndex) {
            if (indexInfo == null) {
                if (!((IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{indexName}).execute().actionGet()).isExists()) {
                    try {
                        this.createIndex(indexName);
                    }
                    catch (IOException e) {
                        throw new VertexiumException("Could not create index: " + indexName, (Throwable)e);
                    }
                }
                indexInfo = this.createIndexInfo(indexName);
                indexInfos.put(indexName, indexInfo);
            }
            this.ensureMappingsCreated(indexInfo);
            return indexInfo;
        }
    }

    protected IndexInfo createIndexInfo(String indexName) {
        return new IndexInfo(indexName);
    }

    protected void ensureMappingsCreated(IndexInfo indexInfo) {
        if (!indexInfo.isElementTypeDefined()) {
            try {
                XContentBuilder mappingBuilder = XContentFactory.jsonBuilder().startObject().startObject("_source").field("enabled", true).endObject().startObject("_all").field("enabled", this.isAllFieldEnabled()).endObject().startObject("properties");
                this.createIndexAddFieldsToElementType(mappingBuilder);
                XContentBuilder mapping = mappingBuilder.endObject().endObject();
                this.client.admin().indices().preparePutMapping(new String[]{indexInfo.getIndexName()}).setType(ELEMENT_TYPE).setSource(mapping).execute().actionGet();
                indexInfo.setElementTypeDefined(true);
            }
            catch (Throwable e) {
                throw new VertexiumException("Could not add mappings to index: " + indexInfo.getIndexName(), e);
            }
        }
    }

    protected void createIndexAddFieldsToElementType(XContentBuilder builder) throws IOException {
        builder.startObject(ELEMENT_TYPE_FIELD_NAME).field("type", "string").field("store", "true").endObject().startObject(VISIBILITY_FIELD_NAME).field("type", "string").field("analyzer", "keyword").field("index", "not_analyzed").field("store", "true").endObject().startObject(IN_VERTEX_ID_FIELD_NAME).field("type", "string").field("analyzer", "keyword").field("index", "not_analyzed").field("store", "true").endObject().startObject(OUT_VERTEX_ID_FIELD_NAME).field("type", "string").field("analyzer", "keyword").field("index", "not_analyzed").field("store", "true").endObject().startObject(EDGE_LABEL_FIELD_NAME).field("type", "string").field("analyzer", "keyword").field("index", "not_analyzed").field("store", "true").endObject();
        this.getConfig().getScoringStrategy().addFieldsToElementType(builder);
    }

    public void deleteProperty(Graph graph, Element element, PropertyDescriptor property, Authorizations authorizations) {
        String fieldName = this.deflatePropertyName(graph, property.getName(), property.getVisibility());
        this.removeFieldsFromDocument(element, fieldName);
        this.removeFieldsFromDocument(element, fieldName + EXACT_MATCH_PROPERTY_NAME_SUFFIX);
    }

    public void deleteProperties(Graph graph, Element element, Collection<PropertyDescriptor> propertyList, Authorizations authorizations) {
        ArrayList<String> fields = new ArrayList<String>();
        for (PropertyDescriptor p : propertyList) {
            String fieldName = this.deflatePropertyName(graph, p.getName(), p.getVisibility());
            fields.add(fieldName);
            fields.add(fieldName + EXACT_MATCH_PROPERTY_NAME_SUFFIX);
        }
        this.removeFieldsFromDocument(element, fields);
    }

    public void addElements(Graph graph, Iterable<? extends Element> elements, Authorizations authorizations) {
        int totalCount = 0;
        HashMap<IndexInfo, BulkRequest> bulkRequests = new HashMap<IndexInfo, BulkRequest>();
        for (Element element : elements) {
            IndexInfo indexInfo = this.addPropertiesToIndex(graph, element, element.getProperties());
            BulkRequest bulkRequest = (BulkRequest)bulkRequests.get(indexInfo);
            if (bulkRequest == null) {
                bulkRequest = new BulkRequest();
                bulkRequests.put(indexInfo, bulkRequest);
            }
            if (bulkRequest.numberOfActions() >= 25000 || bulkRequest.estimatedSizeInBytes() > 0xF00000L) {
                LOGGER.debug("adding elements... %d (est size %d)", new Object[]{bulkRequest.numberOfActions(), bulkRequest.estimatedSizeInBytes()});
                totalCount += bulkRequest.numberOfActions();
                this.doBulkRequest(bulkRequest);
                bulkRequest = new BulkRequest();
                bulkRequests.put(indexInfo, bulkRequest);
            }
            this.addElementToBulkRequest(graph, bulkRequest, indexInfo, element, authorizations);
            this.getConfig().getScoringStrategy().addElement(this, graph, bulkRequest, indexInfo, element, authorizations);
        }
        for (BulkRequest bulkRequest : bulkRequests.values()) {
            if (bulkRequest.numberOfActions() <= 0) continue;
            LOGGER.debug("adding elements... %d (est size %d)", new Object[]{bulkRequest.numberOfActions(), bulkRequest.estimatedSizeInBytes()});
            totalCount += bulkRequest.numberOfActions();
            this.doBulkRequest(bulkRequest);
        }
        LOGGER.debug("added %d elements", new Object[]{totalCount});
        if (this.getConfig().isAutoFlush()) {
            this.flush(graph);
        }
    }

    public MultiVertexQuery queryGraph(Graph graph, String[] vertexIds, String queryString, Authorizations authorizations) {
        return new DefaultMultiVertexQuery(graph, vertexIds, queryString, authorizations);
    }

    public boolean isQuerySimilarToTextSupported() {
        return true;
    }

    public void flush(Graph graph) {
        this.flushFlushObjectQueue();
        this.client.admin().indices().prepareRefresh(this.getIndexNamesAsArray(graph)).execute().actionGet();
    }

    private void removeFieldsFromDocument(Element element, Collection<String> fields) {
        String script = "";
        HashMap params = Maps.newHashMap();
        int i = 0;
        for (String field : fields) {
            String fieldName = "fieldName" + i++;
            script = script + "ctx._source.remove(" + fieldName + ");";
            params.put(fieldName, field);
        }
        ((UpdateRequestBuilder)this.getClient().prepareUpdate().setIndex(this.getIndexName(element))).setId(element.getId()).setType(ELEMENT_TYPE).setScript(script, ScriptService.ScriptType.INLINE).setRetryOnConflict(10).setScriptParams((Map)params).get();
    }

    private void removeFieldsFromDocument(Element element, String field) {
        this.removeFieldsFromDocument(element, Lists.newArrayList((Object[])new String[]{field}));
    }

    private void flushFlushObjectQueue() {
        Queue<FlushObject> queue = this.getFlushObjectQueue();
        while (queue.size() > 0) {
            FlushObject flushObject = queue.remove();
            try {
                long t = flushObject.retryTime - System.currentTimeMillis();
                if (t > 0L) {
                    Thread.sleep(t);
                }
                flushObject.future.get(30L, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                String message = String.format("Could not write element \"%s\"", flushObject.elementId);
                if (flushObject.retryCount >= 10) {
                    throw new VertexiumException(message, (Throwable)ex);
                }
                String logMessage = String.format("%s: %s (retrying: %d/%d)", message, ex.getMessage(), flushObject.retryCount + 1, 10);
                if (flushObject.retryCount > 0) {
                    LOGGER.warn("%s", new Object[]{logMessage});
                } else {
                    LOGGER.debug("%s", new Object[]{logMessage});
                }
                ListenableActionFuture future = flushObject.actionRequestBuilder.execute();
                queue.add(new FlushObject(flushObject.elementId, flushObject.actionRequestBuilder, (Future)future, flushObject.retryCount + 1, System.currentTimeMillis() + (long)(flushObject.retryCount * 100) + (long)this.random.nextInt(500)));
            }
        }
        queue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getIndexNamesAsArray(Graph graph) {
        Map<String, IndexInfo> indexInfos = this.getIndexInfos(graph);
        if (indexInfos.size() == this.indexInfosLastSize) {
            return this.indexNamesAsArray;
        }
        ElasticsearchSingleDocumentSearchIndex elasticsearchSingleDocumentSearchIndex = this;
        synchronized (elasticsearchSingleDocumentSearchIndex) {
            Set<String> keys = indexInfos.keySet();
            this.indexNamesAsArray = keys.toArray(new String[keys.size()]);
            this.indexInfosLastSize = indexInfos.size();
            return this.indexNamesAsArray;
        }
    }

    public void shutdown() {
        this.client.close();
        if (this.inProcessNode != null) {
            this.inProcessNode.stop();
            this.inProcessNode = null;
        }
        if (this.propertyNameVisibilitiesStore instanceof Closeable) {
            try {
                ((Closeable)((Object)this.propertyNameVisibilitiesStore)).close();
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    protected String[] getIndexNames(PropertyDefinition propertyDefinition) {
        return this.indexSelectionStrategy.getIndexNames(this, propertyDefinition);
    }

    protected String getIndexName(Element element) {
        return this.indexSelectionStrategy.getIndexName(this, element);
    }

    protected String[] getIndicesToQuery() {
        return this.indexSelectionStrategy.getIndicesToQuery(this);
    }

    public boolean isFieldBoostSupported() {
        return true;
    }

    public IndexInfo addPropertiesToIndex(Graph graph, Element element, Iterable<Property> properties) {
        try {
            String indexName = this.getIndexName(element);
            IndexInfo indexInfo = this.ensureIndexCreatedAndInitialized(graph, indexName);
            for (Property property : properties) {
                this.addPropertyToIndex(graph, indexInfo, property);
            }
            return indexInfo;
        }
        catch (IOException e) {
            throw new VertexiumException("Could not add properties to index", (Throwable)e);
        }
    }

    protected void addPropertyToIndex(Graph graph, IndexInfo indexInfo, String propertyName, Visibility propertyVisibility, Class dataType, boolean analyzed) throws IOException {
        this.addPropertyToIndex(graph, indexInfo, propertyName, propertyVisibility, dataType, analyzed, null);
    }

    protected String deflatePropertyName(String propertyName) {
        return this.nameSubstitutionStrategy.deflate(propertyName);
    }

    protected boolean shouldIgnoreType(Class dataType) {
        return dataType == byte[].class;
    }

    protected void addTypeToMapping(XContentBuilder mapping, String propertyName, Class dataType, boolean analyzed, Double boost) throws IOException {
        if (dataType == String.class) {
            LOGGER.debug("Registering 'string' type for %s", new Object[]{propertyName});
            mapping.field("type", "string");
            if (!analyzed) {
                mapping.field("index", "not_analyzed");
                mapping.field("ignore_above", 10000);
            }
        } else if (dataType == IpV4Address.class) {
            LOGGER.debug("Registering 'ip' type for %s", new Object[]{propertyName});
            mapping.field("type", "ip");
        } else if (dataType == Float.class || dataType == Float.TYPE) {
            LOGGER.debug("Registering 'float' type for %s", new Object[]{propertyName});
            mapping.field("type", "float");
        } else if (dataType == Double.class || dataType == Double.TYPE) {
            LOGGER.debug("Registering 'double' type for %s", new Object[]{propertyName});
            mapping.field("type", "double");
        } else if (dataType == Byte.class || dataType == Byte.TYPE) {
            LOGGER.debug("Registering 'byte' type for %s", new Object[]{propertyName});
            mapping.field("type", "byte");
        } else if (dataType == Short.class || dataType == Short.TYPE) {
            LOGGER.debug("Registering 'short' type for %s", new Object[]{propertyName});
            mapping.field("type", "short");
        } else if (dataType == Integer.class || dataType == Integer.TYPE) {
            LOGGER.debug("Registering 'integer' type for %s", new Object[]{propertyName});
            mapping.field("type", "integer");
        } else if (dataType == Long.class || dataType == Long.TYPE) {
            LOGGER.debug("Registering 'long' type for %s", new Object[]{propertyName});
            mapping.field("type", "long");
        } else if (dataType == Date.class || dataType == DateOnly.class) {
            LOGGER.debug("Registering 'date' type for %s", new Object[]{propertyName});
            mapping.field("type", "date");
        } else if (dataType == Boolean.class || dataType == Boolean.TYPE) {
            LOGGER.debug("Registering 'boolean' type for %s", new Object[]{propertyName});
            mapping.field("type", "boolean");
        } else if (dataType == GeoPoint.class) {
            LOGGER.debug("Registering 'geo_point' type for %s", new Object[]{propertyName});
            mapping.field("type", "geo_point");
        } else if (dataType == GeoCircle.class) {
            LOGGER.debug("Registering 'geo_shape' type for %s", new Object[]{propertyName});
            mapping.field("type", "geo_shape");
            mapping.field("tree", "quadtree");
            mapping.field("precision", "100m");
        } else if (Number.class.isAssignableFrom(dataType)) {
            LOGGER.debug("Registering 'double' type for %s", new Object[]{propertyName});
            mapping.field("type", "double");
        } else {
            throw new VertexiumException("Unexpected value type for property \"" + propertyName + "\": " + dataType.getName());
        }
        if (boost != null) {
            mapping.field("boost", boost.doubleValue());
        }
    }

    protected void doBulkRequest(BulkRequest bulkRequest) {
        BulkResponse response = (BulkResponse)this.getClient().bulk(bulkRequest).actionGet();
        if (response.hasFailures()) {
            for (BulkItemResponse bulkResponse : response) {
                if (!bulkResponse.isFailed()) continue;
                LOGGER.error("Failed to index %s (message: %s)", new Object[]{bulkResponse.getId(), bulkResponse.getFailureMessage()});
            }
            throw new VertexiumException("Could not add element.");
        }
    }

    public synchronized void truncate(Graph graph) {
        LOGGER.warn("Truncate of Elasticsearch is not possible, dropping the indices and recreating instead.", new Object[0]);
        this.drop(graph);
    }

    public void drop(Graph graph) {
        Set<String> indexInfosSet = this.getIndexInfos(graph).keySet();
        for (String indexName : indexInfosSet) {
            try {
                DeleteIndexRequest deleteRequest = new DeleteIndexRequest(indexName);
                this.getClient().admin().indices().delete(deleteRequest).actionGet();
                this.getIndexInfos(graph).remove(indexName);
            }
            catch (Exception ex) {
                throw new VertexiumException("Could not delete index " + indexName, (Throwable)ex);
            }
            this.ensureIndexCreatedAndInitialized(graph, indexName);
        }
    }

    protected void addPropertyValueToPropertiesMap(Map<String, Object> propertiesMap, String propertyName, Object propertyValue) {
        Object existingValue = propertiesMap.get(propertyName);
        if (existingValue == null) {
            propertiesMap.put(propertyName, propertyValue);
            return;
        }
        if (existingValue instanceof List) {
            ((List)existingValue).add(propertyValue);
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(existingValue);
        list.add(propertyValue);
        propertiesMap.put(propertyName, list);
    }

    protected void convertGeoPoint(Graph graph, XContentBuilder jsonBuilder, Property property, GeoPoint geoPoint) throws IOException {
        HashMap<String, Double> propertyValueMap = new HashMap<String, Double>();
        propertyValueMap.put("lat", geoPoint.getLatitude());
        propertyValueMap.put("lon", geoPoint.getLongitude());
        jsonBuilder.field(this.deflatePropertyName(graph, property) + GEO_PROPERTY_NAME_SUFFIX, propertyValueMap);
        if (geoPoint.getDescription() != null) {
            jsonBuilder.field(this.deflatePropertyName(graph, property), geoPoint.getDescription());
        }
    }

    protected void convertGeoPoint(Graph graph, Map<String, Object> propertiesMap, Property property, GeoPoint geoPoint) {
        HashMap<String, Double> propertyValueMap = new HashMap<String, Double>();
        propertyValueMap.put("lat", geoPoint.getLatitude());
        propertyValueMap.put("lon", geoPoint.getLongitude());
        this.addPropertyValueToPropertiesMap(propertiesMap, this.deflatePropertyName(graph, property) + GEO_PROPERTY_NAME_SUFFIX, propertyValueMap);
        if (geoPoint.getDescription() != null) {
            this.addPropertyValueToPropertiesMap(propertiesMap, this.deflatePropertyName(graph, property), geoPoint.getDescription());
        }
    }

    protected void convertGeoCircle(Graph graph, XContentBuilder jsonBuilder, Property property, GeoCircle geoCircle) throws IOException {
        HashMap<String, Object> propertyValueMap = new HashMap<String, Object>();
        propertyValueMap.put("type", "circle");
        ArrayList<Double> coordinates = new ArrayList<Double>();
        coordinates.add(geoCircle.getLongitude());
        coordinates.add(geoCircle.getLatitude());
        propertyValueMap.put("coordinates", coordinates);
        propertyValueMap.put("radius", geoCircle.getRadius() + "km");
        jsonBuilder.field(this.deflatePropertyName(graph, property) + GEO_PROPERTY_NAME_SUFFIX, propertyValueMap);
        if (geoCircle.getDescription() != null) {
            jsonBuilder.field(this.deflatePropertyName(graph, property), geoCircle.getDescription());
        }
    }

    protected void convertGeoCircle(Graph graph, Map<String, Object> propertiesMap, Property property, GeoCircle geoCircle) {
        HashMap<String, Object> propertyValueMap = new HashMap<String, Object>();
        propertyValueMap.put("type", "circle");
        ArrayList<Double> coordinates = new ArrayList<Double>();
        coordinates.add(geoCircle.getLongitude());
        coordinates.add(geoCircle.getLatitude());
        propertyValueMap.put("coordinates", coordinates);
        propertyValueMap.put("radius", geoCircle.getRadius() + "km");
        this.addPropertyValueToPropertiesMap(propertiesMap, this.deflatePropertyName(graph, property) + GEO_PROPERTY_NAME_SUFFIX, propertyValueMap);
        if (geoCircle.getDescription() != null) {
            this.addPropertyValueToPropertiesMap(propertiesMap, this.deflatePropertyName(graph, property), geoCircle.getDescription());
        }
    }

    public IndexSelectionStrategy getIndexSelectionStrategy() {
        return this.indexSelectionStrategy;
    }

    public boolean isAuthorizationFilterEnabled() {
        return this.getConfig().isAuthorizationFilterEnabled();
    }

    protected void createIndex(String indexName) throws IOException {
        CreateIndexResponse createResponse = (CreateIndexResponse)this.client.admin().indices().prepareCreate(indexName).setSettings((Settings.Builder)ImmutableSettings.settingsBuilder().put("number_of_shards", this.getConfig().getNumberOfShards()).put("number_of_replicas", this.getConfig().getNumberOfReplicas())).execute().actionGet();
        ClusterHealthResponse health = (ClusterHealthResponse)this.client.admin().cluster().prepareHealth(new String[]{indexName}).setWaitForGreenStatus().execute().actionGet();
        LOGGER.debug("Index status: %s", new Object[]{health.toString()});
        if (health.isTimedOut()) {
            LOGGER.warn("timed out waiting for green index status, for index: %s", new Object[]{indexName});
        }
    }

    public Client getClient() {
        return this.client;
    }

    public ElasticSearchSearchIndexConfiguration getConfig() {
        return this.config;
    }

    public boolean isPropertyInIndex(Graph graph, String propertyName) {
        Map<String, IndexInfo> indexInfos = this.getIndexInfos(graph);
        for (Map.Entry<String, IndexInfo> entry : indexInfos.entrySet()) {
            if (!entry.getValue().isPropertyDefined(propertyName)) continue;
            return true;
        }
        return false;
    }

    private class FlushObject {
        public final String elementId;
        public final ActionRequestBuilder actionRequestBuilder;
        public final Future future;
        public final int retryCount;
        private final long retryTime;

        FlushObject(String elementId, UpdateRequestBuilder updateRequestBuilder, Future future) {
            this(elementId, (ActionRequestBuilder)updateRequestBuilder, future, 0, System.currentTimeMillis());
        }

        FlushObject(String elementId, ActionRequestBuilder actionRequestBuilder, Future future, int retryCount, long retryTime) {
            this.elementId = elementId;
            this.actionRequestBuilder = actionRequestBuilder;
            this.future = future;
            this.retryCount = retryCount;
            this.retryTime = retryTime;
        }
    }

    private static class StreamingPropertyString {
        private final String propertyValue;

        public StreamingPropertyString(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }
    }
}

