/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch;

import com.google.common.hash.Hashing;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.GraphMetadataEntry;
import org.vertexium.Visibility;
import org.vertexium.elasticsearch.PropertyNameVisibilitiesStore;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class MetadataTablePropertyNameVisibilitiesStore
extends PropertyNameVisibilitiesStore {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(MetadataTablePropertyNameVisibilitiesStore.class);
    public static final String PROPERTY_NAME_VISIBILITY_TO_HASH_PREFIX = "propertyNameVisibility.";
    public static final String HASH_TO_VISIBILITY = "visibilityHash.";
    private static final Charset UTF8 = Charset.forName("utf8");
    private Map<String, Visibility> visibilityCache = new HashMap<String, Visibility>();

    @Override
    public Collection<String> getHashes(Graph graph, String propertyName, Authorizations authorizations) {
        ArrayList<String> results = new ArrayList<String>();
        String prefix = this.getPropertyNameVisibilityToHashPrefix(propertyName);
        for (GraphMetadataEntry metadata : graph.getMetadataWithPrefix(prefix)) {
            String visibilityString = metadata.getKey().substring(prefix.length());
            Visibility visibility = this.getVisibility(visibilityString);
            if (!authorizations.canRead(visibility)) continue;
            String hash = (String)metadata.getValue();
            results.add(hash);
        }
        return results;
    }

    private Visibility getVisibility(String visibilityString) {
        Visibility visibility = this.visibilityCache.get(visibilityString);
        if (visibility == null) {
            visibility = new Visibility(visibilityString);
            this.visibilityCache.put(visibilityString, visibility);
        }
        return visibility;
    }

    @Override
    public String getHash(Graph graph, String propertyName, Visibility visibility) {
        String visibilityString = visibility.getVisibilityString();
        String propertyNameVisibilityToHashKey = this.getMetadataKey(propertyName, visibilityString);
        String hash = (String)graph.getMetadata(propertyNameVisibilityToHashKey);
        if (hash != null) {
            this.saveHashToVisibility(graph, hash, visibilityString);
            return hash;
        }
        hash = Hashing.murmur3_128().hashString((CharSequence)visibilityString, UTF8).toString();
        graph.setMetadata(propertyNameVisibilityToHashKey, (Object)hash);
        this.saveHashToVisibility(graph, hash, visibilityString);
        return hash;
    }

    private void saveHashToVisibility(Graph graph, String hash, String visibilityString) {
        String hashToVisibilityKey = this.getHashToVisibilityKey(hash);
        String foundVisibilityString = (String)graph.getMetadata(hashToVisibilityKey);
        if (foundVisibilityString == null) {
            graph.setMetadata(hashToVisibilityKey, (Object)visibilityString);
        }
    }

    @Override
    public Visibility getVisibilityFromHash(Graph graph, String visibilityHash) {
        String visibilityString = (String)graph.getMetadata(this.getHashToVisibilityKey(visibilityHash));
        if (visibilityString == null) {
            LOGGER.warn("Could not find visibility matching the hash \"%s\" in the metadata table.", new Object[]{visibilityHash});
            return null;
        }
        return new Visibility(visibilityString);
    }

    private String getHashToVisibilityKey(String visibilityHash) {
        return HASH_TO_VISIBILITY + visibilityHash;
    }

    private String getPropertyNameVisibilityToHashPrefix(String propertyName) {
        return PROPERTY_NAME_VISIBILITY_TO_HASH_PREFIX + propertyName + ".";
    }

    private String getMetadataKey(String propertyName, String visibilityString) {
        return this.getPropertyNameVisibilityToHashPrefix(propertyName) + visibilityString;
    }
}

