/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.inmemory;

import java.io.IOException;
import java.io.InputStream;
import org.vertexium.VertexiumException;
import org.vertexium.inmemory.InMemoryGraph;
import org.vertexium.inmemory.InMemoryStreamingPropertyValue;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.property.StreamingPropertyValueRef;
import org.vertexium.util.IOUtils;

class InMemoryStreamingPropertyValueRef
extends StreamingPropertyValueRef<InMemoryGraph> {
    private final byte[] valueData;

    InMemoryStreamingPropertyValueRef(StreamingPropertyValue value) {
        super(value);
        try {
            this.valueData = IOUtils.toBytes((InputStream)value.getInputStream());
        }
        catch (IOException ex) {
            throw new VertexiumException("Could not read streaming property value", (Throwable)ex);
        }
    }

    public StreamingPropertyValue toStreamingPropertyValue(InMemoryGraph graph) {
        return (StreamingPropertyValue)new InMemoryStreamingPropertyValue(this.valueData, this.getValueType()).store(this.isStore()).searchIndex(this.isSearchIndex());
    }
}

