/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.transform;

import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class EdgesVerticesMap {
    public static final String DIRECTION = Tokens.makeNamespace(EdgesVerticesMap.class) + ".direction";

    public static Configuration createConfiguration(Direction direction) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.set(DIRECTION, direction.name());
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, FaunusVertex, NullWritable, FaunusVertex> {
        private Direction direction;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.direction = Direction.valueOf((String)HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context).get(DIRECTION));
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            StandardFaunusEdge edge;
            StandardFaunusEdge edge2;
            long edgesProcessed;
            if (this.direction.equals((Object)Direction.IN) || this.direction.equals((Object)Direction.BOTH)) {
                edgesProcessed = 0L;
                for (Edge e : value.getEdges(Direction.IN, new String[0])) {
                    edge2 = (StandardFaunusEdge)e;
                    if (!edge2.hasPaths()) continue;
                    value.getPaths(edge2, true);
                    ++edgesProcessed;
                    edge2.clearPaths();
                }
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.IN_EDGES_PROCESSED, edgesProcessed);
            } else {
                for (Edge e : value.getEdges(Direction.IN, new String[0])) {
                    edge = (StandardFaunusEdge)e;
                    if (!edge.hasPaths()) continue;
                    edge.clearPaths();
                }
            }
            if (this.direction.equals((Object)Direction.OUT) || this.direction.equals((Object)Direction.BOTH)) {
                edgesProcessed = 0L;
                for (Edge e : value.getEdges(Direction.OUT, new String[0])) {
                    edge2 = (StandardFaunusEdge)e;
                    if (!edge2.hasPaths()) continue;
                    value.getPaths(edge2, true);
                    ++edgesProcessed;
                    edge2.clearPaths();
                }
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.OUT_EDGES_PROCESSED, edgesProcessed);
            } else {
                for (Edge e : value.getEdges(Direction.OUT, new String[0])) {
                    edge = (StandardFaunusEdge)e;
                    if (!edge.hasPaths()) continue;
                    edge.clearPaths();
                }
            }
            context.write((Object)NullWritable.get(), (Object)value);
        }
    }

    public static enum Counters {
        IN_EDGES_PROCESSED,
        OUT_EDGES_PROCESSED;

    }
}

