/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.transform;

import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.hadoop.FaunusElement;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.Holder;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class VerticesVerticesMapReduce {
    public static org.apache.hadoop.conf.Configuration createConfiguration(Direction direction, String ... labels) {
        ModifiableHadoopConfiguration c = ModifiableHadoopConfiguration.withoutResources();
        c.set(TitanHadoopConfiguration.VERTICES_VERTICES_DIRECTION, direction, new String[0]);
        c.set(TitanHadoopConfiguration.VERTICES_VERTICES_LABELS, labels, new String[0]);
        return c.getHadoopConfiguration();
    }

    public static class Reduce
    extends Reducer<LongWritable, Holder, NullWritable, FaunusVertex> {
        private Configuration faunusConf;

        public void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getJobContextConfiguration((JobContext)context));
        }

        public void reduce(LongWritable key, Iterable<Holder> values, Reducer.Context context) throws IOException, InterruptedException {
            FaunusVertex vertex = new FaunusVertex(this.faunusConf, key.get());
            for (Holder holder : values) {
                char tag = holder.getTag();
                if (tag == 'v') {
                    vertex.addAll((FaunusVertex)holder.get());
                    continue;
                }
                if (tag == 'p') {
                    vertex.getPaths((FaunusElement)holder.get(), true);
                    continue;
                }
                vertex.getPaths((FaunusElement)holder.get(), false);
            }
            context.write((Object)NullWritable.get(), (Object)vertex);
        }
    }

    public static class Map
    extends Mapper<NullWritable, FaunusVertex, LongWritable, Holder> {
        private Direction direction;
        private String[] labels;
        private Configuration faunusConf;
        private final Holder<FaunusVertex> holder = new Holder();
        private final LongWritable longWritable = new LongWritable();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getJobContextConfiguration((JobContext)context));
            this.direction = (Direction)this.faunusConf.get(TitanHadoopConfiguration.VERTICES_VERTICES_DIRECTION, new String[0]);
            this.labels = (String[])this.faunusConf.get(TitanHadoopConfiguration.VERTICES_VERTICES_LABELS, new String[0]);
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (value.hasPaths()) {
                FaunusVertex vertex;
                long edgesTraversed = 0L;
                if (this.direction.equals((Object)Direction.OUT) || this.direction.equals((Object)Direction.BOTH)) {
                    for (Edge edge : value.getEdges(Direction.OUT, this.labels)) {
                        vertex = new FaunusVertex(this.faunusConf, ((StandardFaunusEdge)edge).getVertexId(Direction.IN));
                        vertex.getPaths(value, false);
                        this.longWritable.set(vertex.getLongId());
                        context.write((Object)this.longWritable, this.holder.set('p', vertex));
                        ++edgesTraversed;
                    }
                }
                if (this.direction.equals((Object)Direction.IN) || this.direction.equals((Object)Direction.BOTH)) {
                    for (Edge edge : value.getEdges(Direction.IN, this.labels)) {
                        vertex = new FaunusVertex(this.faunusConf, ((StandardFaunusEdge)edge).getVertexId(Direction.OUT));
                        vertex.getPaths(value, false);
                        this.longWritable.set(vertex.getLongId());
                        context.write((Object)this.longWritable, this.holder.set('p', vertex));
                        ++edgesTraversed;
                    }
                }
                value.clearPaths();
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.EDGES_TRAVERSED, edgesTraversed);
            }
            this.longWritable.set(value.getLongId());
            context.write((Object)this.longWritable, this.holder.set('v', value));
        }
    }

    public static enum Counters {
        EDGES_TRAVERSED;

    }
}

