/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium;

import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.ElementBuilder;
import org.vertexium.Visibility;
import org.vertexium.mutation.EdgeMutation;
import org.vertexium.util.IncreasingTime;

public abstract class EdgeBuilderBase
extends ElementBuilder<Edge>
implements EdgeMutation {
    private final String edgeId;
    private final String label;
    private final Visibility visibility;
    private String newEdgeLabel;
    private long alterEdgeLabelTimestamp;

    protected EdgeBuilderBase(String edgeId, String label, Visibility visibility) {
        this.edgeId = edgeId;
        this.label = label;
        this.visibility = visibility;
        this.alterEdgeLabelTimestamp = IncreasingTime.currentTimeMillis();
    }

    public String getEdgeId() {
        return this.edgeId;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public long getAlterEdgeLabelTimestamp() {
        return this.alterEdgeLabelTimestamp;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public EdgeMutation alterEdgeLabel(String newEdgeLabel) {
        this.newEdgeLabel = newEdgeLabel;
        return this;
    }

    @Override
    public String getNewEdgeLabel() {
        return this.newEdgeLabel;
    }

    @Override
    public abstract Edge save(Authorizations var1);

    public abstract String getOutVertexId();

    public abstract String getInVertexId();

    @Override
    public boolean hasChanges() {
        if (this.newEdgeLabel != null) {
            return true;
        }
        return super.hasChanges();
    }
}

