/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.search;

import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.GraphConfiguration;
import org.vertexium.PropertyDescriptor;
import org.vertexium.SearchIndexSecurityGranularity;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;
import org.vertexium.query.DefaultGraphQuery;
import org.vertexium.query.DefaultMultiVertexQuery;
import org.vertexium.query.DefaultVertexQuery;
import org.vertexium.query.GraphQuery;
import org.vertexium.query.MultiVertexQuery;
import org.vertexium.query.SimilarToGraphQuery;
import org.vertexium.query.VertexQuery;
import org.vertexium.search.SearchIndex;
import org.vertexium.util.Preconditions;

public class DefaultSearchIndex
implements SearchIndex {
    public DefaultSearchIndex(GraphConfiguration configuration) {
    }

    @Override
    public void addElement(Graph graph, Element element, Authorizations authorizations) {
        Preconditions.checkNotNull(element, "element cannot be null");
    }

    @Override
    public void alterElementVisibility(Graph graph, Element element, Visibility oldVisibility, Visibility newVisibility, Authorizations authorizations) {
        Preconditions.checkNotNull(element, "element cannot be null");
        Preconditions.checkNotNull(newVisibility, "newVisibility cannot be null");
    }

    @Override
    public void deleteElement(Graph graph, Element element, Authorizations authorizations) {
        Preconditions.checkNotNull(element, "element cannot be null");
    }

    @Override
    public void deleteProperty(Graph graph, Element element, PropertyDescriptor property, Authorizations authorizations) {
        Preconditions.checkNotNull(element, "element cannot be null");
    }

    @Override
    public void addElements(Graph graph, Iterable<? extends Element> elements, Authorizations authorizations) {
        for (Element element : elements) {
            this.addElement(graph, element, authorizations);
        }
    }

    @Override
    public GraphQuery queryGraph(Graph graph, String queryString, Authorizations authorizations) {
        return new DefaultGraphQuery(graph, queryString, authorizations);
    }

    @Override
    public MultiVertexQuery queryGraph(Graph graph, String[] vertexIds, String queryString, Authorizations authorizations) {
        return new DefaultMultiVertexQuery(graph, vertexIds, queryString, authorizations);
    }

    @Override
    public VertexQuery queryVertex(Graph graph, Vertex vertex, String queryString, Authorizations authorizations) {
        return new DefaultVertexQuery(graph, vertex, queryString, authorizations);
    }

    @Override
    public void flush(Graph graph) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean isFieldBoostSupported() {
        return false;
    }

    @Override
    public void truncate(Graph graph) {
    }

    @Override
    public void drop(Graph graph) {
    }

    @Override
    public SearchIndexSecurityGranularity getSearchIndexSecurityGranularity() {
        return SearchIndexSecurityGranularity.PROPERTY;
    }

    @Override
    public boolean isQuerySimilarToTextSupported() {
        return false;
    }

    @Override
    public SimilarToGraphQuery querySimilarTo(Graph graph, String[] fields, String text, Authorizations authorizations) {
        throw new VertexiumException("querySimilarTo not supported");
    }

    @Override
    public boolean isFieldLevelSecuritySupported() {
        return true;
    }
}

