/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import org.cache2k.impl.BaseCache;
import org.cache2k.impl.IntegrityState;

public class LruCache<K, T>
extends BaseCache<Entry, K, T> {
    Entry<K, T> head;
    long hitCnt;

    @Override
    public long getHitCnt() {
        return this.hitCnt;
    }

    @Override
    protected void recordHit(Entry e) {
        this.removeEntryFromReplacementList(e);
        LruCache.insertInList(this.head, e);
        ++this.hitCnt;
    }

    @Override
    protected void insertIntoReplacementList(Entry e) {
        LruCache.insertInList(this.head, e);
    }

    @Override
    protected Entry newEntry() {
        return new Entry();
    }

    @Override
    protected Entry findEvictionCandidate() {
        return (Entry)this.head.prev;
    }

    @Override
    protected void initializeHeapCache() {
        super.initializeHeapCache();
        this.head = (Entry)new Entry().shortCircuit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IntegrityState getIntegrityState() {
        Object object = this.lock;
        synchronized (object) {
            return super.getIntegrityState().checkEquals("size = list entry count", this.getLocalSize(), LruCache.getListEntryCount(this.head));
        }
    }

    protected static class Entry<K, T>
    extends org.cache2k.impl.Entry<Entry<K, T>, K, T> {
        protected Entry() {
        }
    }
}

