/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.timer;

import org.cache2k.impl.timer.BaseTimerTask;
import org.cache2k.impl.timer.NoPayloadTask;
import org.cache2k.impl.timer.PayloadTask;
import org.cache2k.impl.timer.TimerListener;
import org.cache2k.impl.timer.TimerPayloadListener;
import org.cache2k.impl.timer.TimerService;
import org.cache2k.impl.util.Log;

public class ArrayHeapTimerQueue
extends TimerService {
    static final int MAXIMUM_ADDS_UNTIL_PURGE = 54321;
    static final int LAPSE_RESOLUTION = 10;
    static final int LAPSE_SIZE = 50;
    static final long KEEP_THREAD_WAITING_MILLIS = 17000L;
    Log log;
    int[] lapse = new int[50];
    long maxLapse = 0L;
    final Object lock = new Object();
    MyThread thread;
    String threadName;
    long eventsScheduled;
    long eventsDelivered;
    long wakeupCount;
    int addedWithoutPurge;
    int purgeCount;
    long cancelCount;
    long fireExceptionCount;
    Queue inQueue;
    Queue outQueue = this.inQueue = new Queue();

    public ArrayHeapTimerQueue(String _threadName) {
        this.threadName = _threadName;
        this.log = Log.getLog(ArrayHeapTimerQueue.class.getName() + ":" + _threadName);
    }

    @Override
    public NoPayloadTask add(TimerListener _listener, long _fireTime) {
        NoPayloadTask e2 = new NoPayloadTask(_fireTime, _listener);
        this.addTimerEvent(e2);
        return e2;
    }

    @Override
    public <T> PayloadTask<T> add(TimerPayloadListener<T> _listener, T _payload, long _fireTime) {
        PayloadTask<T> e2 = new PayloadTask<T>(_fireTime, _payload, _listener);
        this.addTimerEvent(e2);
        return e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQueueSize() {
        Queue q = this.inQueue;
        if (q == this.outQueue) {
            return q.size;
        }
        Object object = this.lock;
        synchronized (object) {
            return this.inQueue.size + this.outQueue.size;
        }
    }

    @Override
    public long getEventsDelivered() {
        return this.eventsDelivered;
    }

    @Override
    public long getPurgeCount() {
        return this.purgeCount;
    }

    @Override
    public long getEventsScheduled() {
        return this.eventsScheduled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCancelCount() {
        Object object = this.lock;
        synchronized (object) {
            MyThread th = this.thread;
            if (th != null) {
                return this.cancelCount + this.inQueue.cancelCount + th.cancelCount;
            }
            return this.cancelCount + this.inQueue.cancelCount;
        }
    }

    @Override
    public long getFireExceptionCount() {
        return this.fireExceptionCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTimerEvent(BaseTimerTask e) {
        Object object = this.lock;
        synchronized (object) {
            this.startThread();
            this.inQueue.addQueue(e);
            ++this.eventsScheduled;
            ++this.addedWithoutPurge;
            if (this.outQueue.getMin() == e) {
                this.lock.notify();
            }
        }
        if (this.addedWithoutPurge > 54321) {
            this.performPurge();
        }
    }

    private void startThread() {
        if (this.thread == null) {
            this.thread = new MyThread();
            this.thread.setName(this.threadName);
            this.thread.setDaemon(true);
            this.thread.timer = this;
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performPurge() {
        int _queueSizeBefore;
        Queue _purgeQ;
        Object object = this.lock;
        synchronized (object) {
            if (this.inQueue != this.outQueue || this.inQueue.size == 0) {
                return;
            }
            this.addedWithoutPurge = Integer.MIN_VALUE;
            this.cancelCount += this.inQueue.cancelCount;
            this.outQueue.cancelCount = 0L;
            _purgeQ = this.outQueue.copy();
            this.inQueue = new Queue();
            _queueSizeBefore = this.outQueue.size;
        }
        _purgeQ.purge();
        object = this.lock;
        synchronized (object) {
            BaseTimerTask t;
            boolean _somethingFired;
            boolean bl = _somethingFired = this.outQueue.size != _queueSizeBefore;
            if (_somethingFired) {
                BaseTimerTask _nextTimerTaskInQueue = this.outQueue.getNextNotCancelledMin();
                if (_nextTimerTaskInQueue == null) {
                    this.cancelCount += this.outQueue.cancelCount;
                    _purgeQ = new Queue();
                } else {
                    BaseTimerTask t2;
                    long _forwardUntilTime = _nextTimerTaskInQueue.getTime();
                    BaseTimerTask _previousSkippedTask = null;
                    while ((t2 = _purgeQ.getMin()).getTime() != _forwardUntilTime) {
                        if (t2.isCancelled()) {
                            ++_purgeQ.cancelCount;
                        }
                        _purgeQ.removeMin();
                        _previousSkippedTask = t2;
                    }
                }
            }
            while ((t = this.inQueue.getNextNotCancelledMin()) != null) {
                this.inQueue.removeMin();
                _purgeQ.addQueue(t);
            }
            this.cancelCount += this.inQueue.cancelCount;
            this.inQueue = this.outQueue = _purgeQ;
            this.addedWithoutPurge = 0;
            if (this.inQueue.size > 0) {
                this.startThread();
                this.lock.notify();
            }
            ++this.purgeCount;
        }
    }

    static class Queue {
        BaseTimerTask[] queue = new BaseTimerTask[128];
        int size = 0;
        long cancelCount = 0L;

        Queue() {
        }

        void addQueue(BaseTimerTask e) {
            ++this.size;
            if (this.size >= this.queue.length) {
                BaseTimerTask[] q2 = new BaseTimerTask[this.queue.length * 2];
                System.arraycopy(this.queue, 0, q2, 0, this.queue.length);
                this.queue = q2;
            }
            this.queue[this.size] = e;
            this.swim(this.size);
        }

        BaseTimerTask getMin() {
            return this.queue[1];
        }

        void removeMin() {
            this.queue[1] = this.queue[this.size];
            this.queue[this.size--] = null;
            this.sink(1);
        }

        BaseTimerTask getNextNotCancelledMin() {
            BaseTimerTask e = this.getMin();
            while (e != null && e.isCancelled()) {
                this.removeMin();
                ++this.cancelCount;
                e = this.getMin();
            }
            return e;
        }

        Queue copy() {
            Queue q = new Queue();
            q.size = this.size;
            q.queue = new BaseTimerTask[this.queue.length];
            System.arraycopy(this.queue, 0, q.queue, 0, this.queue.length);
            return q;
        }

        void purge() {
            BaseTimerTask[] q = this.queue;
            int _size = this.size;
            int i = 1;
            while (i <= _size) {
                if (q[i].isCancelled()) {
                    ++this.cancelCount;
                    q[i] = q[_size];
                    q[_size] = null;
                    --_size;
                    continue;
                }
                ++i;
            }
            this.size = _size;
            for (i = this.size / 2; i >= 1; --i) {
                this.sink(i);
            }
        }

        private static void swap(BaseTimerTask[] q, int j, int k) {
            BaseTimerTask tmp = q[j];
            q[j] = q[k];
            q[k] = tmp;
        }

        private void swim(int k) {
            BaseTimerTask[] q = this.queue;
            while (k > 1) {
                int j = k >> 1;
                if (q[j].time <= q[k].time) break;
                Queue.swap(q, j, k);
                k = j;
            }
        }

        private void sink(int k) {
            int j;
            BaseTimerTask[] q = this.queue;
            while ((j = k << 1) < this.size) {
                int _rightChild = j + 1;
                if (q[j].time > q[_rightChild].time) {
                    j = _rightChild;
                }
                if (q[k].time <= q[j].time) {
                    return;
                }
                Queue.swap(q, j, k);
                k = j;
            }
            if (j == this.size && q[k].time > q[j].time) {
                Queue.swap(q, j, k);
            }
        }
    }

    static class MyThread
    extends Thread {
        ArrayHeapTimerQueue timer;
        long cancelCount;

        MyThread() {
        }

        void fireTask(BaseTimerTask e) {
            try {
                boolean f = e.fire(e.getTime());
                if (f) {
                    ++this.timer.eventsDelivered;
                } else {
                    ++this.cancelCount;
                }
            }
            catch (Throwable ex) {
                ++this.timer.fireExceptionCount;
                this.timer.log.warn("timer event caused exception", ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int loop() {
            long t = System.currentTimeMillis();
            int fireCnt = 0;
            while (true) {
                long _fireTime;
                boolean _fires;
                BaseTimerTask e;
                Object object = this.timer.lock;
                synchronized (object) {
                    block9: {
                        Queue q = this.timer.outQueue;
                        while (true) {
                            boolean _fireWithinLock;
                            if ((e = q.getNextNotCancelledMin()) == null) {
                                return fireCnt;
                            }
                            _fires = false;
                            _fireTime = e.getTime();
                            if (_fireTime > t) {
                                t = System.currentTimeMillis();
                            }
                            if (_fireTime > t) break block9;
                            if (_fireTime < t) {
                                this.recordLapse(_fireTime, t);
                            }
                            q.removeMin();
                            BaseTimerTask _next = q.getMin();
                            boolean bl = _fireWithinLock = _next != null && _fireTime == _next.getTime();
                            if (!_fireWithinLock) break;
                            this.fireTask(e);
                            ++fireCnt;
                        }
                        _fires = true;
                    }
                }
                if (_fires) {
                    this.fireTask(e);
                    ++fireCnt;
                    continue;
                }
                long _waitTime = _fireTime - t;
                this.waitUntilTimeout(_waitTime);
            }
        }

        private void recordLapse(long _nextEvent, long now) {
            long d = now - _nextEvent;
            if (this.timer.maxLapse < d) {
                this.timer.maxLapse = d;
            }
            int idx = (int)(d / 10L);
            int[] ia = this.timer.lapse;
            if (idx < 0 || idx >= ia.length) {
                idx = ia.length - 1;
            }
            int n = idx;
            ia[n] = ia[n] + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitUntilTimeout(long _waitTime) {
            try {
                Object object = this.timer.lock;
                synchronized (object) {
                    this.timer.lock.wait(_waitTime);
                    ++this.timer.wakeupCount;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            try {
                while (this.loop() > 0) {
                    this.waitUntilTimeout(17000L);
                }
                this.timer.thread = null;
                this.timer.cancelCount += this.cancelCount;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

