/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.titan.hadoop.accumulo;

import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.formats.VertexQueryFilter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.mapreduce.AccumuloRowInputFormat;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.EdgeInfo;
import org.vertexium.GraphFactory;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.accumulo.AccumuloAuthorizations;
import org.vertexium.accumulo.AccumuloGraph;
import org.vertexium.accumulo.AccumuloGraphConfiguration;
import org.vertexium.accumulo.mapreduce.AccumuloVertexInputFormat;
import org.vertexium.accumulo.mapreduce.VertexiumMRUtils;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.util.MapUtils;

public class AccumuloVertexiumInputFormat
extends InputFormat<NullWritable, FaunusVertex>
implements Configurable {
    private final AccumuloRowInputFormat accumuloInputFormat = new AccumuloRowInputFormat();
    private org.apache.hadoop.conf.Configuration config;
    private VertexQueryFilter vertexQuery;

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        return this.accumuloInputFormat.getSplits(context);
    }

    public static void configure(Job job) {
        try {
            AccumuloGraphConfiguration accumuloGraphConfiguration = new AccumuloGraphConfiguration(job.getConfiguration(), "graph.");
            AccumuloGraph graph = AccumuloGraph.create((AccumuloGraphConfiguration)accumuloGraphConfiguration);
            String principal = accumuloGraphConfiguration.getAccumuloUsername();
            AuthenticationToken token = accumuloGraphConfiguration.getAuthenticationToken();
            String instanceName = accumuloGraphConfiguration.getAccumuloInstanceName();
            String zooKeepers = accumuloGraphConfiguration.getZookeeperServers();
            String[] authorizations = job.getConfiguration().get("titan.hadoop.input.authorizations", "").split(",");
            if (authorizations.length == 1 && authorizations[0].trim().length() == 0) {
                authorizations = new String[]{};
            }
            String tableName = graph.getVerticesTableName();
            AccumuloRowInputFormat.setInputTableName((Job)job, (String)tableName);
            AccumuloRowInputFormat.setConnectorInfo((Job)job, (String)principal, (AuthenticationToken)token);
            ClientConfiguration clientConfig = new ClientConfiguration(new Configuration[0]).withInstance(instanceName).withZkHosts(zooKeepers);
            AccumuloRowInputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)clientConfig);
            AccumuloRowInputFormat.setScanAuthorizations((Job)job, (org.apache.accumulo.core.security.Authorizations)new org.apache.accumulo.core.security.Authorizations(authorizations));
            job.getConfiguration().setStrings("authorizations", authorizations);
        }
        catch (Exception ex) {
            throw new VertexiumException("Could not configure", (Throwable)ex);
        }
    }

    public void setConf(org.apache.hadoop.conf.Configuration config) {
        this.config = config;
        this.vertexQuery = VertexQueryFilter.create((org.apache.hadoop.conf.Configuration)config);
    }

    public org.apache.hadoop.conf.Configuration getConf() {
        return this.config;
    }

    public RecordReader<NullWritable, FaunusVertex> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        final RecordReader reader = this.accumuloInputFormat.createRecordReader(inputSplit, taskAttemptContext);
        return new RecordReader<NullWritable, FaunusVertex>(){
            public FaunusVertex vertex;
            public AccumuloGraph graph;
            public Authorizations authorizations;

            public void initialize(InputSplit inputSplit, TaskAttemptContext ctx) throws IOException, InterruptedException {
                reader.initialize(inputSplit, ctx);
                Map configurationMap = VertexiumMRUtils.toMap((org.apache.hadoop.conf.Configuration)ctx.getConfiguration());
                this.graph = (AccumuloGraph)new GraphFactory().createGraph(MapUtils.getAllWithPrefix((Map)configurationMap, (String)"graph"));
                this.authorizations = new AccumuloAuthorizations(ctx.getConfiguration().getStrings("authorizations"));
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                if (!reader.nextKeyValue()) {
                    return false;
                }
                PeekingIterator row = (PeekingIterator)reader.getCurrentValue();
                this.vertex = AccumuloVertexiumInputFormat.this.createFaunusVertexFromRow(this.graph, (PeekingIterator<Map.Entry<Key, Value>>)row, this.authorizations);
                AccumuloVertexiumInputFormat.this.vertexQuery.defaultFilter(this.vertex);
                return true;
            }

            public NullWritable getCurrentKey() throws IOException, InterruptedException {
                return NullWritable.get();
            }

            public FaunusVertex getCurrentValue() throws IOException, InterruptedException {
                return this.vertex;
            }

            public float getProgress() throws IOException, InterruptedException {
                return reader.getProgress();
            }

            public void close() throws IOException {
                reader.close();
            }
        };
    }

    private FaunusVertex createFaunusVertexFromRow(AccumuloGraph graph, PeekingIterator<Map.Entry<Key, Value>> row, Authorizations authorizations) {
        Vertex v = AccumuloVertexInputFormat.createVertex((AccumuloGraph)graph, row, (Authorizations)authorizations);
        long vertexId = this.toFaunusVertexId(v.getId());
        FaunusVertex faunusVertex = new FaunusVertex();
        faunusVertex.setId(vertexId);
        faunusVertex.setVertexLabel(v.getId());
        faunusVertex.addProperty("vertexiumId", (Object)v.getId());
        for (Property property : v.getProperties()) {
            if (property.getValue() instanceof StreamingPropertyValue) continue;
            faunusVertex.addProperty(property.getName(), property.getValue());
        }
        for (EdgeInfo edgeInfo : v.getEdgeInfos(Direction.OUT, authorizations)) {
            faunusVertex.addEdge(com.tinkerpop.blueprints.Direction.OUT, edgeInfo.getLabel(), this.toFaunusVertexId(edgeInfo.getVertexId()));
        }
        for (EdgeInfo edgeInfo : v.getEdgeInfos(Direction.IN, authorizations)) {
            faunusVertex.addEdge(com.tinkerpop.blueprints.Direction.IN, edgeInfo.getLabel(), this.toFaunusVertexId(edgeInfo.getVertexId()));
        }
        return faunusVertex;
    }

    private long toFaunusVertexId(String id) {
        long h = 0L;
        for (char ch : id.toCharArray()) {
            h = 31L * h + (long)ch;
        }
        return Math.abs(h);
    }
}

