/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.netflix.astyanax.CassandraOperationType;
import com.netflix.astyanax.KeyspaceTracerFactory;
import com.netflix.astyanax.RowCopier;
import com.netflix.astyanax.connectionpool.ConnectionContext;
import com.netflix.astyanax.connectionpool.ConnectionPool;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.Operation;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.query.AllRowsQuery;
import com.netflix.astyanax.query.ColumnCountQuery;
import com.netflix.astyanax.query.ColumnFamilyQuery;
import com.netflix.astyanax.query.ColumnQuery;
import com.netflix.astyanax.query.CqlQuery;
import com.netflix.astyanax.query.IndexQuery;
import com.netflix.astyanax.query.RowQuery;
import com.netflix.astyanax.query.RowSliceColumnCountQuery;
import com.netflix.astyanax.query.RowSliceQuery;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.shallows.EmptyColumnList;
import com.netflix.astyanax.shallows.EmptyRowsImpl;
import com.netflix.astyanax.thrift.AbstractIndexQueryImpl;
import com.netflix.astyanax.thrift.AbstractKeyspaceOperationImpl;
import com.netflix.astyanax.thrift.AbstractRowQueryImpl;
import com.netflix.astyanax.thrift.AbstractRowSliceQueryImpl;
import com.netflix.astyanax.thrift.ThriftAllRowsQueryImpl;
import com.netflix.astyanax.thrift.ThriftConverter;
import com.netflix.astyanax.thrift.ThriftKeyspaceImpl;
import com.netflix.astyanax.thrift.model.ThriftColumnImpl;
import com.netflix.astyanax.thrift.model.ThriftColumnOrSuperColumnListImpl;
import com.netflix.astyanax.thrift.model.ThriftCounterColumnImpl;
import com.netflix.astyanax.thrift.model.ThriftCounterSuperColumnImpl;
import com.netflix.astyanax.thrift.model.ThriftRowsListImpl;
import com.netflix.astyanax.thrift.model.ThriftRowsSliceImpl;
import com.netflix.astyanax.thrift.model.ThriftSuperColumnImpl;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CounterSuperColumn;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SuperColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftColumnFamilyQueryImpl<K, C>
implements ColumnFamilyQuery<K, C> {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftColumnFamilyQueryImpl.class);
    final ConnectionPool<Cassandra.Client> connectionPool;
    final ColumnFamily<K, C> columnFamily;
    final KeyspaceTracerFactory tracerFactory;
    final ThriftKeyspaceImpl keyspace;
    ConsistencyLevel consistencyLevel;
    final ListeningExecutorService executor;
    Host pinnedHost;
    RetryPolicy retry;

    public ThriftColumnFamilyQueryImpl(ExecutorService executor, KeyspaceTracerFactory tracerFactory, ThriftKeyspaceImpl keyspace, ConnectionPool<Cassandra.Client> cp, ColumnFamily<K, C> columnFamily, ConsistencyLevel consistencyLevel, RetryPolicy retry) {
        this.keyspace = keyspace;
        this.connectionPool = cp;
        this.consistencyLevel = consistencyLevel;
        this.columnFamily = columnFamily;
        this.tracerFactory = tracerFactory;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        this.retry = retry;
    }

    public RowQuery<K, C> getKey(final K rowKey) {
        return new AbstractRowQueryImpl<K, C>(this.columnFamily.getColumnSerializer()){
            private boolean firstPage;
            {
                super(x0);
                this.firstPage = true;
            }

            public ColumnQuery<C> getColumn(final C column) {
                return new ColumnQuery<C>(){

                    public OperationResult<com.netflix.astyanax.model.Column<C>> execute() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover((Operation)new AbstractKeyspaceOperationImpl<com.netflix.astyanax.model.Column<C>>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_COLUMN, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                            @Override
                            public com.netflix.astyanax.model.Column<C> internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                                ColumnOrSuperColumn cosc = client.get(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(rowKey), new ColumnPath().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()).setColumn(ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer().toByteBuffer(column)), ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                                if (cosc.isSetColumn()) {
                                    Column c = cosc.getColumn();
                                    return new ThriftColumnImpl<Object>(ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer().fromBytes(c.getName()), c);
                                }
                                if (cosc.isSetSuper_column()) {
                                    SuperColumn sc = cosc.getSuper_column();
                                    return new ThriftSuperColumnImpl<Object>(ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer().fromBytes(sc.getName()), sc);
                                }
                                if (cosc.isSetCounter_column()) {
                                    CounterColumn c = cosc.getCounter_column();
                                    return new ThriftCounterColumnImpl<Object>(ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer().fromBytes(c.getName()), c);
                                }
                                if (cosc.isSetCounter_super_column()) {
                                    CounterSuperColumn sc = cosc.getCounter_super_column();
                                    return new ThriftCounterSuperColumnImpl<Object>(ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer().fromBytes(sc.getName()), sc);
                                }
                                throw new RuntimeException("Unknown column type in response");
                            }

                            @Override
                            public ByteBuffer getRowKey() {
                                return ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(rowKey);
                            }
                        }, ThriftColumnFamilyQueryImpl.this.retry);
                    }

                    public ListenableFuture<OperationResult<com.netflix.astyanax.model.Column<C>>> executeAsync() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<OperationResult<com.netflix.astyanax.model.Column<C>>>(){

                            @Override
                            public OperationResult<com.netflix.astyanax.model.Column<C>> call() throws Exception {
                                return this.execute();
                            }
                        });
                    }
                };
            }

            public OperationResult<ColumnList<C>> execute() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover((Operation)new AbstractKeyspaceOperationImpl<ColumnList<C>>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_ROW, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                    @Override
                    public ColumnList<C> execute(Cassandra.Client client, ConnectionContext context) throws ConnectionException {
                        if (isPaginating && paginateNoMore) {
                            return new EmptyColumnList();
                        }
                        return (ColumnList)super.execute(client, context);
                    }

                    @Override
                    public ColumnList<C> internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                        List columnList = client.get_slice(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(rowKey), new ColumnParent().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()), predicate, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                        if (isPaginating && predicate.isSetSlice_range()) {
                            if (columnList.size() != predicate.getSlice_range().getCount()) {
                                paginateNoMore = true;
                            }
                            if (firstPage) {
                                firstPage = false;
                                if (predicate.getSlice_range().getCount() != Integer.MAX_VALUE) {
                                    predicate.getSlice_range().setCount(predicate.getSlice_range().getCount() + 1);
                                }
                            } else if (!columnList.isEmpty()) {
                                columnList.remove(0);
                            }
                            if (!columnList.isEmpty()) {
                                ColumnOrSuperColumn last = (ColumnOrSuperColumn)Iterables.getLast((Iterable)columnList);
                                if (last.isSetColumn()) {
                                    predicate.getSlice_range().setStart(last.getColumn().getName());
                                } else if (last.isSetCounter_column()) {
                                    predicate.getSlice_range().setStart(last.getCounter_column().getName());
                                } else if (last.isSetSuper_column()) {
                                    predicate.getSlice_range().setStart(last.getSuper_column().getName());
                                } else if (last.isSetCounter_super_column()) {
                                    predicate.getSlice_range().setStart(last.getCounter_super_column().getName());
                                }
                            }
                        }
                        ThriftColumnOrSuperColumnListImpl result = new ThriftColumnOrSuperColumnListImpl(columnList, ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer());
                        return result;
                    }

                    @Override
                    public ByteBuffer getRowKey() {
                        return ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(rowKey);
                    }
                }, ThriftColumnFamilyQueryImpl.this.retry);
            }

            public ColumnCountQuery getCount() {
                return new ColumnCountQuery(){

                    public OperationResult<Integer> execute() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover((Operation)new AbstractKeyspaceOperationImpl<Integer>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_COLUMN_COUNT, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                            @Override
                            public Integer internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                                return client.get_count(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(rowKey), new ColumnParent().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()), predicate, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                            }

                            @Override
                            public ByteBuffer getRowKey() {
                                return ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(rowKey);
                            }
                        }, ThriftColumnFamilyQueryImpl.this.retry);
                    }

                    public ListenableFuture<OperationResult<Integer>> executeAsync() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.executor.submit((Callable)new Callable<OperationResult<Integer>>(){

                            @Override
                            public OperationResult<Integer> call() throws Exception {
                                return this.execute();
                            }
                        });
                    }
                };
            }

            public ListenableFuture<OperationResult<ColumnList<C>>> executeAsync() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<OperationResult<ColumnList<C>>>(){

                    @Override
                    public OperationResult<ColumnList<C>> call() throws Exception {
                        return this.execute();
                    }
                });
            }

            public RowCopier<K, C> copyTo(final ColumnFamily<K, C> otherColumnFamily, final K otherRowKey) {
                return new RowCopier<K, C>(){
                    private boolean useOriginalTimestamp = true;

                    public OperationResult<Void> execute() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover((Operation)new AbstractKeyspaceOperationImpl<Void>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.COPY_TO, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                            @Override
                            public Void internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                                long currentTime = ThriftColumnFamilyQueryImpl.this.keyspace.getConfig().getClock().getCurrentTime();
                                List columnList = client.get_slice(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(rowKey), new ColumnParent().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()), predicate, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                                ArrayList<Mutation> mutationList = new ArrayList<Mutation>();
                                for (ColumnOrSuperColumn sosc : columnList) {
                                    ColumnOrSuperColumn cosc;
                                    if (sosc.isSetColumn()) {
                                        cosc = new ColumnOrSuperColumn().setColumn(sosc.getColumn());
                                        if (!useOriginalTimestamp) {
                                            cosc.getColumn().setTimestamp(currentTime);
                                        }
                                    } else if (sosc.isSetSuper_column()) {
                                        cosc = new ColumnOrSuperColumn().setSuper_column(sosc.getSuper_column());
                                        if (!useOriginalTimestamp) {
                                            for (Column subColumn : sosc.getSuper_column().getColumns()) {
                                                subColumn.setTimestamp(currentTime);
                                                subColumn.setTimestamp(currentTime);
                                            }
                                        }
                                    } else if (sosc.isSetCounter_column()) {
                                        cosc = new ColumnOrSuperColumn().setCounter_column(sosc.getCounter_column());
                                    } else {
                                        if (!sosc.isSetCounter_super_column()) continue;
                                        cosc = new ColumnOrSuperColumn().setCounter_super_column(sosc.getCounter_super_column());
                                    }
                                    mutationList.add(new Mutation().setColumn_or_supercolumn(cosc));
                                }
                                HashMap mutationMap = new HashMap();
                                HashMap<String, ArrayList<Mutation>> cfmap = new HashMap<String, ArrayList<Mutation>>();
                                cfmap.put(otherColumnFamily.getName(), mutationList);
                                mutationMap.put(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(otherRowKey), cfmap);
                                client.batch_mutate(mutationMap, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                                return null;
                            }
                        }, ThriftColumnFamilyQueryImpl.this.retry);
                    }

                    public ListenableFuture<OperationResult<Void>> executeAsync() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.executor.submit((Callable)new Callable<OperationResult<Void>>(){

                            @Override
                            public OperationResult<Void> call() throws Exception {
                                return this.execute();
                            }
                        });
                    }

                    public RowCopier<K, C> withOriginalTimestamp(boolean useOriginalTimestamp) {
                        this.useOriginalTimestamp = useOriginalTimestamp;
                        return this;
                    }
                };
            }
        };
    }

    public RowSliceQuery<K, C> getKeyRange(final K startKey, final K endKey, final String startToken, final String endToken, final int count) {
        return new AbstractRowSliceQueryImpl<K, C>(this.columnFamily.getColumnSerializer()){

            public OperationResult<Rows<K, C>> execute() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover((Operation)new AbstractKeyspaceOperationImpl<Rows<K, C>>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_ROWS_RANGE, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                    @Override
                    public Rows<K, C> internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                        KeyRange range = new KeyRange();
                        if (startKey != null) {
                            range.setStart_key(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(startKey));
                        }
                        if (endKey != null) {
                            range.setEnd_key(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(endKey));
                        }
                        range.setCount(count).setStart_token(startToken).setEnd_token(endToken);
                        List keySlices = client.get_range_slices(new ColumnParent().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()), predicate, range, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                        if (keySlices == null || keySlices.isEmpty()) {
                            return new EmptyRowsImpl();
                        }
                        return new ThriftRowsSliceImpl(keySlices, ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer(), ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer());
                    }

                    @Override
                    public ByteBuffer getRowKey() {
                        if (startKey != null) {
                            return ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(startKey);
                        }
                        return null;
                    }
                }, ThriftColumnFamilyQueryImpl.this.retry);
            }

            public ListenableFuture<OperationResult<Rows<K, C>>> executeAsync() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<OperationResult<Rows<K, C>>>(){

                    @Override
                    public OperationResult<Rows<K, C>> call() throws Exception {
                        return this.execute();
                    }
                });
            }

            public RowSliceColumnCountQuery<K> getColumnCounts() {
                throw new RuntimeException("Not supported yet");
            }
        };
    }

    public RowSliceQuery<K, C> getKeySlice(final Iterable<K> keys) {
        return new AbstractRowSliceQueryImpl<K, C>(this.columnFamily.getColumnSerializer()){

            public OperationResult<Rows<K, C>> execute() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover((Operation)new AbstractKeyspaceOperationImpl<Rows<K, C>>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_ROWS_SLICE, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                    @Override
                    public Rows<K, C> internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                        Map cfmap = client.multiget_slice(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toBytesList(keys), new ColumnParent().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()), predicate, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                        if (cfmap == null || cfmap.isEmpty()) {
                            return new EmptyRowsImpl();
                        }
                        return new ThriftRowsListImpl(cfmap, ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer(), ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer());
                    }
                }, ThriftColumnFamilyQueryImpl.this.retry);
            }

            public ListenableFuture<OperationResult<Rows<K, C>>> executeAsync() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<OperationResult<Rows<K, C>>>(){

                    @Override
                    public OperationResult<Rows<K, C>> call() throws Exception {
                        return this.execute();
                    }
                });
            }

            public RowSliceColumnCountQuery<K> getColumnCounts() {
                return new RowSliceColumnCountQuery<K>(){

                    public OperationResult<Map<K, Integer>> execute() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover((Operation)new AbstractKeyspaceOperationImpl<Map<K, Integer>>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_ROWS_SLICE, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                            @Override
                            public Map<K, Integer> internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                                Map cfmap = client.multiget_count(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toBytesList(keys), new ColumnParent().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()), predicate, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                                if (cfmap == null || cfmap.isEmpty()) {
                                    return Maps.newHashMap();
                                }
                                return ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().fromBytesMap(cfmap);
                            }
                        }, ThriftColumnFamilyQueryImpl.this.retry);
                    }

                    public ListenableFuture<OperationResult<Map<K, Integer>>> executeAsync() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<OperationResult<Map<K, Integer>>>(){

                            @Override
                            public OperationResult<Map<K, Integer>> call() throws Exception {
                                return this.execute();
                            }
                        });
                    }
                };
            }
        };
    }

    public RowSliceQuery<K, C> getKeySlice(K[] keys) {
        return this.getKeySlice((Collection<K>)Arrays.asList(keys));
    }

    public RowSliceQuery<K, C> getKeySlice(final Collection<K> keys) {
        return new AbstractRowSliceQueryImpl<K, C>(this.columnFamily.getColumnSerializer()){

            public OperationResult<Rows<K, C>> execute() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover((Operation)new AbstractKeyspaceOperationImpl<Rows<K, C>>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_ROWS_SLICE, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                    @Override
                    public Rows<K, C> internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                        Map cfmap = client.multiget_slice(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toBytesList(keys), new ColumnParent().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()), predicate, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                        if (cfmap == null || cfmap.isEmpty()) {
                            return new EmptyRowsImpl();
                        }
                        return new ThriftRowsListImpl(cfmap, ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer(), ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer());
                    }

                    @Override
                    public ByteBuffer getRowKey() {
                        return null;
                    }
                }, ThriftColumnFamilyQueryImpl.this.retry);
            }

            public ListenableFuture<OperationResult<Rows<K, C>>> executeAsync() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<OperationResult<Rows<K, C>>>(){

                    @Override
                    public OperationResult<Rows<K, C>> call() throws Exception {
                        return this.execute();
                    }
                });
            }

            public RowSliceColumnCountQuery<K> getColumnCounts() {
                return new RowSliceColumnCountQuery<K>(){

                    public OperationResult<Map<K, Integer>> execute() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover((Operation)new AbstractKeyspaceOperationImpl<Map<K, Integer>>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_ROWS_SLICE, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                            @Override
                            public Map<K, Integer> internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                                Map cfmap = client.multiget_count(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toBytesList(keys), new ColumnParent().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()), predicate, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                                if (cfmap == null || cfmap.isEmpty()) {
                                    return Maps.newHashMap();
                                }
                                return ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().fromBytesMap(cfmap);
                            }

                            @Override
                            public ByteBuffer getRowKey() {
                                return null;
                            }
                        }, ThriftColumnFamilyQueryImpl.this.retry);
                    }

                    public ListenableFuture<OperationResult<Map<K, Integer>>> executeAsync() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<OperationResult<Map<K, Integer>>>(){

                            @Override
                            public OperationResult<Map<K, Integer>> call() throws Exception {
                                return this.execute();
                            }
                        });
                    }
                };
            }
        };
    }

    public ColumnFamilyQuery<K, C> setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public IndexQuery<K, C> searchWithIndex() {
        return new AbstractIndexQueryImpl<K, C>(this.columnFamily){

            public OperationResult<Rows<K, C>> execute() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover((Operation)new AbstractKeyspaceOperationImpl<Rows<K, C>>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_ROWS_BY_INDEX, this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                    @Override
                    public Rows<K, C> execute(Cassandra.Client client, ConnectionContext context) throws ConnectionException {
                        if (isPaginating && paginateNoMore) {
                            return new EmptyRowsImpl();
                        }
                        return (Rows)super.execute(client, context);
                    }

                    @Override
                    public Rows<K, C> internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                        List cfmap = client.get_indexed_slices(new ColumnParent().setColumn_family(columnFamily.getName()), indexClause, predicate, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                        if (cfmap == null) {
                            return new EmptyRowsImpl();
                        }
                        if (isPaginating) {
                            if (!firstPage && !cfmap.isEmpty() && ((KeySlice)cfmap.get(0)).bufferForKey().equals(indexClause.bufferForStart_key())) {
                                cfmap.remove(0);
                            }
                            try {
                                if (!cfmap.isEmpty()) {
                                    this.setNextStartKey(ByteBuffer.wrap(((KeySlice)Iterables.getLast((Iterable)cfmap)).getKey()));
                                } else {
                                    paginateNoMore = true;
                                }
                            }
                            catch (ArithmeticException e) {
                                paginateNoMore = true;
                            }
                        }
                        return new ThriftRowsSliceImpl(cfmap, columnFamily.getKeySerializer(), columnFamily.getColumnSerializer());
                    }
                }, ThriftColumnFamilyQueryImpl.this.retry);
            }

            public ListenableFuture<OperationResult<Rows<K, C>>> executeAsync() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<OperationResult<Rows<K, C>>>(){

                    @Override
                    public OperationResult<Rows<K, C>> call() throws Exception {
                        return this.execute();
                    }
                });
            }
        };
    }

    public CqlQuery<K, C> withCql(String cql) {
        return this.keyspace.cqlStatementFactory.createCqlQuery(this, cql);
    }

    public AllRowsQuery<K, C> getAllRows() {
        return new ThriftAllRowsQueryImpl(this);
    }

    public ColumnFamilyQuery<K, C> pinToHost(Host host) {
        this.pinnedHost = host;
        return this;
    }

    public ColumnFamilyQuery<K, C> withRetryPolicy(RetryPolicy retry) {
        this.retry = retry;
        return this;
    }

    public RowQuery<K, C> getRow(K rowKey) {
        return this.getKey(rowKey);
    }

    public RowSliceQuery<K, C> getRowRange(K startKey, K endKey, String startToken, String endToken, int count) {
        return this.getKeyRange(startKey, endKey, startToken, endToken, count);
    }

    public RowSliceQuery<K, C> getRowSlice(K ... keys) {
        return this.getKeySlice(keys);
    }

    public RowSliceQuery<K, C> getRowSlice(Collection<K> keys) {
        return this.getKeySlice(keys);
    }

    public RowSliceQuery<K, C> getRowSlice(Iterable<K> keys) {
        return this.getKeySlice(keys);
    }
}

