/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.iterator.model;

import org.apache.hadoop.io.Text;

public class HiddenProperty {
    private final String key;
    private final String name;
    private final String visibility;
    private final Text hiddenVisibility;

    public HiddenProperty(String key, String name, String visibility, Text hiddenVisibility) {
        this.key = key;
        this.name = name;
        this.visibility = visibility;
        this.hiddenVisibility = hiddenVisibility;
    }

    public boolean matches(String propertyKey, String propertyName, String visibility) {
        return propertyKey.equals(this.key) && propertyName.equals(this.name) && visibility.equals(this.visibility);
    }

    public Text getHiddenVisibility() {
        return this.hiddenVisibility;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiddenProperty that = (HiddenProperty)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.visibility != null ? !this.visibility.equals(that.visibility) : that.visibility != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.visibility != null ? this.visibility.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HiddenProperty{key='" + this.key + '\'' + ", name='" + this.name + '\'' + ", visibility='" + this.visibility + '\'' + '}';
    }
}

