/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.iterator.model;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.io.Text;
import org.vertexium.accumulo.iterator.model.EdgesWithEdgeInfo;
import org.vertexium.accumulo.iterator.model.ElementData;
import org.vertexium.accumulo.iterator.model.FetchHint;
import org.vertexium.accumulo.iterator.model.SoftDeleteEdgeInfo;
import org.vertexium.accumulo.iterator.util.DataOutputStreamUtils;

public class VertexElementData
extends ElementData {
    public final EdgesWithEdgeInfo outEdges = new EdgesWithEdgeInfo();
    public final EdgesWithEdgeInfo inEdges = new EdgesWithEdgeInfo();
    public final Set<Text> hiddenEdges = new HashSet<Text>();
    public final List<SoftDeleteEdgeInfo> outSoftDeletes = new ArrayList<SoftDeleteEdgeInfo>();
    public final List<SoftDeleteEdgeInfo> inSoftDeletes = new ArrayList<SoftDeleteEdgeInfo>();

    @Override
    public void clear() {
        super.clear();
        this.outEdges.clear();
        this.inEdges.clear();
        this.hiddenEdges.clear();
        this.outSoftDeletes.clear();
        this.inSoftDeletes.clear();
    }

    @Override
    protected void encode(DataOutputStream out, EnumSet<FetchHint> fetchHints) throws IOException {
        super.encode(out, fetchHints);
        DataOutputStreamUtils.encodeEdges(out, this.outEdges, fetchHints.contains((Object)FetchHint.OUT_EDGE_LABELS) && !fetchHints.contains((Object)FetchHint.OUT_EDGE_REFS));
        DataOutputStreamUtils.encodeEdges(out, this.inEdges, fetchHints.contains((Object)FetchHint.IN_EDGE_LABELS) && !fetchHints.contains((Object)FetchHint.IN_EDGE_REFS));
    }

    @Override
    protected byte getTypeId() {
        return 1;
    }
}

