/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.kryo.kryo.serializers;

import java.lang.reflect.Field;
import java.util.List;
import org.vertexium.kryo.kryo.serializers.FieldSerializer;
import org.vertexium.kryo.kryo.serializers.FieldSerializerUnsafeUtil;
import org.vertexium.kryo.kryo.serializers.UnsafeCacheFields;
import org.vertexium.kryo.kryo.util.IntArray;
import org.vertexium.kryo.kryo.util.UnsafeUtil;
import org.vertexium.kryo.minlog.Log;
import org.vertexium.kryo.reflectasm.FieldAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FieldSerializerUnsafeUtilImpl
implements FieldSerializerUnsafeUtil {
    private FieldSerializer serializer;

    public FieldSerializerUnsafeUtilImpl(FieldSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public void createUnsafeCacheFieldsAndRegions(List<Field> validFields, List<FieldSerializer.CachedField> cachedFields, int baseIndex, IntArray useAsm) {
        long startPrimitives = 0L;
        long endPrimitives = 0L;
        boolean lastWasPrimitive = false;
        int primitiveLength = 0;
        int lastAccessIndex = -1;
        Field lastField = null;
        long fieldOffset = -1L;
        long fieldEndOffset = -1L;
        long lastFieldEndOffset = -1L;
        int n = validFields.size();
        for (int i = 0; i < n; ++i) {
            Field field = validFields.get(i);
            int accessIndex = -1;
            if (this.serializer.access != null && useAsm.get(baseIndex + i) == 1) {
                accessIndex = ((FieldAccess)this.serializer.access).getIndex(field.getName());
            }
            fieldOffset = UnsafeUtil.unsafe().objectFieldOffset(field);
            fieldEndOffset = fieldOffset + (long)this.fieldSizeOf(field.getType());
            if (!field.getType().isPrimitive() && lastWasPrimitive) {
                endPrimitives = lastFieldEndOffset;
                lastWasPrimitive = false;
                if (primitiveLength > 1) {
                    if (Log.TRACE) {
                        Log.trace("kryo", "Class " + this.serializer.getType().getName() + ". Found a set of consecutive primitive fields. Number of fields = " + primitiveLength + ". Byte length = " + (endPrimitives - startPrimitives) + " Start offset = " + startPrimitives + " endOffset=" + endPrimitives);
                    }
                    UnsafeCacheFields.UnsafeRegionField cf = new UnsafeCacheFields.UnsafeRegionField(startPrimitives, endPrimitives - startPrimitives);
                    cf.field = lastField;
                    cachedFields.add(cf);
                } else if (lastField != null) {
                    cachedFields.add(this.serializer.newCachedField(lastField, cachedFields.size(), lastAccessIndex));
                }
                cachedFields.add(this.serializer.newCachedField(field, cachedFields.size(), accessIndex));
            } else if (!field.getType().isPrimitive()) {
                cachedFields.add(this.serializer.newCachedField(field, cachedFields.size(), accessIndex));
            } else if (!lastWasPrimitive) {
                startPrimitives = fieldOffset;
                lastWasPrimitive = true;
                primitiveLength = 1;
            } else {
                ++primitiveLength;
            }
            lastAccessIndex = accessIndex;
            lastField = field;
            lastFieldEndOffset = fieldEndOffset;
        }
        if (!this.serializer.getUseAsmEnabled() && this.serializer.getUseMemRegions() && lastWasPrimitive) {
            endPrimitives = lastFieldEndOffset;
            if (primitiveLength > 1) {
                if (Log.TRACE) {
                    Log.trace("kryo", "Class " + this.serializer.getType().getName() + ". Found a set of consecutive primitive fields. Number of fields = " + primitiveLength + ". Byte length = " + (endPrimitives - startPrimitives) + " Start offset = " + startPrimitives + " endOffset=" + endPrimitives);
                }
                UnsafeCacheFields.UnsafeRegionField cf = new UnsafeCacheFields.UnsafeRegionField(startPrimitives, endPrimitives - startPrimitives);
                cf.field = lastField;
                cachedFields.add(cf);
            } else if (lastField != null) {
                cachedFields.add(this.serializer.newCachedField(lastField, cachedFields.size(), lastAccessIndex));
            }
        }
    }

    private int fieldSizeOf(Class<?> clazz) {
        if (clazz == Integer.TYPE || clazz == Float.TYPE) {
            return 4;
        }
        if (clazz == Long.TYPE || clazz == Double.TYPE) {
            return 8;
        }
        if (clazz == Byte.TYPE || clazz == Boolean.TYPE) {
            return 1;
        }
        if (clazz == Short.TYPE || clazz == Character.TYPE) {
            return 2;
        }
        return UnsafeUtil.unsafe().addressSize();
    }

    @Override
    public long getObjectFieldOffset(Field field) {
        return UnsafeUtil.unsafe().objectFieldOffset(field);
    }
}

